#include "halPenAndKeys.h"
#include "machServices.h"
#include "kernel.h"
#include "dal.h"
#include "kal.h"

void hwrEventListen(void)
{
	struct HalEvtKey keyEvt = {0,};
	struct HalEvtPen penEvt = {0,};
	struct HyperHwrEvt evt;
	
	HALKeySetRates(200, 100, true);
	
	while (1) {
		
		int32_t type = -1;
		void* data;
		
		hyperCall(HYPER_GET_EVT_WAIT, &evt);
		
		switch (evt.type) {
			
			case HYPER_HWR_EVT_PEN_DOWN:
			case HYPER_HWR_EVT_PEN_MOVE:
				penEvt.x = evt.pen.x;
				penEvt.y = evt.pen.y;
	common_pen:
				type = HAL_EVENT_TYPE_PEN;
				data = &penEvt;
				break;
			case HYPER_HWR_EVT_PEN_UP:
				penEvt.x = -1;
				penEvt.y = -1;
				goto common_pen;
			case HYPER_HWR_EVT_RTC:
				type = HAL_EVENT_TYPE_CLOCK;
				data = NULL;
				break;
			case HYPER_HWR_EVT_KBD:
				type = HAL_EVENT_TYPE_KEY;
				keyEvt.ascii = evt.kbd.chr;
				if (evt.kbd.mods & HYPER_KEY_MOD_SHIFT)
					keyEvt.modifiers |= shiftKeyMask;
				if (evt.kbd.mods & HYPER_KEY_MOD_CAPSLOCK)
					keyEvt.modifiers |= capsLockMask;
				data = &keyEvt;
				break;
			case HYPER_HWR_EVT_HARDKEY:
				halHardKeyChanged(evt.hardkey.keyBit, evt.hardkey.down);
				break;
			case HYPER_VIRT_EVENT_TIMER:
				((KALTimerProcFn)evt.timer.fn)(evt.timer.userData);
				break;
			default:
				break;
		}
		if (type >= 0) 
			halCallEvtCallback(type, data);
	}
}