#ifndef _TIMERS_H_
#define _TIMERS_H_

#include <stdint.h>
#include "cpu.h"


//kernel-use timers. callbacks are in high-prio irq so be careful there
typedef uint32_t ktimer_t;

typedef void (*TimersTimerCbk)(ktimer_t timer, void* timerData);

void timersInit(void);
void timersCommonInit(void);	//do not call, just use timersInit();

ktimer_t timerCreate(uint32_t name, TimersTimerCbk cbk, void* cbkData, uint64_t ticks);
void timerDelete(ktimer_t tmr);

uint64_t timerGetTime(void);	//very precise systick-based time



//called by irqhandler
void timerExternalIrq(void);

#endif
