#include <stdbool.h>
#include "printf.h"
#include "irqs.h"
#include "cpu.h"
#include "ral.h"

typedef uint8_t irq_state_t;

#ifdef BUILDING_FOR_BIG_ARM
	#pragma GCC target ("arm")
#endif


irq_state_t __attribute__((noinline)) irqsAllOff(void)	//noinline will stop this form being inlined into thumb and them failing to link
{
	uint32_t ret, dummy;
	
	asm volatile(
		"	mrs  %0, CPSR		\n\t"
		"	orr  %1, %0, #0x80	\n\t"
		"	msr  CPSR_c, %1		\n\t"
		:"=&r"(ret), "=&r"(dummy)
		:
		:"memory"
	);
	
	return ret & 0x80;
}

irq_state_t __attribute__((noinline)) irqsAllOn(void)	//noinline will stop this form being inlined into thumb and them failing to link
{
	uint32_t ret, dummy;
	
	asm volatile(
		"	mrs  %0, CPSR		\n\t"
		"	bic  %1, %0, #0x80	\n\t"
		"	msr  CPSR_c, %1		\n\t"
		:"=&r"(ret), "=&r"(dummy)
		:
		:"memory"
	);
	
	return ret & 0x80;
}

void __attribute__((noinline)) irqsRestoreState(irq_state_t state)	//noinline will stop this form being inlined into thumb and them failing to link
{
	uint32_t dummy;
	
	asm volatile(
		"	mrs  %0, CPSR		\n\t"
		"	bic  %0, %0, #0x80	\n\t"
		"	orr  %0, %0, %1		\n\t"
		"	msr  CPSR_c, %0		\n\t"
		:"=&r"(dummy)
		:"r"(state)
		:"memory"
	);
}

bool __attribute__((noinline)) irqsAreAllOff(void)	//noinline will stop this form being inlined into thumb and them failing to link
{
	uint32_t ret;
	
	asm volatile(
		"	mrs  %0, CPSR		\n\t"
		:"=&r"(ret)
		:
		:"memory"
	);
	
	return !!(ret & 0x80);
}
