#ifndef _K_IRQS_CORTEX_H_
#define _K_IRQS_CORTEX_H_

#include <stdbool.h>
#include <stdint.h>
#include "cpu.h"
#include "dal.h"


static __INLINE bool NVIC_IsEnabledIRQ(IRQn_Type IRQn)
{
	return (NVIC->ISER[((uint32_t)(IRQn) >> 5)] >> ((uint32_t)(IRQn) & 0x1F)) & 1;
}


#endif
