#ifndef _K_IRQS_H_
#define _K_IRQS_H_

#include <stdbool.h>
#include <stdint.h>
#include "cpu.h"
#include "dal.h"

typedef uint8_t irq_state_t;

#define CORTEX_SR_FLAG_Q				0x08000000UL	//v5T+ only
#define CORTEX_SR_FLAG_T				0x01000000UL	//v7 only

#define CORTEX_SR_FLAG_FRAMEPTRALIGN	0x00000200UL

#define LEGACY_SR_FLAG_T				0x00000020

struct CortexExcFrame {
	uint32_t r0, r1, r2, r3;
	uint32_t r12, lr, pc, sr;
};

#ifdef BUILD_FOR_THUMB_1

	struct CortexPushedRegs {	//when we push regs, we push them in this order. here for unification
		uint32_t regs8_11[4];
		uint32_t regs4_7[4];
		
		uint32_t control;		//only sometimes, only OUT
	};
	
#else

	struct CortexPushedRegs {	//when we push regs, we push them in this order. here for unification
		uint32_t regs4_7[4];
		uint32_t regs8_11[4];
		
		uint32_t control;		//only sometimes, only OUT
	};
	
#endif

irq_state_t irqsAllOn(void);
irq_state_t irqsAllOff(void);
void irqsRestoreState(irq_state_t state);
bool irqsAreAllOff(void);		//and i do mean ALL!

#define CORTEX_EXC_NUM_NMI					2
#define CORTEX_EXC_NUM_HARD_FAULT			3
#define CORTEX_EXC_NUM_MEM_MANAGE_FAULT		4
#define CORTEX_EXC_NUM_BUS_FAULT			5
#define CORTEX_EXC_NUM_USAGE_FAULT			6
#define CORTEX_EXC_NUM_DEBUG_MON			12


bool cpuIrqGetHandler(uint32_t irqNo, HalIrqHandlerF *curHandlerP, void** curUserDataP);
bool cpuIrqSetHandler(uint32_t irqNo, HalIrqHandlerF newHandler, void* newUserData);
bool cpuIrqSetState(uint32_t irqNo, bool on);


void cpuIrqDefaultHandler(void);


#endif
