#ifndef _RESPRING_VISOR_COMMS_H_
#define _RESPRING_VISOR_COMMS_H_


#include <stdbool.h>
#include <stdint.h>

#include "remoteioCommsProto.h"
#include "halDrawing.h"			//for struct PalmClut


void remoteioCommsEarlyInit(void);			//as early as possible, does not need much
void remoteioCommsLateInit(void);			//when irqs are available please
const struct MsgContinueBoot* remoteioCommsWaitForContinueBooot(void);

const struct MsgBatteryInfo* remoteioCommsGetBatteryInfo(void);	//gets current snapshot, requests another

void remoteioCommsSetBrightness(uint8_t val);
void remoteioCommsSetBacklight(bool on);
void remoteioCommsSetContrast(uint8_t val);
void remoteioCommsSetScreenDepth(uint8_t val);
void remoteioCommsSetScreenClut(uint32_t nEntries, const struct PalmClutEntry *entries);

void remoteioCommsRequestScreenRedraw(void *data, uint32_t len, bool is16bitData);	//data MUST be 2-byte aligned and remain valid until remoteioCommsIsScreenRedrawDone() returns true
bool remoteioCommsIsScreenRedrawDone(void);

typedef void (*VisorCommsButtonStateCbk)(uint32_t state);
typedef void (*VisorCommsPenStateCbk)(int16_t x, int16_t y);

void remoteioCommsSetInputHandlers(VisorCommsButtonStateCbk btnF, VisorCommsPenStateCbk penF);

void remoteioCommsLedControl(uint32_t pattern, uint16_t csecPerPiece, uint16_t csecBetween, uint16_t numTimes);

void remoteioCommsBreakLocks(void);

//exported

bool* remoteioCommsUpdateStart(volatile void **stateP); //call ONCE to init the process. any other visor comms calls after this WILL fail, use pointer then for remoteioCommsUpdateProgress
													//wait till returned bool is FALSE before MANDATORILY disabling interrupts
static inline void remoteioCommsUpdateProgress(volatile void* state, uint8_t percent)
{
	volatile uint16_t *sta = state;
	uint32_t i;
	
	for (i = 0; i < 8; i++)
		sta[0] = percent;
	for (i = 0; i < 8; i++)
		sta[2] = MSG_C_UPDATE;
	for (i = 0; i < 8; i++)
		sta[6] = MSG_MRK_REPLY;
}

void remoteioCommsMsgCopyToSram(const void *srcP, uint32_t bytes, uint32_t dstOffsetHalfwords);
void remoteioCommsCopyMsgFromSram(void *dstP, uint32_t bytes, uint32_t skipHalfwordUpFront);

typedef bool (*VisorCommsSerRxHandler)(void *userData, uint16_t *replyMsgTypeP);	//true to send a reply now
typedef bool (*VisorCommsOpReplyHandler)(void *userData, uint16_t *replyMsgTypeP);	//true to send a reply now
typedef bool (*VisorCommsTxReplyHandler)(void *userData, uint16_t *replyMsgTypeP);	//true to send a reply now

bool remoteioCommsSerInit(VisorCommsSerRxHandler rxF, VisorCommsOpReplyHandler replyF, VisorCommsTxReplyHandler txReplyF, void* cbkData);
void remoteioCommsSerDeinit(void);
bool remoteioCommsSerOp(void *msgToSend, uint16_t len);
bool remoteioCommsSerTx(void *msgToSend, uint16_t len);
void remoteioCommsGetBufSzs(uint32_t *toVisorBytesP, uint32_t *fromVisorBytesP);

#endif
