#ifndef _MSIO_COMMS_H_
#define _MSIO_COMMS_H_


#include <stdbool.h>
#include <stdint.h>

#include "msioCommsProto.h"
#include "halDrawing.h"			//for struct PalmClut

typedef void (*MsioCommsRtcSecondCbkF)(uint32_t curTime, bool alarm);

void msioCommsInit(void);			//when irqs are available please
const struct MsioPktBootParams* msioCommsWaitForContinueBoot(void);		//endian-swapped!!!!
void msioCommsBreakLocks(void);

void msioCommsSetBrightness(uint8_t val);
void msioCommsSetBacklight(bool on);
void msioCommsSetContrast(uint8_t val);
void msioCommsSetScreenDepth(uint8_t val);
void msioCommsSetScreenClut(const struct PalmClutEntry *clut, uint_fast16_t nEntries);

void msioCommsRequestScreenRedraw(const void *data, uint32_t len, uint_fast8_t thisDepth);	//data is compressed and copied out. when this returns, we're done with it. might over-read by ~ 3 bytes
bool msioCommsIsScreenRedrawDone(void);

typedef void (*MsioCommsButtonStateCbk)(uint32_t keysState, const uint16_t *keyboardStates);
typedef void (*MsioCommsPenStateCbk)(int16_t x, int16_t y);

void msioCommsSetInputHandlers(MsioCommsButtonStateCbk btnF, MsioCommsPenStateCbk penF);

void msioCommsVibAndLedControl(bool led, uint32_t pattern, uint16_t csecPerPiece, uint16_t csecBetween, uint16_t numTimes);

const struct MsioPktBattInfo* msioCommsGetBatteryInfo(void);	//gets current snapshot, requests another

void msioCommsRtcSetSecondCbk(MsioCommsRtcSecondCbkF cbkF);
void msioCommsRtcSetRtc(uint32_t at);
void msioCommsRtcSetAlarm(uint32_t val);



#endif
