#ifndef _PINOUT_H_
#define _PINOUT_H_


#ifdef WAVESHARE_PINOUT

	#define PIN_SDIO_CLK	5		//sdio mode only
	#define PIN_LCD_DnC		8
	#define PIN_LCD_CS		9		//active low
	#define PIN_SPI_CLK		10		//	|
	#define PIN_SPI_MOSI	11		//	 | -spi1
	#define PIN_SPI_MISO	12		//	|
	#define PIN_LCD_BL		13		//backlight enable: Active high, PWM-able
	#define PIN_LCD_RESET	15		//active low
	#define PIN_TOUCH_CS	16		//active low
	#define PIN_TOUCH_IRQ	17
	#define PIN_SDIO_CMD	18		//sdio mode only
	#define PIN_SDIO_D0		19		//sdio mode only
	#define PIN_SDIO_D1		20		//sdio mode only
	#define PIN_SDIO_D2		21		//sdio mode only
	#define PIN_SDIO_D3_CS	22		//sdio mode only as D3, active low as SD nCS
	#define PIN_REG_MODE	23		//power supply mode (0 = better efficiency whic is especialyl noticeable at low loads, 1 = less ripple)
	#define PIN_VBUS_SENSE	24		//vbus sense (Active high)
	#define PIN_LED			25		//led - active high
	#define PIN_VSYS_DIV3	29		//ADC: VSYS/3

#endif

#ifdef PALMCARD_PINOUT 

	//palm data iface
	#define PIN_DQ0			0
	#define PIN_DQ1			1
	#define PIN_DQ2			2
	#define PIN_DQ3			3
	#define PIN_DQ4			4
	#define PIN_DQ5			5
	#define PIN_DQ6			6
	#define PIN_DQ7			7
	#define PIN_DQ8			8
	#define PIN_DQ9			9
	#define PIN_DQ10		10
	#define PIN_DQ11		11
	#define PIN_DQ12		12
	#define PIN_DQ13		13
	#define PIN_DQ14		14
	#define PIN_DQ15		15
	
	//palm chip selects
	#define PIN_CSA0		16
	#define PIN_CSA2		17
	
	//palm misc
	#define PIN_IRQ3		18
	#define PIN_A1			28		//pin is RnW in rev1hw and needs a greenwire to A1
	#define PIN_nOE			29
	
	//our memory
	#define PIN_RAMnFLASH	19		//low to access flash, high to access RAM. MUST stay high
	
	//IrDA
	#define PIN_IRDA_OUT	20
	#define PIN_IRDA_IN		21
	
	//Boards labeled "v1.1" had no i2c expander and the folowing pinout:
	//#define PIN_IRDA_nEN	22
	//#define PIN_SD_nDET	23
	//#define PIN_LED_CTL	25
	
	//I2C
	#define PIN_SDA			22
	#define PIN_SCL			23
	
	//SD
	#define PIN_SD_DAT0		24
	#define PIN_SD_DET		25
	#define PIN_SD_CLK		26
	#define PIN_SD_CMD		27
	
	//pins on the io expander
	#define XPIN_RSTCTL		0		//controls if external reset affects us (high for "no", HiZ for "yes")
	#define XPIN_RSTPALM	1		//allows reset of palm (and maybe ourselves if XPIN_RSTCTL is not properly set up)
	#define XPIN_LED		2		//active high LED on
	#define XPIN_IRDA_nEN	3		//active low IrDA enable
	#define XPIN_SD_nEN		4		//active low SD card power (card detect depends on this being ebaled as well due to how it works)
	#define XPIN_RAMnROM	5		//low to access flash, high to access RAM. MUST stay high
	
	
#endif


#endif

