
//should match what entry.c for this machine actually configures

#define CPU_ROM_BASE								0x10001000
#define CPU_ROM_SIZE								0x001ff000

#ifdef USE_XRAM_FOR_DYNHEAP
	#define HAL_STATIC_MEM2_SIZE					0x00035000									//goes to start of vram, large due to stacks
#else
	#define HAL_STATIC_MEM2_SIZE					0x00005000									//goes to start of vram
#endif

#define CPU_HARDWIRED_VRAM_ADDR						(0x20040780 - CPU_HARDWIRED_VRAM_SIZE)		//goes to start of kernel bss/data section

#define HAL_STATIC_MEM_BASE							0x50100600
#define HAL_STATIC_MEM_SIZE							0x00000a00



//autogenerated
#define HAL_STATIC_MEM2_BASE						(CPU_HARDWIRED_VRAM_ADDR - HAL_STATIC_MEM2_SIZE)

#ifdef WAVESHARE_MEMMAP

	#define CPU_STORAGE_RAM_BASE					0x20000000
	#define CPU_STORAGE_RAM_SIZE					0x00010000
	
	#define CPU_DYN_RAM_BASE						0x20010000

	#define CPU_DYN_RAM_SIZE						(HAL_STATIC_MEM2_BASE - CPU_DYN_RAM_BASE)

#endif

#ifdef ROMRAM_MEMMAP

	//actual address range. for our stuff to work, the stuff that is never writeable should come first,
	// then the stuff whose writeabiliy we want to edit, and then the stuff that is to be always
	// writeable. For us this means ROM, storage heap, our DAL stuf (like jit cache)
	#define ROMRAM_BASE								0x10000000
	#define ROMRAM_SIZE								0x00800000
	#define ROMRAM_SZ_MPU							MPU_REGION_SZ_8MB
	

	#ifdef USE_XRAM_FOR_DYNHEAP
		
		#define CPU_RAM_STOLEN_AT_END				0x00100000
		
	#else

		#define CPU_RAM_STOLEN_AT_END				0x00000000
		#define CPU_DYN_RAM_BASE					0x20000000
		#define CPU_DYN_RAM_SIZE					(HAL_STATIC_MEM2_BASE - CPU_DYN_RAM_BASE)
	
	#endif
	
	#ifdef JIT_ENABLED
		
		#define CPU_STORAGE_RAM_BASE				0x10200000
		#define CPU_STORAGE_RAM_SIZE				(0x005c0000 - CPU_RAM_STOLEN_AT_END)
		
		//TC for ui thread (250K)
		#define CPU_HARDWIRED_UI_THREAD_JIT_TC_BASE	0x107c0000
		#define CPU_HARDWIRED_UI_THREAD_JIT_TC_SIZE	0x0003e000
	
	#else
	
		#define CPU_STORAGE_RAM_BASE				0x10200000
		#define CPU_STORAGE_RAM_SIZE				(0x005fe000 - CPU_RAM_STOLEN_AT_END)
	
	#endif
	
	#ifdef USE_XRAM_FOR_DYNHEAP
		
		#define CPU_DYN_RAM_BASE					(CPU_STORAGE_RAM_BASE + CPU_STORAGE_RAM_SIZE)
		#define CPU_DYN_RAM_SIZE					CPU_RAM_STOLEN_AT_END
		
	#endif
	
#endif
