#ifndef _HW_CPU_H_
#define _HW_CPU_H_

#include <stdint.h>

//rp2040 doesnt define these
#define __MPU_PRESENT	1
#define __VTOR_PRESENT	1

//renaming
#define SVCall_IRQn		SVC_IRQn

#include "rp2040.h"

#define SYSTICK_CLOCKS_PER_TIMER_TICK					128								//better be a constant power of 2 or else bad bad bad slow int64 division
#define TIMER_TICKS_PER_MSEC							((CPU_CLOCK_RATE + 500) / 1000)	//this is in "systicks"

#define CPU_NUM_IRQS									25

static inline void cpuPutchar(char ch)
{
	volatile uint32_t* buf = (volatile uint32_t*)0x20041FF8;
	uint32_t timeout = 0;
		
	while (buf[0] & 0x80000000) {
		if (++timeout == 1<<20)
			return;
	}
	buf[0] = 0x80000000 | (uint8_t)ch;
}

void rp2040rtInit(void);

#ifdef ROMRAM_MEMMAP
	#define XRAM1 __attribute__((section(".xram")))
#endif

#endif


