#ifndef _INPUT_IFACE_H_
#define _INPUT_IFACE_H_

#define INPUT_UNIT_BASE			0x40001000UL
#define INPUT_UNIT_SIZE			0x00000018UL

#define INPUT_IRQ_NO			0		//irq happens if btn or pen value changed **since last read** OR if a new keyboard key has been enqueued
#define JOYSTICK_IRQ_NO			7		//fired on periodic poll

#define INPUT_OFST_BTN_STATE	0x00	//RO bitfield
#define INPUT_OFST_PEN_STATE	0x04	//RO. {0x80000000 - isDown, 0x00FFF000 - x, 0x00000FFF - y}
#define INPUT_OFST_KBD_STATE	0x08	//RO. {0x80000000 - has valid key code, 0x000F0000 - key modifier bits, 0x000000FFFF - key code }

#define INPUT_OFST_JOYSTICK_X	0x0C	//RO, signed joystick x
#define INPUT_OFST_JOYSTICK_Y	0x10	//RO, signed joystick x
#define INPUT_OFST_JOY_INTERVAL	0x14	//RW, in milliseconds. zero for off


//these match palm definitions so i dont have to convert them. Live with it
#define INPUT_KEY_BIT_POWER			0x00000001
#define INPUT_KEY_BIT_PG_UP			0x00000002
#define INPUT_KEY_BIT_PG_DN			0x00000004
#define INPUT_KEY_BIT_APP_1			0x00000008
#define INPUT_KEY_BIT_APP_2			0x00000010
#define INPUT_KEY_BIT_APP_3			0x00000020
#define INPUT_KEY_BIT_APP_4			0x00000040
#define INPUT_KEY_BIT_HOTSYNC		0x00000080

#define INPUT_KEY_BIT_JOG_UP		0x00001000
#define INPUT_KEY_BIT_JOG_DN		0x00002000
#define INPUT_KEY_BIT_JOG_SEL		0x00004000
#define INPUT_KEY_BIT_JOG_BACK		0x00008000

#define INPUT_KEY_BIT_ROCKER_UP		0x00010000
#define INPUT_KEY_BIT_ROCKER_DN		0x00020000
#define INPUT_KEY_BIT_ROCKER_LT		0x00040000
#define INPUT_KEY_BIT_ROCKER_RT		0x00080000
#define INPUT_KEY_BIT_ROCKER_SEL	0x00100000


#define INPUT_KBD_MOD_SHIFT			1
#define INPUT_KBD_MOD_CAPSLOCK		2



#endif