#include "emuJitInternal.h"
#include "printf.h"
#include "emit.h"


//translating itself is not speed critical - let's save size
#pragma GCC push_options
#pragma GCC optimize("Os")

enum EmitStatus jitEmitQadd(struct EmitBuf *dest, enum EmitCc cc, uint32_t instrAddr, uint32_t rdNo, uint32_t rnNo, uint32_t rmNo)
{
	struct JitSimpleSpStatus sta;
	struct EmitBuf ccSkip;
	enum EmitStatus now;
	
	//we only bother with "IT" if no SP or PC since else it gets messy
	if (!(((1 << rdNo) | (1 << rnNo) | (1 << rmNo)) & ((1 << EMIT_REG_NO_SP) | (1 << EMIT_REG_NO_PC)))) {
		
		if (cc != EmitCcAl)
			EMIT(LLit, cc);
		
		EMIT(LLqadd, rdNo, rnNo, rmNo);
	}
	else {
		
		if (cc != EmitCcAl)
			EMIT(SaveSpace, &ccSkip, 1);
		
		now = jitPrvHandleSpStart(dest, instrAddr, &sta, &rdNo, NULL, &rdNo, &rmNo, NULL);
		if (now != EmitErrNone)
			return now;
		
		EMIT(LLqadd, rdNo, rnNo, rmNo);

		now = jitPrvHandleSpEnd(dest, &sta);
		if (now != EmitErrNone)
			return now;
		
		if (cc != EmitCcAl)
			EMIT_TO(LLbranch, &ccSkip, emitGetPtrToJumpHere(dest), emitCcInvert(cc));
	}
	
	return EmitErrNone;
}

enum EmitStatus jitEmitQsub(struct EmitBuf *dest, enum EmitCc cc, uint32_t instrAddr, uint32_t rdNo, uint32_t rnNo, uint32_t rmNo)
{
	struct JitSimpleSpStatus sta;
	struct EmitBuf ccSkip;
	enum EmitStatus now;
	
	//we only bother with "IT" if no SP or PC since else it gets messy
	if (!(((1 << rdNo) | (1 << rnNo) | (1 << rmNo)) & ((1 << EMIT_REG_NO_SP) | (1 << EMIT_REG_NO_PC)))) {
		
		if (cc != EmitCcAl)
			EMIT(LLit, cc);
		EMIT(LLqsub, rdNo, rnNo, rmNo);
	}
	else {
		
		if (cc != EmitCcAl)
			EMIT(SaveSpace, &ccSkip, 1);
		
		now = jitPrvHandleSpStart(dest, instrAddr, &sta, &rdNo, NULL, &rdNo, &rmNo, NULL);
		if (now != EmitErrNone)
			return now;
		
		EMIT(LLqsub, rdNo, rnNo, rmNo);

		now = jitPrvHandleSpEnd(dest, &sta);
		if (now != EmitErrNone)
			return now;
		
		if (cc != EmitCcAl)
			EMIT_TO(LLbranch, &ccSkip, emitGetPtrToJumpHere(dest), emitCcInvert(cc));
	}
	
	return EmitErrNone;
}

enum EmitStatus jitEmitQdadd(struct EmitBuf *dest, enum EmitCc cc, uint32_t instrAddr, uint32_t rdNo, uint32_t rnNo, uint32_t rmNo)
{
	struct JitSimpleSpStatus sta;
	struct EmitBuf ccSkip;
	enum EmitStatus now;
	
	//we only bother with "IT" if no SP or PC since else it gets messy
	if (!(((1 << rdNo) | (1 << rnNo) | (1 << rmNo)) & ((1 << EMIT_REG_NO_SP) | (1 << EMIT_REG_NO_PC)))) {
		
		if (cc != EmitCcAl)
			EMIT(LLit, cc);
		EMIT(LLqdadd, rdNo, rnNo, rmNo);
	}
	else {
		
		if (cc != EmitCcAl)
			EMIT(SaveSpace, &ccSkip, 1);
		
		now = jitPrvHandleSpStart(dest, instrAddr, &sta, &rdNo, NULL, &rdNo, &rmNo, NULL);
		if (now != EmitErrNone)
			return now;
		
		EMIT(LLqdadd, rdNo, rnNo, rmNo);
	
		now = jitPrvHandleSpEnd(dest, &sta);
		if (now != EmitErrNone)
			return now;
		
		if (cc != EmitCcAl)
			EMIT_TO(LLbranch, &ccSkip, emitGetPtrToJumpHere(dest), emitCcInvert(cc));
	}
	
	return EmitErrNone;
}

enum EmitStatus jitEmitQdsub(struct EmitBuf *dest, enum EmitCc cc, uint32_t instrAddr, uint32_t rdNo, uint32_t rnNo, uint32_t rmNo)
{
	struct JitSimpleSpStatus sta;
	struct EmitBuf ccSkip;
	enum EmitStatus now;
	
	//we only bother with "IT" if no SP or PC since else it gets messy
	if (!(((1 << rdNo) | (1 << rnNo) | (1 << rmNo)) & ((1 << EMIT_REG_NO_SP) | (1 << EMIT_REG_NO_PC)))) {
		
		if (cc != EmitCcAl)
			EMIT(LLit, cc);
		EMIT(LLqdsub, rdNo, rnNo, rmNo);
	}
	else {
		
		if (cc != EmitCcAl)
			EMIT(SaveSpace, &ccSkip, 1);
		
		now = jitPrvHandleSpStart(dest, instrAddr, &sta, &rdNo, NULL, &rdNo, &rmNo, NULL);
		if (now != EmitErrNone)
			return now;
		
		EMIT(LLqdsub, rdNo, rnNo, rmNo);
	
		now = jitPrvHandleSpEnd(dest, &sta);
		if (now != EmitErrNone)
			return now;
		
		if (cc != EmitCcAl)
			EMIT_TO(LLbranch, &ccSkip, emitGetPtrToJumpHere(dest), emitCcInvert(cc));
	}
	
	return EmitErrNone;
}

enum EmitStatus jitEmitSmulxy(struct EmitBuf *dest, enum EmitCc cc, uint32_t instrAddr, uint32_t rdNo, uint32_t rnNo, uint32_t rmNo, bool nTop, bool mTop)
{
	struct JitSimpleSpStatus sta;
	struct EmitBuf ccSkip;
	enum EmitStatus now;
	
	//we only bother with "IT" if no SP or PC since else it gets messy
	if (!(((1 << rdNo) | (1 << rnNo) | (1 << rmNo)) & ((1 << EMIT_REG_NO_SP) | (1 << EMIT_REG_NO_PC)))) {
		
		if (cc != EmitCcAl)
			EMIT(LLit, cc);
		EMIT(LLsmulxy, rdNo, rnNo, rmNo, nTop, mTop);
	}
	else {
		
		if (cc != EmitCcAl)
			EMIT(SaveSpace, &ccSkip, 1);
		
		now = jitPrvHandleSpStart(dest, instrAddr, &sta, &rdNo, NULL, &rdNo, &rmNo, NULL);
		if (now != EmitErrNone)
			return now;
		
		EMIT(LLsmulxy, rdNo, rnNo, rmNo, nTop, mTop);
	
		now = jitPrvHandleSpEnd(dest, &sta);
		if (now != EmitErrNone)
			return now;
		
		if (cc != EmitCcAl)
			EMIT_TO(LLbranch, &ccSkip, emitGetPtrToJumpHere(dest), emitCcInvert(cc));
	}
	
	return EmitErrNone;
}

enum EmitStatus jitEmitSmlaxy(struct EmitBuf *dest, enum EmitCc cc, uint32_t instrAddr, uint32_t rdNo, uint32_t rnNo, uint32_t rmNo, uint32_t raNo, bool nTop, bool mTop)
{
	struct JitSimpleSpStatus sta;
	struct EmitBuf ccSkip;
	enum EmitStatus now;
	
	//we only bother with "IT" if no SP or PC since else it gets messy
	if (!(((1 << rdNo) | (1 << rnNo) | (1 << rmNo) | (1 << raNo)) & ((1 << EMIT_REG_NO_SP) | (1 << EMIT_REG_NO_PC)))) {
		
		if (cc != EmitCcAl)
			EMIT(LLit, cc);
		EMIT(LLsmlaxy, rdNo, rnNo, rmNo, raNo, nTop, mTop);
	}
	else {
		
		if (cc != EmitCcAl)
			EMIT(SaveSpace, &ccSkip, 1);
		
		now = jitPrvHandleSpStart(dest, instrAddr, &sta, &rdNo, NULL, &rdNo, &rmNo, &raNo, NULL);
		if (now != EmitErrNone)
			return now;
		
		EMIT(LLsmlaxy, rdNo, rnNo, rmNo, raNo, nTop, mTop);
	
		now = jitPrvHandleSpEnd(dest, &sta);
		if (now != EmitErrNone)
			return now;
		
		if (cc != EmitCcAl)
			EMIT_TO(LLbranch, &ccSkip, emitGetPtrToJumpHere(dest), emitCcInvert(cc));
	}
	
	return EmitErrNone;
}

enum EmitStatus jitEmitSmulwy(struct EmitBuf *dest, enum EmitCc cc, uint32_t instrAddr, uint32_t rdNo, uint32_t rnNo, uint32_t rmNo, bool mTop)
{
	struct JitSimpleSpStatus sta;
	struct EmitBuf ccSkip;
	enum EmitStatus now;
	
	//we only bother with "IT" if no SP or PC since else it gets messy
	if (!(((1 << rdNo) | (1 << rnNo) | (1 << rmNo)) & ((1 << EMIT_REG_NO_SP) | (1 << EMIT_REG_NO_PC)))) {
		
		if (cc != EmitCcAl)
			EMIT(LLit, cc);
		EMIT(LLsmulwy, rdNo, rnNo, rmNo, mTop);
	}
	else {
		
		if (cc != EmitCcAl)
			EMIT(SaveSpace, &ccSkip, 1);
		
		now = jitPrvHandleSpStart(dest, instrAddr, &sta, &rdNo, NULL, &rdNo, &rmNo, NULL);
		if (now != EmitErrNone)
			return now;
		
		EMIT(LLsmulwy, rdNo, rnNo, rmNo, mTop);
	
		now = jitPrvHandleSpEnd(dest, &sta);
		if (now != EmitErrNone)
			return now;
		
		if (cc != EmitCcAl)
			EMIT_TO(LLbranch, &ccSkip, emitGetPtrToJumpHere(dest), emitCcInvert(cc));
	}
	
	return EmitErrNone;
}

enum EmitStatus jitEmitSmlawy(struct EmitBuf *dest, enum EmitCc cc, uint32_t instrAddr, uint32_t rdNo, uint32_t rnNo, uint32_t rmNo, uint32_t raNo, bool mTop)
{
	struct JitSimpleSpStatus sta;
	struct EmitBuf ccSkip;
	enum EmitStatus now;
	
	//we only bother with "IT" if no SP or PC since else it gets messy
	if (!(((1 << rdNo) | (1 << rnNo) | (1 << rmNo) | (1 << raNo)) & ((1 << EMIT_REG_NO_SP) | (1 << EMIT_REG_NO_PC)))) {
		
		if (cc != EmitCcAl)
			EMIT(LLit, cc);
		EMIT(LLsmlawy, rdNo, rnNo, rmNo, raNo, mTop);
	}
	else {
		
		if (cc != EmitCcAl)
			EMIT(SaveSpace, &ccSkip, 1);
		
		now = jitPrvHandleSpStart(dest, instrAddr, &sta, &rdNo, NULL, &rdNo, &rmNo, &raNo, NULL);
		if (now != EmitErrNone)
			return now;
		
		EMIT(LLsmlawy, rdNo, rnNo, rmNo, raNo, mTop);
	
		now = jitPrvHandleSpEnd(dest, &sta);
		if (now != EmitErrNone)
			return now;
		
		if (cc != EmitCcAl)
			EMIT_TO(LLbranch, &ccSkip, emitGetPtrToJumpHere(dest), emitCcInvert(cc));
	}
	
	return EmitErrNone;
}

enum EmitStatus jitEmitSmlalxy(struct EmitBuf *dest, enum EmitCc cc, uint32_t instrAddr, uint32_t rdLoNo, uint32_t rdHiNo, uint32_t rnNo, uint32_t rmNo, bool nTop, bool mTop)
{
	struct JitSimpleSpStatus sta;
	struct EmitBuf ccSkip;
	enum EmitStatus now;
	
	//we only bother with "IT" if no SP or PC since else it gets messy
	if (!(((1 << rdLoNo) | (1 << rdHiNo) | (1 << rnNo) | (1 << rmNo)) & ((1 << EMIT_REG_NO_SP) | (1 << EMIT_REG_NO_PC)))) {
		
		if (cc != EmitCcAl)
			EMIT(LLit, cc);
		EMIT(LLsmlalxy, rdLoNo, rdHiNo, rnNo, rmNo, nTop, mTop);
	}
	else {
		
		if (cc != EmitCcAl)
			EMIT(SaveSpace, &ccSkip, 1);
		
		now = jitPrvHandleSpStart(dest, instrAddr, &sta, &rdLoNo, &rdHiNo, &rnNo, &rmNo, NULL);
		if (now != EmitErrNone)
			return now;
		
		EMIT(LLsmlalxy, rdLoNo, rdHiNo, rnNo, rmNo, nTop, mTop);
	
		now = jitPrvHandleSpEnd(dest, &sta);
		if (now != EmitErrNone)
			return now;
		
		if (cc != EmitCcAl)
			EMIT_TO(LLbranch, &ccSkip, emitGetPtrToJumpHere(dest), emitCcInvert(cc));
	}
	
	return EmitErrNone;
}
