#include "disp.h"
#include "mach.h"
#include "hyper.h"
#include "printf.h"
#include "heap.h"
#include "dal.h"
#include "kal.h"


static volatile uint32_t mRefreshThread;
static uint32_t mClutCurrentRGBA8888[256];
static uint16_t mDispW, mDispH;
static uint8_t mCurDepth;
static void* mFb;


static void halDisplayRefreshThread(void* unused)		//XXX: this is not clever on real hw where we do not need a thread!
{
	while (1) {
		
		logt("disp refresh!\n");
		halDisplayRefreshManual();
		KALTaskDelay(33);
	}
}

bool dispDrvInit(uint16_t *wP, uint16_t* hP, uint16_t* densityP, uint16_t *realDpiP, uint16_t *supportedDepthMapP, void** framebufferP, bool *indexedFmtIsLEP)
{
	uint64_t t = hyperCall(HYPER_DISP_GET_SIZE, NULL);
	uint32_t w, h;
		
	mDispW = w = *wP = t;
	mDispH = h = *hP = t >> 16;
	*densityP = t >> 32;
	*supportedDepthMapP = ((1 << 16) | (1 << 8) | (1 << 4) | (1 << 2) | (1 << 1)) >> 1;
	mCurDepth = 16;
	*realDpiP = 72;
	*indexedFmtIsLEP = false;
	
	mFb = *framebufferP = kheapAlloc(w * h * sizeof(uint16_t));
	
	return true;
}

void dispSetClut(int32_t firstIdx, uint32_t numEntries, const struct PalmClutEntry *entries)
{
	uint32_t i;
	
	if (firstIdx == -1) {
		
		if (numEntries > 256)
			return;
	}
	else if (firstIdx < 0)
		return;
	else if (firstIdx >= 256 || numEntries + firstIdx > 256)
		return;

	for (i = 0; i < numEntries; i++) {
		
		uint32_t where = (firstIdx == -1) ? entries[i].idx : i + firstIdx;
		uint32_t r = entries[i].r;
		uint32_t g = entries[i].g;
		uint32_t b = entries[i].b;
		
		mClutCurrentRGBA8888[where] = (r << 24) + (g << 16) + (b << 8);
	}
}

void dispManualUpdate(void)
{
	struct HyDispUpdt hy = {.data = mFb, .depth = mCurDepth, .clut = mClutCurrentRGBA8888,};
		
	hyperCall(HYPER_DISP_UPDATE, &hy);
}

void dispRequestUpdate(void)
{
	Err e;
	
	if (!mRefreshThread) {	//need init?
		
		static const struct KalTaskCreateInfo tci = {.codeToRun = halDisplayRefreshThread, .stackSz = 8192, .prio = 1, .tag = CREATE_4CC('_','s','r','f'), };	//very high prio
		
		//make sure enough of the system i sup to do this (we need MemMgr)
		e = KALTaskCreate((uint32_t*)&mRefreshThread, &tci);
		if (e)
			fatal("Cannot create screen refresh thread\n");
		
		e = KALTaskStart(mRefreshThread, NULL);
		if (e)
			fatal("Cannot start screen refresh thread\n");
	}
}

void dispSetDepth(uint32_t depth)
{
	mCurDepth = depth;
}

void dispSetBri(uint8_t bri)
{
	//no
}

void dispSetContrast(uint8_t bri)
{
	//no
}

bool dispSetBacklight(bool on)
{
	return false;	//not switchable
}

bool dispGetBacklight(void)
{
	return true;	//always on
}