#ifndef _HW_VIB_AND_LED_H_
#define _HW_VIB_AND_LED_H_

#include <stdbool.h>
#include <stdint.h>

struct HwVibAndLedConfig {
	uint32_t pattern;
	uint16_t csecPerPattern;		//centisecs
	uint16_t csecBetween;			//centisecs
	uint16_t numTimes;
};

#ifndef VIB_AND_LED_USE_SIMPLE_DRIVER

	//the platform vibrator and LED driver may either implement this interface (eg if there is some chip/EC/something that drives the LED/vib and acts independently)
	//or it may define VIB_AND_LED_USE_SIMPLE_DRIVER and then implement the simple interface described below

	bool vibAndLedHwIsSupported(bool led);
	void vibAndLedHwStart(bool led, const struct HwVibAndLedConfig* cfg);		//struct is copied
	void vibAndLedHwStop(bool led);
	bool vibAndLedHwIsActive(bool led);

#else
	
	//funcs must exit anyways no matter what, even if not supported
	void vibAndLedSimpleSetVibState(bool on);
	void vibAndLedSimpleSetLedState(bool on);

#endif




#endif
