#include "xscaleScreen.h"
#include <MemoryMgr.h>
#include "platform.h"
#include <string.h>
#include "disp.h"
#include "printf.h"
#include "memmap.h"
#include "boot.h"
#include "heap.h"
#include "cpu.h"
#include "dal.h"
#include "kal.h"


#define DISP_WIDTH				320
#define DISP_HEIGHT				480
#define DISP_DENSITY			144



static uint8_t mCurDepth;

void dispSetBri(uint8_t bri)
{
	struct PxaPwm *pwm =  platPeriphP2V(PXA_BASE_PWM1);
	
	pwm->DUTY = bri;
}

void dispSetContrast(uint8_t bri)
{
	//not doable on this board	
}

bool dispSetBacklight(bool on)
{
	return false;	//not switchable
}

bool dispGetBacklight(void)
{
	return true;	//always on
}

static uint32_t dispPrvRGB888toRGB565(uint32_t r, uint32_t g, uint32_t b)
{
	return ((r & 0xf8) << 8) | ((g & 0xfc) << 3) | ((b & 0xf8) >> 3);
}

static bool dispPrvEnable(void)		//assumes disabled
{
	return xscaleScreenEnable(0x003008F1, 0x1F030D3F, 0x070801DF, 0x04700004);
}

bool dispDrvInit(uint16_t *wP, uint16_t* hP, uint16_t* densityP, uint16_t *realDpiP, uint16_t *supportedDepthMapP, void** framebufferP, bool *indexedFmtIsLEP)
{
	struct PxaPwm *pwm =  platPeriphP2V(PXA_BASE_PWM1);
	uint32_t i;
	
	//give clock to LCD and PWM1
	platEnablePeriphClock(XSCALE_CLOCK_ID_LCD, true);
	platEnablePeriphClock(XSCALE_CLOCK_ID_PWM1, true);
	
	//gpios control
	for (i = 58; i <= 77; i++) {
		
		platGpioSetDir(i, true);
		platGpioSetFunc(i, 2);
	}
	
	//backlight PWM
	platGpioSetDir(17, true);
	platGpioSetFunc(17, 2);
	
	*wP = DISP_WIDTH;
	*hP = DISP_HEIGHT;
	*densityP = DISP_DENSITY;
	*realDpiP = 149;	//calculated using a ruler
	*supportedDepthMapP = ((1 << 1) | (1 << 2) | (1 << 4) | (1 << 8) | (1 << 16)) >> 1;
	*framebufferP = xscaleScreenGetFbPtr();
	*indexedFmtIsLEP = false;
	mCurDepth = 16;
	
	//zero vram
	memset((void*)CPU_HARDWIRED_VRAM_ADDR, 0x00, CPU_HARDWIRED_VRAM_SIZE);
	
	//if it is enabled, disable it
	xscaleScreenDisable();
	
	//enable it
	if (!dispPrvEnable())
		return false;
	
	//backlight on
	pwm->DUTY = 255;
	
	return true;
}

void dispSetClut(int32_t firstIdx, uint32_t numEntries, const struct PalmClutEntry *entries)
{
	volatile uint16_t *clut = xscaleScreenGetClutPtr();
	uint32_t i;
	
	if (firstIdx == -1) {
		
		if (numEntries > 256)
			return;
	}
	else if (firstIdx < 0)
		return;
	else if (firstIdx >= 256 || numEntries + firstIdx > 256)
		return;

	for (i = 0; i < numEntries; i++) {
		
		uint32_t where = (firstIdx == -1) ? entries[i].idx : i + firstIdx;
		uint32_t r = entries[i].r;
		uint32_t g = entries[i].g;
		uint32_t b = entries[i].b;
		
		clut[where] = dispPrvRGB888toRGB565(r, g, b);
	}
	
	if (mCurDepth == 16)
		return;
	
	xscaleScreenResendClut(mCurDepth);
}

void dispSetDepth(uint32_t depth)
{
	struct PxaLcd *lcd = platPeriphP2V(PXA_BASE_LCD_CTRL);
	
	if (depth == mCurDepth)
		return;
	
	xscaleScreenDisable();
	if (!dispPrvEnable())
		fatal("Failed to re-init display after a depth change\n");
}

void dispManualUpdate(void)
{
	//nothing
}

void dispRequestUpdate(void)
{
	//nothing
}
