#ifndef _K_DRV_INPUT_H_
#define _K_DRV_INPUT_H_

#include "kernel.h"

typedef void (*DrvInputKeyCbk)(uint32_t modifier, uint32_t code);
typedef void (*DrvInputBtnCbk)(uint32_t key, bool pressed);
typedef void (*DrvInputPenCbk)(int16_t x, int16_t y);	//called in interrupt context - do not do anything slow here. negatives for pen up


//generic
kstatus_t drvInputInit(DrvInputKeyCbk keyCbk, DrvInputBtnCbk btnCbk, DrvInputPenCbk penCbk);
kstatus_t drvInputPreSleep(void);
kstatus_t drvInputPostWake(void);

//only in some cases
kstatus_t drvInputInitLate(void);

//irq-free please
uint32_t drvInputReadKeysEarly(void);

#endif

