#ifndef _DISP_DRV_H_
#define _DISP_DRV_H_

#include <stdbool.h>
#include <stdint.h>
#include "halDisplay.h"


bool dispDrvInit(uint16_t *wP, uint16_t* hP, uint16_t* densityP, uint16_t *realDpiP, uint16_t *supportedDepthMapP, void** framebufferP, bool *indexedFmtIsLEP);	//depth map has bit X set if display supports 2 ^ (x + 1) bpp
void dispSetClut(int32_t firstIdx, uint32_t numEntries, const struct PalmClutEntry *entries);

void dispSetDepth(uint32_t depth);

void dispManualUpdate(void);					//SYNCHRONOUS, on real hardware this is unlikely to be needed
void dispRequestUpdate(void);					//ASYNC request, on real hardware this is unlikely to be needed

void dispSetBri(uint8_t bri);
void dispSetContrast(uint8_t bri);
bool dispSetBacklight(bool on);					//returns success
bool dispGetBacklight(void);

void dispSleep(void);
void dispWake(void);


#endif
