#include "xscaleScreen.h"
#include <MemoryMgr.h>
#include "platform.h"
#include <string.h>
#include "aximCpld.h"
#include "printf.h"
#include "memmap.h"
#include "boot.h"
#include "heap.h"
#include "disp.h"
#include "cpu.h"
#include "dal.h"
#include "kal.h"


#define DISP_WIDTH				240
#define DISP_HEIGHT				320
#define DISP_DENSITY			108



static uint8_t mCurDepth, mCurBri = 0xff;
static bool mBacklightOn = true;

void dispSetBri(uint8_t bri)
{
	static const uint16_t gamma[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 22, 23, 25, 27, 29, 30, 32, 34, 36, 38, 40, 42, 45, 47, 49, 51, 53, 56, 58, 60, 63, 65, 67, 70, 72, 75, 77, 80, 83, 85, 88, 91, 93, 96, 99, 102, 104, 107, 110, 113, 116, 119, 122, 125, 128, 131, 134, 137, 140, 143, 146, 149, 152, 156, 159, 162, 165, 169, 172, 175, 179, 182, 186, 189, 192, 196, 199, 203, 206, 210, 213, 217, 221, 224, 228, 232, 235, 239, 243, 246, 250, 254, 258, 261, 265, 269, 273, 277, 281, 285, 289, 293, 297, 300, 304, 309, 313, 317, 321, 325, 329, 333, 337, 341, 345, 350, 354, 358, 362, 367, 371, 375, 379, 384, 388, 392, 397, 401, 406, 410, 414, 419, 423, 428, 432, 437, 441, 446, 450, 455, 460, 464, 469, 473, 478, 483, 487, 492, 497, 502, 506, 511, 516, 521, 525, 530, 535, 540, 545, 550, 554, 559, 564, 569, 574, 579, 584, 589, 594, 599, 604, 609, 614, 619, 624, 629, 634, 640, 645, 650, 655, 660, 665, 671, 676, 681, 686, 691, 697, 702, 707, 713, 718, 723, 729, 734, 739, 745, 750, 755, 761, 766, 772, 777, 783, 788, 794, 799, 805, 810, 816, 821, 827, 832, 838, 844, 849, 855, 860, 866, 872, 877, 883, 889, 895, 900, 906, 912, 918, 923, 929, 935, 941, 947, 952, 958, 964, 970, 976, 982, 988, 994, 999, 1005, 1011, 1017, 1023, };
	struct PxaPwm *pwm = platPeriphP2V(PXA_BASE_PWM1);
	
	mCurBri = bri;
	pwm->DUTY = gamma[bri];
	
	aximCpldSetBits(AXIM_CPLD_BIT_BACKLIGHT_POWER, !!bri);
}

void dispSetContrast(uint8_t bri)
{
	//not doable on this board	
}

bool dispSetBacklight(bool on)
{
	mBacklightOn = on;
	aximCpldSetBits(AXIM_CPLD_BIT_BACKLIGHT_POWER, on);
	
	return true;
}

bool dispGetBacklight(void)
{
	return mBacklightOn;
}

static uint32_t dispPrvRGB888toRGB565(uint32_t r, uint32_t g, uint32_t b)
{
	return ((r & 0xf8) << 8) | ((g & 0xfc) << 3) | ((b & 0xf8) >> 3);
}

static bool dispPrvEnable(void)		//assumes disabled
{
	uint32_t lccr0 = 0x003008f9;
	uint32_t lccr1 = 0x3a0f34ef;
	uint32_t lccr2 = 0x04000d3f;
	uint32_t lccr3 = 0x00900008;
	
	//depth
	switch (mCurDepth) {
		case 1:
			break;
		
		case 2:
			lccr3 |= 1 << 24;
			break;
		
		case 4:
			lccr3 |= 2 << 24;
			break;
		
		case 8:
			lccr3 |= 3 << 24;
			break;
		
		case 16:
			lccr3 |= 4 << 24;
			break;
	}
	
	//chips up
	return xscaleScreenEnable(lccr0, lccr1, lccr2, lccr3);
}

static void dispPrvDisable(void)
{
	xscaleScreenDisable();
}

bool dispDrvInit(uint16_t *wP, uint16_t* hP, uint16_t* densityP, uint16_t *realDpiP, uint16_t *supportedDepthMapP, void** framebufferP, bool *indexedFmtIsLEP)
{
	uint32_t i;
	
	//gpio: backlight
	platGpioSetDir(17, true);
	platGpioSetFunc(17, 2);
	
	//gpio: lcd
	for (i = 58; i <= 77; i++) {
		
		platGpioSetDir(i, true);
		platGpioSetFunc(i, 2);
	}
	
	*wP = DISP_WIDTH;
	*hP = DISP_HEIGHT;
	*densityP = DISP_DENSITY;
	*realDpiP = 112;	//calculated using a ruler
	*supportedDepthMapP = ((1 << 1) | (1 << 2) | (1 << 4) | (1 << 8) | (1 << 16)) >> 1;
	*framebufferP = xscaleScreenGetFbPtr();
	*indexedFmtIsLEP = true;
	mCurDepth = 16;
	
	//zero vram
	memset((void*)CPU_HARDWIRED_VRAM_ADDR, 0x00, CPU_HARDWIRED_VRAM_SIZE);
	
	dispWake();
	
	return true;
}

void dispSleep(void)
{
	dispPrvDisable();
	platEnablePeriphClock(XSCALE_CLOCK_ID_LCD, false);
	platEnablePeriphClock(XSCALE_CLOCK_ID_PWM1, false);
	aximCpldSetBits(AXIM_CPLD_BIT_LCD_AC_BIAS | AXIM_CPLD_BIT_LCD_CONDITIONING_CHIP | AXIM_CPLD_BIT_LCD_PANEL_POWER | AXIM_CPLD_BIT_BACKLIGHT_POWER, false);
}

void dispWake(void)
{
	struct PxaPwm *pwm = platPeriphP2V(PXA_BASE_PWM1);
	
	//power up the pieces
	aximCpldSetBits(AXIM_CPLD_BIT_LCD_AC_BIAS | AXIM_CPLD_BIT_LCD_CONDITIONING_CHIP | AXIM_CPLD_BIT_LCD_PANEL_POWER | AXIM_CPLD_BIT_BACKLIGHT_POWER, true);
	
	//give clock to LCD and PWM1
	platEnablePeriphClock(XSCALE_CLOCK_ID_LCD, true);
	platEnablePeriphClock(XSCALE_CLOCK_ID_PWM1, true);
	
	//if it is enabled, disable it
	dispPrvDisable();
	
	//enable it
	if (!dispPrvEnable())
		return;
	
	//backlight PWM
	pwm->CTRL = 0;
	pwm->PERVAL = 0x3ff;
	
	dispSetBri(mCurBri);
	dispSetBacklight(mBacklightOn);
}

void dispSetClut(int32_t firstIdx, uint32_t numEntries, const struct PalmClutEntry *entries)
{
	volatile uint16_t *clut = xscaleScreenGetClutPtr();
	uint32_t i;
	
	if (firstIdx == -1) {
		
		if (numEntries > 256)
			return;
	}
	else if (firstIdx < 0)
		return;
	else if (firstIdx >= 256 || numEntries + firstIdx > 256)
		return;

	for (i = 0; i < numEntries; i++) {
		
		uint32_t where = (firstIdx == -1) ? entries[i].idx : i + firstIdx;
		uint32_t r = entries[i].r;
		uint32_t g = entries[i].g;
		uint32_t b = entries[i].b;
		
		clut[where] = dispPrvRGB888toRGB565(r, g, b);
	}
	
	if (mCurDepth == 16)
		return;
	
	xscaleScreenResendClut(mCurDepth);
}

void dispSetDepth(uint32_t depth)
{
	struct PxaLcd *lcd = platPeriphP2V(PXA_BASE_LCD_CTRL);
	
	if (depth == mCurDepth)
		return;
	
	mCurDepth = depth;
	
	dispPrvDisable();
	if (!dispPrvEnable())
		fatal("Failed to re-init display after a depth change\n");
}

void dispManualUpdate(void)
{
	//nothing
}

void dispRequestUpdate(void)
{
	//nothing
}
