#ifndef _AXIM_CPLD_H_
#define _AXIM_CPLD_H_

#include <stdbool.h>
#include <stdint.h>

#define AXIM_CPLD_BIT_AUDIO_CODEC_POWER			0x0001
#define AXIM_CPLD_BIT_FLASH_WRITE_ENABLE		0x0002
#define AXIM_CPLD_BIT_AUDIO_CODEC_AMP_POWER		0x0004
#define AXIM_CPLD_BIT_UNKNOWN_0x0008			0x0008
#define AXIM_CPLD_BIT_LCD_AC_BIAS				0x0010	// turning this off - it still works but inverted and ghosted, maybe ac bias
#define AXIM_CPLD_BIT_LCD_PANEL_POWER			0x0020	// turning this off - instant nothing on screen
#define AXIM_CPLD_BIT_BACKLIGHT_POWER			0x0040
#define AXIM_CPLD_BIT_USB_IFACE_POWER			0x0080	// turning this off - no usb comms
#define AXIM_CPLD_BIT_LED_GREEN_BLINK			0x0100	// blinks green LED. If orange led was on due to charging, it is temporarily turned off
#define AXIM_CPLD_BIT_SD_CHIP_POWER				0x0200	// or card power???
#define AXIM_CPLD_BIT_LED_ORANGE_BLINK			0x0400	// blinks orange LED. If currently charging, the orange LED stays on and this command is ignored
#define AXIM_CPLD_BIT_UNKNOWN_0x0800			0x0800
#define AXIM_CPLD_BIT_LCD_CONDITIONING_CHIP		0x1000	// turning this off - fades disaply out with no updates, can see line where things went bad
#define AXIM_CPLD_BIT_UNKNOWN_0x2000			0x2000
#define AXIM_CPLD_BIT_UNKNOWN_0x4000			0x4000
#define AXIM_CPLD_BIT_CURRENT_MEAS				0x8000	// CLEAR to run entire device through current measurement resisror. do not leave for a long time


void aximCpldInit(void);	//call early
void aximCpldSetBits(uint16_t bit, bool on);
uint16_t aximCpldRead(void);

#endif

