#include "aximCpld.h"
#include "mpu.h"


#define AXIM_CPLD_BASE		(0x8a000000)

static uint16_t mAximCpldReg = AXIM_CPLD_BIT_CURRENT_MEAS;


static void aximCpldRefresh(void)
{
	*(volatile uint32_t*)AXIM_CPLD_BASE = mAximCpldReg;
}

void aximCpldInit(void)
{
	mmuMapIoSeg((void*)AXIM_CPLD_BASE, 0x08000000);
	aximCpldRefresh();
}

void aximCpldSetBits(uint16_t bit, bool on)
{
	if (on)
		mAximCpldReg |= bit;
	else
		mAximCpldReg &=~ bit;
	aximCpldRefresh();
}

uint16_t aximCpldRead(void)
{
	return mAximCpldReg;
}



