#include <SoundMgr.h>
#include <stdint.h>
#include <string.h>
#include <stdio.h>
#include "palmcardComms.h"
#include "palmcardProto.h"
#include "audiohw.h"
#include "printf.h"
#include "heap.h"
#include "irqs.h"
#include "ral.h"
#include "cpu.h"


bool audioOutHwInit(AudioOutHwReadyForMoreSamplesF readyForSamplesF, uint32_t *numSamplesPerBufP, enum AudioSampleRate* nativeRateP, bool *nativeStereoP)
{
	//not supported
	return false;
}

void audioOutHwSetState(bool on)
{
	//nothing
}

bool audioOnlySimpleOutInit(void)
{
	return true;
}

//this func is not called if sampled oudio is available
void audioOnlySimpleTone(uint32_t freq, uint32_t amp)
{
	//freq is in Hq, amp is 0..sndMaxAmp inclusive
	
	if (freq > 65535)	//be nice to bats :)
		freq = 65535;
	
	if (amp > sndMaxAmp)
		amp = sndMaxAmp;
	
	//rescale to a more useful scale
	amp = (amp * 255 + sndMaxAmp / 2) / sndMaxAmp;
	
	palmcardCommsSendSimpleSoundReq(freq, amp);
	while (palmcardCommsGetPendingIrqs() & PCC_REQ_SIMPLE_AUDIO_REQ);	//wait
}