#ifndef _HAL_PEN_H_
#define _HAL_PEN_H_


#include <stdbool.h>
#include <string.h>
#include <stdint.h>
#include <PalmTypes.h>
#include <ErrorBase.h>
#include <Rect.h>

Err HALPenRawToScreen(struct PointType *pt);
Err HALPenScreenToRaw(struct PointType *pt);
Err HALPenResetCalibration(void);
Err HALPenCalibrate(struct PointType *digTopLeftP, struct PointType *digBotRightP, struct PointType *scrTopLeftP, struct PointType *scrBotRightP);


Err HALKeyGetRates(UInt16 *initDelayP, UInt16 *periodP, Boolean *queueAheadP);
Err HALKeySetRates(UInt16 initDelay, UInt16 period, Boolean queueAheadP);

Err HALKeyResetDoubleTap(UInt16 *doubleTapDelayP);
uint32_t HALKeySetMask(uint32_t keyMask);
uint32_t HALKeyGetState(void);


#define HARD_KEY_POWER		0x00000001
#define HARD_KEY_PG_UP		0x00000002
#define HARD_KEY_PG_DN		0x00000004
#define HARD_KEY_APP_1		0x00000008
#define HARD_KEY_APP_2		0x00000010
#define HARD_KEY_APP_3		0x00000020
#define HARD_KEY_APP_4		0x00000040
#define HARD_KEY_HOTSYNC	0x00000080

#define HARD_KEY_JOG_UP		0x00001000
#define HARD_KEY_JOG_DN		0x00002000
#define HARD_KEY_JOG_SEL	0x00004000
#define HARD_KEY_JOG_BACK	0x00008000

#define HARD_KEY_ROCKER_UP	0x00010000
#define HARD_KEY_ROCKER_DN	0x00020000
#define HARD_KEY_ROCKER_LT	0x00040000
#define HARD_KEY_ROCKER_RT	0x00080000
#define HARD_KEY_ROCKER_SEL	0x00100000


//for internal use
void halHardKeyChanged(uint32_t keyMask, bool pressed);

#endif
