#ifndef _HAL_DISPLAY_H_
#define _HAL_DISPLAY_H_

#include <stdbool.h>
#include <stdint.h>
#include <PalmTypes.h>
#include <ErrorBase.h>
#include "halDrawing.h"
#include "sony.h"

//attrs (HwrDisplay.c has more)

//COMMON for all OSs
#define hwrDispDrvName							0x03	//char*
#define hwrDispHorizontal						0x04	//u32
#define hwrDispVertical							0x05	//u32
#define hwrDispStride							0x06	//u32
#define hwrDispScreenPpiX						0x07	//u32 only used by WinScreenGetAttribute
#define hwrDispScreenPpiY						0x08	//u32 only used by WinScreenGetAttribute
#define hwrDispBootDepth						0x09	//u32
#define hwrDispDepth							0x0a	//u32
#define hwrDispMaxDepth							0x0b	//u32
#define hwrDispAllDepths						0x0c	//u32 bitmask
#define hwrDispColorSupported					0x0d	//u32
#define hwrDispScreenVramBase					0x0e	//u32, we do not support this
#define hwrDispScreenVramSize					0x0f	//u32, in bytes, we do not support this
#define hwrDispScreenBacklight					0x11	//settable u32 (values other than 0 and 1 are errors)
#define hwrDispBrightness						0x12	//settable u32
#define hwrDispContrast							0x13	//settable u32
#define hwrDispOrient							0xf0	//settable
#define hwrDispT3SliderState					0xf1	//u32, 1 if slider is closed. 0 if opened

#define hwrDispLastCommonAttrWithGarnet			0x18	// TBD
#define hwrDispFistCommonAttrWithGarnetHiRange	0xf0

//PRE-GARNET only
#define hwrDispVirtSlkLoc						0x19	//{u16 x, u16 y} - location where virtual silk should be drawn by bootscreen. If we return errnone, it will be drawn over boot screen. returning error means it will not. typicla return values are {0, 320}
#define hwrDispUnknown_1a						0x1A	//settable u32, not sure . set by ique to point to what looks like a v1 bitmap in rom
#define hwrDispPixelFormat						0x1E	//u32, we do not support this. shuld be PALM_BMP_PIXEL_FORMAT_RGB565_LE is 16bpp, PALM_BMP_PIXEL_FORMAT_INDEXED for 8 bpp, else PALM_BMP_PIXEL_FORMAT_INDEXED_LE. do not ask...
#define hwrDispDensity							0x1F	//u16
#define hwrDispDigitizerScaleToScreenScale		0x20	//u16, z72 says 64, z31 says 64
#define hwrDispDigitizerScaleToStandardScale	0x21	//u16, z72 says 32, z31 says 32

//GARNET only
#define hwrDispDensity54						0x1D	//u32
#define hwrDispDispScale						0x1E	//u32 TX says 0x10000
#define hwrDispDgtScale							0x1F	//u32 TX says 0x8000
#define hwrDispInputAreaRect					0x20	//{u16 u16 u16 u16} TX says {(0,320)(320,160)}
#define hwrDispInputAreaBitmapUnselected		0x21	//settable
#define hwrDispInputAreaBitmapSelected			0x22	//settable
#define hwrDispVirtSlkLoc_v2					0x24	//{u16 x, u16 y} - same as hwrDispVirtSlkLoc
#define hwrDispVirtSlkLocDrawn					0x25	//settable if read of hwrDispVirtSlkLoc_v2 returns nonerror, this will be set when draw is done over boot screen

//SONY only
#define hwrDispSonyUserAreaSz					0x8000	//u32, how much of screen is under app control: {320, 450, 480}
#define hwrDispSony8003							0x8003	//u32, only lower bit has meaning. Sets some state. Can also be gotten.
#define hwrDispSony8004							0x8004	//u32, (u32 form globals, locks involved in getting it), write may signal a sempahore

//our own things
#define hwrDispRealDpi							0xe000	//u32 in dpi

void halDisplayInit(void);



Err HALDisplayGetAttributes(uint16_t attr, void *valP);
Err HALDisplaySetAttributes(uint16_t attr, uint32_t val);
Err HALDisplaySetPalette(uint32_t startIdx, uint32_t numEntries, const struct PalmClutEntry *entries);
Err HALScreenInit(struct PalmBitmap **screenBmpP, const struct PalmClut *palletteP);

bool HALScreenDefaultPalette(void);	//check is current pallette is default
Err HALScreenUpdateBitmap(uint8_t depth);

const struct PalmClut* HALScreenGetColortable(void);
Err HALScreenPalette(uint32_t startIndex, uint32_t numEntries, uint32_t depth, struct PalmClut *tableP, const struct PalmClut **palettes);


void* HALScreenLock(uint32_t initMode);	//PALM_SCREEN_LOCK_METHOD_*, returns new screen base addr (why?)
Err HALScreenUnlock(void);

void HALScreenSendUpdateArea(bool force);
void HALScreenDrawNotify(int16_t updLeft, int16_t updTop, int16_t updWidth, int16_t updHeight);

Err HALDisplayDoze(void);
Err HALDisplaySleep(bool untilReset, bool emergency);
Err HALDisplayWake(void);

//internal
struct PalmBitmapV3* halScreenGetCurBitmap(void);
bool halScreenIsLive(void);	//true if screen isnt locked
uint8_t* halScreenGetStandardPaletteXlationTableForDepth(uint32_t depth);
void halScreenBreakLocks(void **screnBuf, uint32_t *wP, uint32_t *hP, uint32_t *bppP, bool *indexedFormatIsLeP);	//for fatal alert


//used only early in boot for boot screen and by the refresh thread
void halDisplayRefreshManual(void);

//only used in early boot for boot screen drawing
void halDisplayEarlyBootGetMetrics(void** fbP, uint32_t *widthP, uint32_t *heightP, uint32_t *strideP, uint32_t *densityP, uint32_t *depthP, bool *indexedFormatIsLeP);

#endif
