#ifdef __GNUC__
	#define sp	%sp
	#define a0	%a0
	#define a1	%a1
	#define a2	%a2
	#define a3	%a3
	#define a7	%a7
	#define d0	%d0
	#define d1	%d1
	#define d2	%d2
	#define d3	%d3
	#define d4	%d4
#endif


#ifndef DONT_INCLUDE_SCR_COPY

	#ifdef __GNUC__
	.globl scrCopy
	.func
	scrCopy:
	#endif
		move.l 4(sp), a0
		move.l 8(sp), a1
		move.w 12(sp), d0
	
		move.b d0, d1
		lsr.w  #5, d0
	big_loop:
		subq.w #1, d0
		blt    big_loop_end
		move.l (a1)+, (a0)+
		move.l (a1)+, (a0)+
		move.l (a1)+, (a0)+
		move.l (a1)+, (a0)+
		move.l (a1)+, (a0)+
		move.l (a1)+, (a0)+
		move.l (a1)+, (a0)+
		move.l (a1)+, (a0)+
		move.l (a1)+, (a0)+
		move.l (a1)+, (a0)+
		move.l (a1)+, (a0)+
		move.l (a1)+, (a0)+
		move.l (a1)+, (a0)+
		move.l (a1)+, (a0)+
		move.l (a1)+, (a0)+
		move.l (a1)+, (a0)+
		bra    big_loop
	
	big_loop_end:
		andi.b #0x1f, d1
		beq    done_copy
	
	small_loop:
		move.w (a1)+, (a0)+
		subq.b #1, d1
		bne    small_loop
	
	done_copy:
		rts
	
	#ifdef __GNUC__
	.endfunc
	#endif
#endif

#ifndef DONT_INCLUDE_SCR_DECOMPRESS
	#ifdef __GNUC__
	.globl screenDecompress
	.func
	screenDecompress:
	#endif
	
		move.l    4(sp), a0				//a0 is dst
		move.l    8(sp), a1				//a1 is src
		move.l    12(sp), d0			//d0 is temporarily srcLen
		
		movem.l   d3-d4/a2-a3,-(a7)
		
		lea	      (a1, d0.l), a2		//get (src + srcLen) into a2
		
		moveq     #14, d4
		
		move.b    (a1)+, d0				//d0 is marker
		
	loop:
		move.b    (a1)+, d1				//get a byte
		cmp.b     d1, d0				//marker?
		beq       is_marker
	
	output_d1:
		move.b    d1, (a0)+
		cmp.l     a1, a2
		bne       loop
		bra       done
	
	is_marker:
		moveq     #0, d2
		move.b    (a1)+, d2				//get the byte after the marker
		beq       output_d1				//zero means we need to output the marker. luckily it is still in d1 so we can reuse code
	
	is_match:							//we have a match to deal with, d2 is first byte of "matchOfst", flags still set on it
		bmi       ofst_more_than_1_b
		andi.b    #0x7f, d2
		
	got_ofst:
		moveq     #0, d3
		move.b    (a1)+, d3				//get the first byte of match len
		bmi       len_more_than_1_b
		andi.b    #0x7f, d3
	
	got_len:
		add.l     #2, d3				//dbra loops one more than reg val
		neg.l     d2
		lea       (a0, d2.l), a3
	
	copy_loop:
		move.b    (a3)+, (a0)+
		dbra      d3, copy_loop
		cmp.l     a1, a2
		bne       loop
	
	done:
		movem.l   (a7)+,d3-d4/a2-a3
		rts
	
	
	ofst_more_than_1_b:
		andi.b    #0x7f, d2
		moveq     #0, d1
		move.b    (a1)+, d1
		bmi       ofst_more_than_2_b
		andi.b    #0x7f, d1
		lsl.w     #7, d1
		add.w     d1, d2
		bra       got_ofst
	
	ofst_more_than_2_b:
		andi.b    #0x7f, d1
		lsl.w     #7, d1
		add.w     d1, d2
		moveq     #0, d1
		move.b    (a1)+, d1
		bmi       ofst_more_than_3_b
		andi.b    #0x7f, d1
		lsl.l     d4, d1
		add.l     d1, d2
		bra       got_ofst
	
	ofst_more_than_3_b:
		andi.b    #0x7f, d1
		lsl.l     d4, d1
		add.l     d1, d2
		moveq     #0, d1
		move.b    (a1)+, d1
		bmi       ofst_more_than_4_b
		andi.b    #0x7f, d1
		swap      d1		//lsl #16
		lsl.l     #5, d1	//and another 5 makes 21
		add.l     d1, d2
		bra       got_ofst
	
	ofst_more_than_4_b:
		andi.b    #0x7f, d1
		swap      d1		//lsl #16
		lsl.l     #5, d1	//and another 5 makes 21
		add.l     d1, d2
		moveq     #0, d1
		move.b    (a1)+, d1
		andi.b    #0x7f, d1
		ror.l     #4, d1	//lsl #28
		add.l     d1, d2
		bra       got_ofst
	
	len_more_than_1_b:
		andi.b    #0x7f, d3
		moveq     #0, d1
		move.b    (a1)+, d1
		bmi       len_more_than_2_b
		andi.b    #0x7f, d1
		lsl.w     #7, d1
		add.w     d1, d3
		bra       got_len
	
	len_more_than_2_b:
		andi.b    #0x7f, d1
		lsl.w     #7, d1
		add.w     d1, d3
		moveq     #0, d1
		move.b    (a1)+, d1
		bmi       len_more_than_3_b
		andi.b    #0x7f, d1
		lsl.l     d4, d1
		add.l     d1, d3
		bra       got_len
	
	len_more_than_3_b:
		andi.b    #0x7f, d1
		lsl.l     d4, d1
		add.l     d1, d3
		moveq     #0, d1
		move.b    (a1)+, d1
		bmi       len_more_than_4_b
		andi.b    #0x7f, d1
		swap      d1		//lsl #16
		lsl.l     #5, d1	//and another 5 makes 21
		add.l     d1, d3
		bra       got_len
	
	len_more_than_4_b:
		andi.b    #0x7f, d1
		swap      d1		//lsl #16
		lsl.l     #5, d1	//and another 5 makes 21
		add.l     d1, d3
		moveq     #0, d1
		move.b    (a1)+, d1
		andi.b    #0x7f, d1
		ror.l     #4, d1	//lsl #28
		add.l     d1, d3
		bra       got_len
	
	#ifdef __GNUC__
	.endfunc
	#endif
#endif