#ifndef _PILOT_PINOUT_H_
#define _PILOT_PINOUT_H_

//PORT C bit assignments
#define PORTC_BIT_NMI							0x10	//low for low batteries, input to buttons ground n-fet (when batts are low, buttons are unreadable)

//PORT D bit assignments
#define PORTD_BIT_KEY_APP4						0x40	//active low
#define PORTD_BIT_KEY_APP3						0x20	//active low
#define PORTD_BIT_KEY_APP2						0x10	//active low
#define PORTD_BIT_KEY_APP1						0x08	//active low
#define PORTD_BIT_KEY_DOWN						0x04	//active low
#define PORTD_BIT_KEY_UP						0x02	//active low
#define PORTD_BIT_KEY_POWER						0x01	//active low

#define PORTD_BITS_ALL_KEYS						(PORTD_BIT_KEY_POWER | PORTD_BIT_KEY_UP | PORTD_BIT_KEY_DOWN | PORTD_BIT_KEY_APP1 | PORTD_BIT_KEY_APP2 | PORTD_BIT_KEY_APP3 | PORTD_BIT_KEY_APP4)

//PORT E bit assignments
#define PORTE_BIT_HAVE_NO_BACKLITE				0x80	//low on devices that posess a backlight


//PORT F bit assignments
#define PORTF_BIT_ADC_NCS						0x80	//directly wired to ADc's nCS
#define PORTF_BIT_LCD_HIGH_VOLTAGE_ENA			0x40	//controls high voltage suplpy for LCD
#define PORTF_BIT_LCD_POWER_DIS					0x20	//active low. controls power supply to LCD
#define PORTF_BIT_LCD_PANEL_ENABLE				0x10	//enable for LCD
//these control connecting supply lines to various digitizer inputs
#define PORTF_BIT_DIGI_X_NEG_TO_GND_ON			0x08
#define PORTF_BIT_DIGI_X_POS_TO_VCC_DIS			0x04
#define PORTF_BIT_DIGI_Y_NEG_TO_GND_ON			0x02
#define PORTF_BIT_DIGI_Y_POS_TO_VCC_DIS			0x01


//digitizer can be in a few modes. irq is just by grounding input
#define PORTF_DIGI_MODE_MASK					(PORTF_BIT_DIGI_X_NEG_TO_GND_ON | PORTF_BIT_DIGI_X_POS_TO_VCC_DIS | PORTF_BIT_DIGI_Y_NEG_TO_GND_ON | PORTF_BIT_DIGI_Y_POS_TO_VCC_DIS)
#define PORTF_DIGI_MODE_OFF						(PORTF_BIT_DIGI_X_POS_TO_VCC_DIS | PORTF_BIT_DIGI_Y_POS_TO_VCC_DIS)
#define PORTF_DIGI_MODE_MEAS_X					(PORTF_BIT_DIGI_X_POS_TO_VCC_DIS | PORTF_BIT_DIGI_Y_NEG_TO_GND_ON)
#define PORTF_DIGI_MODE_MEAS_Y					(PORTF_BIT_DIGI_Y_POS_TO_VCC_DIS | PORTF_BIT_DIGI_X_NEG_TO_GND_ON)
#define PORTF_DIGI_MODE_IRQ						(PORTF_BIT_DIGI_X_NEG_TO_GND_ON | PORTF_BIT_DIGI_X_POS_TO_VCC_DIS | PORTF_BIT_DIGI_Y_POS_TO_VCC_DIS)

//PORT G bit assignments
#define PORTG_BACKLITE_ENA						0x80	//backlight enable
#define PORTG_BATT_MEAS_DIS						0x10	//lower to measure battery using the ADC
#define PORTG_UART_CHIP_ENA						0x08	//raise to enable uart chip

//PORT J bit assignments
#define PORTJ_BIT_IRDA_TX_ENA					0x20
#define PORTJ_BIT_IRDA_ENA						0x10

//PORT M bit assignments
#define PORTM_BIT_PEN_IRQ						0x40
#define PORTM_BIT_HOTSYNC_BTN					0x20	//active low
#define PORTM_BIT_IRQ3							0x08	//active low
#define PORTM_BIT_IRQ6							0x04	//active low, asserted when batteries are too low to supply 3v3





#endif



