#ifndef _M68K_H_
#define _M68k_H_

#include <stdint.h>


#define PORT_A		0
#define PORT_B		1
#define PORT_C		2
#define PORT_D		3
#define PORT_E		4
#define PORT_F		5
#define PORT_G		6
#define PORT_J		7
#define PORT_K		8
#define PORT_M		9


struct M68Kport {	//attention: not all ports have all these regs
	volatile uint8_t DIR, DATA, PUEN, SEL, POL, IRQEN, rfu, IRQEDGE;	//offset 0,1,2
};

struct M68Ktmr {
	volatile uint16_t TCTL, TPRER, TCMP, TCR, TCN, TSTAT;
};

struct M68K {
	volatile uint8_t	SCR;			//0x000
	uint8_t rfu0[0xff];
	
	volatile uint16_t	GRPBASEA;		//0x100
	volatile uint16_t	GRPBASEB;		//0x102
	volatile uint16_t	GRPBASEC;		//0x104
	volatile uint16_t	GRPBASED;		//0x106
	volatile uint16_t	GRPMASKA;		//0x108
	volatile uint16_t	GRPMASKB;		//0x10a
	volatile uint16_t	GRPMASKC;		//0x10c
	volatile uint16_t	GRPMASKD;		//0x10e
	volatile uint32_t	CSA[4];			//0x110
	volatile uint32_t	CSB[4];			//0x120
	volatile uint32_t	CSC[4];			//0x130
	volatile uint32_t	CSD[4];			//0x140
	uint8_t rfu1[0xb0];
	
	volatile uint16_t	PLLCR;			//0x200
	volatile uint16_t	PLLFSR;			//0x202
	uint8_t rfu2[0x03];
	volatile uint8_t	PCTLR;			//0x207
	uint8_t rfu3[0xf8];
	
	volatile uint8_t	IVR;			//0x300
	uint8_t rfu4[0x01];
	volatile uint16_t	ICR;			//0x302
	volatile uint32_t	IMR;			//0x304
	volatile uint32_t	IWR;			//0x308
	volatile uint32_t	ISR;			//0x30c
	volatile uint32_t	IPR;			//0x310
	uint8_t rfu5[0xec];
	
	struct M68Kport		P[10];			//0x400
	uint8_t rfu6[0xb0];
	
	volatile uint16_t	PWMC;			//0x500
	volatile uint16_t	PWMP;			//0x502
	volatile uint16_t	PWMW;			//0x504
	volatile uint16_t	PWMCNT;			//0x506
	uint8_t rfu7[0xf8];
	
	struct M68Ktmr		T[2];			//0x600
	volatile uint16_t	WCTL;			//0x618
	volatile uint16_t	WCMP;			//0x61a
	volatile uint16_t	WCN;			//0x61c
	uint8_t rfu8[0xe2];
	
	volatile uint16_t	SPISR;			//0x700
	uint8_t rfu9[0xfe];
	
	volatile uint16_t	SPIMDATA;		//0x800
	volatile uint16_t	SPIMCONT;		//0x802
	uint8_t rfuA[0xfc];
	
	volatile uint16_t	USTCNT;			//0x900
	volatile uint16_t	UBAUD;			//0x902
	volatile uint16_t	URX;			//0x904
	union{
		volatile uint16_t	UTX;		//0x906
		struct {
			volatile uint8_t UTXhi;
			volatile uint8_t UTXlo;
		};
	};
	volatile uint16_t	UMISC;			//0x908
	uint8_t rfuB[0xf6];
	
	volatile uint32_t	LSSA;			//0xa00
	uint8_t rfuC[0x01];
	volatile uint8_t	LVPW;			//0xa05
	uint8_t rfuD[0x02];
	volatile uint16_t	LXMAX;			//0xa08
	volatile uint16_t	LYMAX;			//0xa0a
	uint8_t rfuE[0x0c];
	volatile uint16_t	LCXP;			//0xa18
	volatile uint16_t	LCYP;			//0xa1a
	volatile uint16_t	LCWCH;			//0xa1c
	uint8_t rfuF[0x01];
	volatile uint8_t	LBLKC;			//0xa1f
	volatile uint8_t	LPICF;			//0xa20
	volatile uint8_t	LPOLCF;			//0xa21
	uint8_t rfuG[0x01];
	volatile uint8_t	LACDRC;			//0xa23
	uint8_t rfuH[0x01];
	volatile uint8_t	LPXCD;			//0xa25
	uint8_t rfuI[0x01];
	volatile uint8_t	LCKCON;			//0xa27
	uint8_t rfuJ[0x01];
	volatile uint8_t	LBAR;			//0xa29
	uint8_t rfuK[0x01];
	volatile uint8_t	LOTCR;			//0xa2b
	uint8_t rfuL[0x01];
	volatile uint8_t	LPOSR;			//0xa2d
	uint8_t rfuM[0x03];
	volatile uint8_t	LFRCM;			//0xa31
	volatile uint16_t	LGPMR;			//0xa32
	uint8_t rfuN[0xcc];
	
	volatile uint32_t	HMSR;			//0xb00
	volatile uint32_t	ALARM;			//0xb04
	uint8_t rfuO[0x04];
	volatile uint8_t	RTCCTL;			//0xb0c
	uint8_t rfuP[0x01];
	volatile uint8_t	RTCISR;			//0xb0e
	uint8_t rfuQ[0x01];
	volatile uint8_t	RTCIENR;		//0xb10
	uint8_t rfuR[0x01];
	volatile uint8_t	STRWCH;			//0xb12
};



#define M68K_IxR_TMR1			0x00400000ul
#define M68K_IxR_PENIRQ			0x00100000ul
#define M68K_IxR_IRQ3			0x00040000ul
#define M68K_IxR_PWM			0x00000080ul
#define M68K_IxR_KB				0x00000040ul
#define M68K_IxR_UART			0x00000004ul


#endif
