.globl __bss_start
.globl __bss_end
.globl __stack_top
.globl __vectors
.globl __fault
.globl __unusedVec
.globl __uninitIrq
.globl __spuriousIrq
.globl __irq
.globl __trap

.section .vectors
__vectors:
	.long __stack_top
	.long __entry
	.long __fault		//access fault
	.long __fault		//address error
	.long __fault		//illegal instr
	.long __fault		//div 0
	.long __fault		//CHK/CHK2
	.long __fault		//TRAPcc
	.long __fault		//priv vio
	.long __fault		//trace exc
	.long __fault		//line A
	.long __fault		//line F
	.long __unusedVec	//unused
	.long __unusedVec	//coprocessor protocol vio
	.long __unusedVec	//unused
	.long __uninitIrq	//uninitialized irq
	.long __unusedVec	//unused
	.long __unusedVec	//unused
	.long __unusedVec	//unused
	.long __unusedVec	//unused
	.long __unusedVec	//unused
	.long __unusedVec	//unused
	.long __unusedVec	//unused
	.long __unusedVec	//unused
	.long __spuriousIrq
	.long __irq1		//irq level1
	.long __irq2		//irq level2
	.long __irq3		//irq level3
	.long __irq4		//irq level4
	.long __irq5		//irq level5
	.long __irq6		//irq level6
	.long __irq7		//irq level7
	.long __trap		//trap0
	.long __trap		//trap1
	.long __trap		//trap2
	.long __trap		//trap3
	.long __trap		//trap4
	.long __trap		//trap5
	.long __trap		//trap6
	.long __trap		//trap7
	.long __trap		//trap8
	.long __trap		//trap9
	.long __trap		//trapA
	.long __trap		//trapB
	.long __trap		//trapC
	.long __trap		//trapD
	.long __trap		//trapE
	.long __trap		//trapF
	
	
.section .text
__entry:
	lea		__bss_start(%pc), %a0
	lea		__bss_end(%pc), %a1
	bra.b	1f
bss_clear:
	clr.l	(%a0)+
1:
	cmpa.l	%a0, %a1
	bne.b	bss_clear
	jmp		micromain(%pc)




.globl pccReq //	(u16* dst, u16 req, u16 nWords, u16 *src)	-> u16 wordsInReply
pccReq:
	movea.l	#0x00800000, %a1
	lea		8(%sp), %a0
	move.w	(%a0)+, (%a1)
	move.w	(%a0)+, %d0
	move.w	%d0, (%a1)
	subq.w	#1, %d0
	bmi.b	2f
	movea.l (%a0), %a0
1:
	move.w	(%a0)+, (%a1)
	dbra	%d0, 1b
2:
	move.w	%d0, (0x00810000)
	
3:
	cmpi.w	#0xface, (%a1)
	bne.b	3b

	move.w	(%a1), %d0
	move.w	%d0, %d1
	movea.l	4(%sp), %a0
	subq.w	#1, %d1
	bmi.b	2f
1:
	move.w	(%a1), (%a0)+
	dbra	%d1, 1b

2:
	rts


.globl mTimerHi
.globl __irq6
__irq6:
	clr.b	(0xfffff60b)		//does the required read cycle too :P
	addq.l	#1, (mTimerHi).w	//limit timer var to be in first 64KB, which it always is
	rte


/*
	What is going on here with buttons?
	Button irqs only fire when enabled. They share a vector with PWM so we cannot handle them.
	When Audio is in, we just poll them in the main loop as we wake up aplenty. When audio is off,
	we enable the irq and then poll when we wake due to it firing. In either case we stay awake
	while a button is pressed. So what does this irq handler do? the minimum to avoid disturbing
	the audio workflow. We just mask button irqs. Always. If it is off, no big deal, if it was on,
	we mask it and the main loop will re-enable it. When audio is off this code will still write
	the PWM data register and advance the audio data pointer. This is ok, the audio enablement code
	will reset it all to a good state and not checking is faster.

*/

.globl __irq4
__irq4:
	ori.b	#0x44, (0xfffff307)			//button & uart irq handling
	tst.w	(0xfffff500)				//mandatory read
	move.b	(%a4)+, (0xfffff505)
	cmpa.w	%a4, %a5					//only lower bits should change anyways
	bne.b	1f
	lea		-1024(%a5), %a4
1:
	rte



.globl memset
memset:				//small
	movea.l	4(%sp), %a0
	move.b	8(%sp), %d0
	move.l	10(%sp), %d1
	movea.l %a0, %a1
	bra.b	2f
1:
	move.b	%d0, (%a1)+
2:
	subq.l	#1, %d1
	bpl.b	1b
	rts