#ifndef _ASM_H_
#define _ASM_H_

#include <PalmOS.h>

struct Mb86189 {
	volatile UInt16 MSCMD;		//00
	volatile UInt8 MSCSL;		//02
	volatile UInt8 MSCSH;		//03
	volatile UInt16 MSDATA;		//04
	volatile UInt8 MSICSL;		//06
	volatile UInt8 MSICSH;		//07
	volatile UInt8 MSPPD;		//08	was MSPPCDL			(top 4 are input vals, bottom 4 are output vals)
	volatile UInt8 MSPPC;		//09	was MSPPCDH			(top4 is inputs enable bottom 4 is outputs enable)
};


void screenDecompressNew(void* dst, const void *src, UInt32 srcLen);


UInt8 msioTpcR_20MHz(struct Mb86189 *chip, UInt8 tpc, Int16 nBytes, UInt16 *valOutP, UInt8 *staOutP);
UInt8 msioTpcW_20MHz(struct Mb86189 *chip, UInt8 tpc, Int16 nBytes, const UInt16 *valOutP, UInt8 *staOutP);
UInt8 msioTpcR_33MHz(struct Mb86189 *chip, UInt8 tpc, Int16 nBytes, UInt16 *valOutP, UInt8 *staOutP);
UInt8 msioTpcW_33MHz(struct Mb86189 *chip, UInt8 tpc, Int16 nBytes, const UInt16 *valOutP, UInt8 *staOutP);



//TPCs
#define MS_RD_LDATA					0x02
#define MS_RD_SDATA					0x03		//might not work on non-PRO MSs
#define MS_RD_REG					0x04
#define MS_GET_INT					0x07
#define MS_SET_RW_REG_ADRS			0x08
#define MS_EX_SET_CMD				0x09		//might not work on non-PRO MSs
#define MS_WR_REG					0x0b
#define MS_WR_SDATA					0x0c		//might not work on non-PRO MSs
#define MS_WR_LDATA					0x0d
#define MS_SET_CMD					0x0e


#endif

