#ifndef _PALM_OS_EXTRA_H_
#define _PALM_OS_EXTRA_H_

#include <PalmOS.h>

Boolean	HwrBacklight(Boolean set, Boolean newState)	SYS_TRAP(sysTrapHwrBacklightV33);


//attributes are the same as in ARM :)
Err HwrLEDAttributes(Boolean set, UInt32 attr, void* data)	SYS_TRAP(sysTrapHwrLEDAttributes);
Err HwrVibrateAttributes(Boolean set, UInt32 attr, void* data)	SYS_TRAP(sysTrapHwrVibrateAttributes);

#define LED_VIB_ATTR_TYPE				0		//value is readonly, u32, LED_VIB_TYPE_*
#define LED_VIB_ATTR_ACTIVE				1		//value is u8 (treated as boolean) as to whether this is on or off. can be turned on in middle of doing what was programmed. else will self turn on when number of cycles is completed as requested
#define LED_VIB_ATTR_RATE				2		//value is u16 specifying length of one cycle in units of 10ms (one cycle is 32 subcycles, each of which is described by a bit in "pattern" below
#define LED_VIB_ATTR_PATTERN			3		//value is u32, each bit is whether vib/led are on during that period. used big to little bits. eg: 0xFFFFFFFF=stay on, no vibrating,  0x0F0F0000=vibrate twice, then pause, 0x0F0F0F0F=vibrate four times in equal intervals
#define LED_VIB_ATTR_DELAY				4		//value is u16 - delay between cycles in units of 10ms
#define LED_VIB_ATTR_REPEAT_COUNT		5		//value is u16 - how many cycles to do when turned on
#define LED_VIB_ATTR_INTERRUPT_OFF		8		//value is ignored, writeonly, disables immediately

#endif

