#ifndef _DAL_H_
#define _DAL_H_

#include <stdint.h>
#include <ErrorBase.h>
#include <stdbool.h>
#include "pace.h"
#include "cpu.h"


#define CREATE_4CC(a,b,c,d)			((((uint32_t)(a)) << 24) | (((uint32_t)(b)) << 16) | (((uint32_t)(c)) << 8) | (((uint32_t)(d)) << 0))
#define FMT_4CC						"%c%c%c%c"
#define CNV_4CC(v)					(((v) >> 24) & 0xff), (((v) >> 16) & 0xff), (((v) >> 8) & 0xff), (((v) >> 0) & 0xff)


#define DAL_INIT_STAGE_NONE			0		//nothing inited yet
#define DAL_INIT_STAGE_MEM_AND_DM	1		//Mem, Tls, and Dm are up
#define DAL_INIT_STAGE_NO_UI		2		//Sys, Overlay
#define DAL_INIT_STAGE_ALL_UP		3		//all is up
#define DAL_INIT_STAGE_RST_NOTIFD	4		//apps have been notified of reset

#define DALEXPORT					__attribute__((used))


uint32_t dalGetInitStage(void);

uint32_t HALGetHwrWakeUp(void);	//returns the wake flags
void dalModifyWakeFlags(uint32_t setBits, uint32_t clearBits);
#define DAL_WAKE_FLAG_GENERAL		0x00000001		//general wake reason?
#define DAL_WAKE_FLAG_PWM			0x00000002		//not used it seems
#define DAL_WAKE_FLAG_FROM_KEY		0x00000004		//woken by keypress
#define DAL_WAKE_FLAG_FROM_RTC		0x00000008		//rtc alarm or rtc 24h rollover. also called "return to sleep"
#define DAL_WAKE_FLAG_LCD_ASLEEP	0x00000010		//set if LCD is asleep. not a reason but still in this value


//VERY internal
void halCallEvtCallback(uint32_t type, const void* data);


#define HAL_EVENT_TYPE_PEN		0			//XXX: we'll want to use this....
#define HAL_EVENT_TYPE_KEY		1
#define HAL_EVENT_TYPE_CLOCK	2

struct HalEvtKey {
	uint16_t	ascii;	//wide char
	uint16_t	keyCode;
	uint16_t	modifiers;
};

struct HalEvtPen {
	int16_t x;		//negaitve one for both to stop
	int16_t y;
};

Err HALEventPost(uint32_t evt, const void *evtData);
Err HALGetROMToken(uint32_t tokenRequested, void **dataPP, uint16_t *sizeP);

bool isGarnet(void);
bool is50(void);

#define HAL_DOCK_STATUS_MODEM_ATTACHED	0x01	//a modem is atached (exclusive with HAL_DOCK_STATUS_DOCK_ATTACHED i think)
#define HAL_DOCK_STATUS_DOCK_ATTACHED	0x02	//some sort of a dock is attached
#define HAL_DOCK_STATUS_EXTRNAL_PWR		0x04	
#define HAL_DOCK_STATUS_CHARGING		0x08	
#define HAL_DOCK_STATUS_USB_CRADLE		0x10	
#define HAL_DOCK_STATUS_USB_PERIPH		0x20	
#define HAL_DOCK_STATUS_SERIAL_PERIPH	0x40	
//0x80 exists too, probably for factory testing?
Err HALDockStatus(uint16_t *statusP);

//dock drivers calls this when dock status changes
void halDockStatusChanged(uint16_t bits);		//	HAL_DOCK_STATUS_*


typedef void (*HalIrqHandlerF)(void* userData);
Err HALInterruptGetHandler(uint32_t irqNo, HalIrqHandlerF *curHandlerP, void** curUserDataP);
Err HALInterruptSetHandler(uint32_t irqNo, HalIrqHandlerF newHandlerP, void* newUserDataP);
bool HALInterruptSetState(uint32_t irqNo, bool on);	//returns old state
bool HALErrDisplay(const char *msg, bool forced, uint32_t *usersChoiceP, bool m68kDebugAllowed);
Err HALInvalidateICache(void *ptr, int32_t sz);

void HALReset(bool doHardReset);

//we do not want palmos code to set handlers by accident. their irq numbers were 0-based
//so we mangle ours in a way we can check to not be theirs with some luck
#define REPALM_IRQ_NO_MANGLE(irqn)			(((uint32_t)(irqn)) ^ 0xFACEF00D)



uint32_t HALTimeGetSystemTime(void);


//repalm exports
#define DAL_ADC_VAL_INVALID 	((int32_t)-0x80000000)	//returned if ADC does not support this channel or otherwise cannot service this request
enum AdcValueIdx {
	AdcValVcpu,			//in mV
	AdcValCpuTemp,		//in units of 1/100 degree C
	AdcValBattery,		//in mV
	AdcValBattTemp,		//in units of 1/100 degree C
	AdcValBackup,		//in mV
	AdcValCurrent,		//in mA
	
	AdcValMax = 0x7fffffff,	//make sure it is a 32-bit value
};

enum ClockRateDevice {		//not all of these are meaningful on all hardware types. negative one is returned when no answer exists
	CpuClockRate,
	TimerClockRate,			//timer exported via dalGetTimerVal();
	SdioUnitClockRate,
	NandSpiUnitClockRate,	//or QSPI
	UartUnitClockRate,
	
	ClockRateDeviceMax = 0x7fffffff,	//make sure it is a 32-bit value
};
int32_t repalmDalGetClockRate(enum ClockRateDevice dev);	//in Hz
uint64_t repalmDalGetTimerVal(void);
int32_t repalmDalGetAdcVal(enum AdcValueIdx);


//hypercall export
uint64_t repalmDalHyperCall(uint32_t call, void *data);

//misc
void* dalGetPaceHandlerPtr(void);
Err machinePaceDispatch(EmulStateRef ref, uint16_t call, Err *ret68kP);

//error handling (fatal)
void halErrorHeapAvail(void);
char* halErrorGetBuffer(void);
bool impl_HALErrDisplay(const char *msg, bool forced, uint32_t *usersChoiceP, bool m68kDebugAllowed);	//direct call

//placing thing in places for various hardwares
#ifndef XRAM1
#define XRAM1
#endif

#ifndef XRAM2
#define XRAM2
#endif

#ifndef XRAM3
#define XRAM4
#endif

#ifndef XRAM4
#define XRAM4
#endif



#endif
