#include <PalmOS.h>
#include <ral_export.h>
#include <dal.h>

typedef unsigned long long UInt64;
typedef signed long long Int64;


Err repalmDalLibGetClockRate(UInt16 libRef, Int32 *clockValOutP, UInt32 whichClock)
			SYS_TRAP(sysLibTrapCustom + REPALM_FUNC_IDX_GET_CLOCK_RATE);

Err repalmDalLibGetTimerVal(UInt16 libRef, UInt64 *timerValP)
			SYS_TRAP(sysLibTrapCustom + REPALM_FUNC_IDX_GET_TIMER_VAL);

Err repalmDalLibGetAdcVal(UInt16 libRef, Int32 *adcValP, UInt32 whichAdc)
			SYS_TRAP(sysLibTrapCustom + REPALM_FUNC_IDX_GET_ADC_VALUE);


uint32_t __attribute__((pure)) __udivsi3(uint32_t a, uint32_t b);
/*
{
	uint32_t ret = 0, mask = 1, sh = 1;
	
	while (!(b & 0x80000000)) {
		mask <<= 1;
		b <<= 1;
		sh++;
	}
	
	while (sh--) {
		
		if (a >= b) {
			
			a -= b;
			ret |= mask;
		}
		mask >>= 1;
	}
	
	return ret;
}
*/

int32_t __attribute__((pure)) __divsi3(int32_t n, int32_t d)
{
	if (n < 0 && d < 0)
		return __udivsi3(-n, -d);
	else if (n >= 0 && d >= 0)
		return __udivsi3(n, d);
	else if (n >= 0)
		return -__udivsi3(n, -d);
	else
		return -__udivsi3(-n, d);
}

int32_t __attribute__((pure))__modsi3(int32_t a, int32_t b)
{
	return a - __divsi3(a, b) * b;
}


static void __attribute__((noinline)) /* required to be in the same segment at runtime libs and thus avoid absolute addressing */ ui(void)
{
	UInt16 dalLibRef;
	char x[64], *str;
	DmOpenRef db;
	MemHandle mh;
	FormPtr fp;
	Int32 val;
	Err e;
	
	e = SysLibFind("rePalm DAL", &dalLibRef);
	if (e != errNone)
		e = SysLibLoad('rsrc', 'pdal', &dalLibRef);
	
	if (e) {
		ErrAlertCustom(e, NULL, "Cannot load the DAL:", NULL);
		return;
	}
	
	(void)SysLibOpen(dalLibRef);
	
	fp = FrmInitForm(1000);
	
	str = "<UNKNOWN>";
	db = DmOpenDatabaseByTypeCreator('rsrc', 'pdal', dmModeReadOnly);
	if (db) {
		
		mh = DmGet1Resource('tver', 1000);
		if (mh) {
			str = MemHandleLock(mh);	//Kids, dont try this at home!  (since DAL is in the rom, this will not move.)
			MemHandleUnlock(mh);
			DmReleaseResource(mh);
		}
		DmCloseDatabase(db);
	}
	FrmCopyLabel(fp, 8000, str);
	
	if (errNone != repalmDalLibGetClockRate(dalLibRef, &val, CpuClockRate) || val == -1)
		str = "<UNKNOWN>";
	else
		StrPrintF(str = x, "%ld Hz", val);
	FrmCopyLabel(fp, 8001, str);
	
	if (errNone != repalmDalLibGetAdcVal(dalLibRef, &val, AdcValCpuTemp) || val == DAL_ADC_VAL_INVALID)
		str = "<UNKNOWN>";
	else
		StrPrintF(str = x, "%ld.%02ld \xB0", val / 100, val % 100);
	FrmCopyLabel(fp, 8002, str);
	
	if (errNone != repalmDalLibGetAdcVal(dalLibRef, &val, AdcValVcpu) || val == DAL_ADC_VAL_INVALID)
		str = "<UNKNOWN>";
	else
		StrPrintF(str = x, "%ld.%03ld V", val / 1000, val % 1000);
	FrmCopyLabel(fp, 8003, str);
	
	FrmDoDialog(fp);
	FrmDeleteForm(fp);
	
	(void)SysLibClose(dalLibRef);
}

UInt32
#ifdef __GNUC__
__attribute__((section(".vectors")))
#endif
__Startup__(void)
{
	MemPtr			prevGlobalsP;
	MemPtr			globalsP;
	SysAppInfoPtr	appInfoP;
	

	if (errNone != SysAppStartup(&appInfoP, &prevGlobalsP, &globalsP))
		return 0;

	if (appInfoP->cmd == sysAppLaunchCmdNormalLaunch || appInfoP->cmd == sysAppLaunchCmdPanelCalledFromApp)
		ui();

	SysAppExit(appInfoP, prevGlobalsP, globalsP);
	
	return 0;
}