#define _GNU_SOURCE
#include <stdint.h>
#include <LibTraps.h>
#include "math/math.h"
#include "MathLib.h"
#include "pace.h"
#include <boot.h>
#include <dal.h>
#include <ral.h>


#define MATHLIB_TRAP_NO_MathLibACos			(sysLibTrapCustom)
#define MATHLIB_TRAP_NO_MathLibASin			(sysLibTrapCustom+1)
#define MATHLIB_TRAP_NO_MathLibATan			(sysLibTrapCustom+2)
#define MATHLIB_TRAP_NO_MathLibATan2		(sysLibTrapCustom+3)
#define MATHLIB_TRAP_NO_MathLibCos			(sysLibTrapCustom+4)
#define MATHLIB_TRAP_NO_MathLibSin			(sysLibTrapCustom+5)
#define MATHLIB_TRAP_NO_MathLibTan			(sysLibTrapCustom+6)
#define MATHLIB_TRAP_NO_MathLibSinCos		(sysLibTrapCustom+7)
#define MATHLIB_TRAP_NO_MathLibCosH			(sysLibTrapCustom+8)
#define MATHLIB_TRAP_NO_MathLibSinH			(sysLibTrapCustom+9)
#define MATHLIB_TRAP_NO_MathLibTanH			(sysLibTrapCustom+10)
#define MATHLIB_TRAP_NO_MathLibACosH		(sysLibTrapCustom+11)
#define MATHLIB_TRAP_NO_MathLibASinH		(sysLibTrapCustom+12)
#define MATHLIB_TRAP_NO_MathLibATanH		(sysLibTrapCustom+13)
#define MATHLIB_TRAP_NO_MathLibExp			(sysLibTrapCustom+14)
#define MATHLIB_TRAP_NO_MathLibFrExp		(sysLibTrapCustom+15)
#define MATHLIB_TRAP_NO_MathLibLdExp		(sysLibTrapCustom+16)
#define MATHLIB_TRAP_NO_MathLibLog			(sysLibTrapCustom+17)
#define MATHLIB_TRAP_NO_MathLibLog10		(sysLibTrapCustom+18)
#define MATHLIB_TRAP_NO_MathLibModF			(sysLibTrapCustom+19)
#define MATHLIB_TRAP_NO_MathLibExpM1		(sysLibTrapCustom+20)
#define MATHLIB_TRAP_NO_MathLibLog1P		(sysLibTrapCustom+21)
#define MATHLIB_TRAP_NO_MathLibLogB			(sysLibTrapCustom+22)
#define MATHLIB_TRAP_NO_MathLibLog2			(sysLibTrapCustom+23)
#define MATHLIB_TRAP_NO_MathLibPow			(sysLibTrapCustom+24)
#define MATHLIB_TRAP_NO_MathLibSqrt			(sysLibTrapCustom+25)
#define MATHLIB_TRAP_NO_MathLibHypot		(sysLibTrapCustom+26)
#define MATHLIB_TRAP_NO_MathLibCbrt			(sysLibTrapCustom+27)
#define MATHLIB_TRAP_NO_MathLibCeil			(sysLibTrapCustom+28)
#define MATHLIB_TRAP_NO_MathLibFAbs			(sysLibTrapCustom+29)
#define MATHLIB_TRAP_NO_MathLibFloor		(sysLibTrapCustom+30)
#define MATHLIB_TRAP_NO_MathLibFMod			(sysLibTrapCustom+31)
#define MATHLIB_TRAP_NO_MathLibIsInf		(sysLibTrapCustom+32)
#define MATHLIB_TRAP_NO_MathLibFinite		(sysLibTrapCustom+33)
#define MATHLIB_TRAP_NO_MathLibScalBN		(sysLibTrapCustom+34)
#define MATHLIB_TRAP_NO_MathLibDRem			(sysLibTrapCustom+35)
#define MATHLIB_TRAP_NO_MathLibSignificand	(sysLibTrapCustom+36)
#define MATHLIB_TRAP_NO_MathLibCopySign		(sysLibTrapCustom+37)
#define MATHLIB_TRAP_NO_MathLibIsNaN		(sysLibTrapCustom+38)
#define MATHLIB_TRAP_NO_MathLibILogB		(sysLibTrapCustom+39)
#define MATHLIB_TRAP_NO_MathLibRInt			(sysLibTrapCustom+40)
#define MATHLIB_TRAP_NO_MathLibNextAfter	(sysLibTrapCustom+41)
#define MATHLIB_TRAP_NO_MathLibRemainder	(sysLibTrapCustom+42)
#define MATHLIB_TRAP_NO_MathLibScalB		(sysLibTrapCustom+43)
#define MATHLIB_TRAP_NO_MathLibRound		(sysLibTrapCustom+44)
#define MATHLIB_TRAP_NO_MathLibTrunc		(sysLibTrapCustom+45)
#define MATHLIB_TRAP_NO_MathLibSignBit		(sysLibTrapCustom+46)


#define DOUBLE_IN_DOUBLE_OUT(name)								\
		case MATHLIB_TRAP_NO_ ## name:							\
			x = mathLibPrvReadStackDouble(ref, 2);				\
			ret = impl_ ## name (x, &r);						\
			mathLibPrvWriteMemDoubleToStackAddr(ref, 10, r);	\
			break;

#define DOUBLEx2_IN_DOUBLE_OUT(name)							\
		case MATHLIB_TRAP_NO_ ## name:							\
			x = mathLibPrvReadStackDouble(ref, 2);				\
			y = mathLibPrvReadStackDouble(ref, 10);				\
			ret = impl_ ## name (x, y, &r);						\
			mathLibPrvWriteMemDoubleToStackAddr(ref, 18, r);	\
			break;

#define DOUBLE_IN_DOUBLEx2_OUT(name)							\
		case MATHLIB_TRAP_NO_ ## name:							\
			x = mathLibPrvReadStackDouble(ref, 2);				\
			ret = impl_ ## name (x, &r, &r2);					\
			mathLibPrvWriteMemDoubleToStackAddr(ref, 10, r);	\
			mathLibPrvWriteMemDoubleToStackAddr(ref, 14, r2);	\
			break;

#define DOUBLE_IN_S16_OUT(name)									\
		case MATHLIB_TRAP_NO_ ## name:							\
			x = mathLibPrvReadStackDouble(ref, 2);				\
			ret = impl_ ## name (x, &s16);						\
			mathLibPrvWriteMemS16ToStackAddr(ref, 10, s16);		\
			break;

#define DOUBLE_AND_S16_IN_DOUBLE_OUT(name)						\
		case MATHLIB_TRAP_NO_ ## name:							\
			x = mathLibPrvReadStackDouble(ref, 2);				\
			s16 = PceReadInt16From68KStack(ref, 10);			\
			ret = impl_ ## name (x, s16, &r);					\
			mathLibPrvWriteMemDoubleToStackAddr(ref, 12, r);	\
			break;

union DoubleAccess {
	struct {
		uint32_t loWord;
		uint32_t hiWord;
	};
	double d;
};

static double mathLibPrvReadStackDouble(EmulStateRef ref, int32_t stackOfst)
{
	union DoubleAccess d;
	
	d.hiWord = PceReadInt32From68KStack(ref, stackOfst);
	d.loWord = PceReadInt32From68KStack(ref, stackOfst + 4);
	
	return d.d;
}

static void mathLibPrvWriteMemDoubleToStackAddr(EmulStateRef ref, int32_t stackOfstToPtr, double val)
{
	union DoubleAccess d = {.d = val};
	void *at = (void*)PceReadInt32From68KStack(ref, stackOfstToPtr);
	
	PceWriteInt32To68KMemory(ref, at, 0, d.hiWord);
	PceWriteInt32To68KMemory(ref, at, 4, d.loWord);
}

static void mathLibPrvWriteMemS16ToStackAddr(EmulStateRef ref, int32_t stackOfstToPtr, int16_t val)
{
	PceWriteInt16To68KMemory(ref, (void*)PceReadInt32From68KStack(ref, stackOfstToPtr), 0, val);
}

static void mathLibPrvWriteMemU32ToStackAddr(EmulStateRef ref, int32_t stackOfstToPtr, uint32_t val)
{
	PceWriteInt32To68KMemory(ref, (void*)PceReadInt32From68KStack(ref, stackOfstToPtr), 0, val);
}

Err impl_MathLibACos(double x, double *result)
{
	*result = __ieee754_acos(x);
	
	return errNone;
}

Err impl_MathLibASin(double x, double *result)
{
	*result = __ieee754_asin(x);
	
	return errNone;
}

Err impl_MathLibATan(double x, double *result)
{
	*result = __atan(x);
	
	return errNone;
}

Err impl_MathLibATan2(double y, double x, double *result)
{
	*result = __ieee754_atan2(y, x);
	
	return errNone;
}
Err impl_MathLibCos(double x, double *result)
{
	*result = __cos(x);
	
	return errNone;
}

Err impl_MathLibSin(double x, double *result)
{
	*result = __sin(x);
	
	return errNone;
}

Err impl_MathLibTan(double x, double *result)
{
	*result = __tan(x);
	
	return errNone;
}

Err impl_MathLibSinCos(double x, double *sinx, double *cosx)
{
	__sincos(x, sinx, cosx);
	
	return errNone;
}

Err impl_MathLibCosH(double x, double *result)
{
	*result = __ieee754_cosh(x);
	
	return errNone;
}

Err impl_MathLibSinH(double x, double *result)
{
	*result = __ieee754_sinh(x);
	
	return errNone;
}

Err impl_MathLibTanH(double x, double *result)
{
	*result = __tanh(x);
	
	return errNone;
}

Err impl_MathLibACosH(double x, double *result)
{
	*result = __ieee754_acosh(x);
	
	return errNone;
}

Err impl_MathLibASinH(double x, double *result)
{
	*result = __asinh(x);
	
	return errNone;
}

Err impl_MathLibATanH(double x, double *result)
{
	*result = __ieee754_atanh(x);
	
	return errNone;
}

Err impl_MathLibExp(double x, double *result)
{
	*result = __ieee754_exp(x);
	
	return errNone;
}

Err impl_MathLibFrExp(double x, double *fraction, int16_t *exponent)
{
	int expo;
	
	*fraction = __frexp(x, &expo);
	*exponent = expo;
	
	return errNone;
}

Err impl_MathLibLdExp(double x, int16_t exponent, double *result)
{
	*result = __ldexp(x, exponent);
	
	return errNone;
}

Err impl_MathLibLog(double x, double *result)
{
	*result = __ieee754_log(x);
	
	return errNone;
}

Err impl_MathLibLog10(double x, double *result)
{
	*result = __ieee754_log10(x);
	
	return errNone;
}

Err impl_MathLibModF(double x, double *intpart, double *fracpart)
{
	*fracpart = __modf(x, intpart);
	
	return errNone;
}

Err impl_MathLibExpM1(double x, double *result)
{
	*result = __expm1(x);
	
	return errNone;
}

Err impl_MathLibLog1P(double x, double *result)
{
	*result = __log1p(x);
	
	return errNone;
}

Err impl_MathLibLogB(double x, double *result)
{
	*result = __logb(x);
	
	return errNone;
}

Err impl_MathLibLog2(double x, double *result)
{
	*result = __log2(x);
	
	return errNone;
}

Err impl_MathLibPow(double x, double y, double *result)
{
	*result = __ieee754_pow(x, y);
	
	return errNone;
}

Err impl_MathLibSqrt(double x, double *result)
{
	*result = __ieee754_sqrt(x);
	
	return errNone;
}

Err impl_MathLibHypot(double x, double y, double *result)
{
	*result = __ieee754_hypot(x, y);
	
	return errNone;
}

Err impl_MathLibCbrt(double x, double *result)
{
	*result = __cbrt(x);
	
	return errNone;
}

Err impl_MathLibCeil(double x, double *result)
{
	*result = __ceil(x);
	
	return errNone;
}

Err impl_MathLibFAbs(double x, double *result)
{
	*result = __fabs(x);
	
	return errNone;
}

Err impl_MathLibFloor(double x, double *result)
{
	*result = __floor(x);
	
	return errNone;
}

Err impl_MathLibFMod(double x, double y, double *result)
{
	*result = __ieee754_fmod(x, y);
	
	return errNone;
}

Err impl_MathLibIsInf(double x, int16_t *result)
{
	*result = __isinf(x);
	
	return errNone;
}

Err impl_MathLibFinite(double x, int16_t *result)
{
	*result = __finite(x);
	
	return errNone;
}

Err impl_MathLibScalBN(double x, int16_t exponent, double *result)
{
	*result = __scalbn(x, exponent);
	
	return errNone;
}

Err impl_MathLibDRem(double x, double y, double *result)
{
	*result = __ieee754_remainder(x, y);
	
	return errNone;
}

Err impl_MathLibSignificand(double x, double *result)
{
	*result = __significand(x);
	
	return errNone;
}

Err impl_MathLibCopySign(double x, double y, double *result)
{
	*result = __copysign(x, y);
	
	return errNone;
}

Err impl_MathLibIsNaN(double x, int16_t *result)
{
	*result = __isnan(x);
	
	return errNone;
}

Err impl_MathLibILogB(double x, int16_t *result)
{
	*result = __ilogb(x);
	
	return errNone;
}

Err impl_MathLibRInt(double x, double *result)
{
	*result = __rint(x);
	
	return errNone;
}

Err impl_MathLibNextAfter(double x, double y, double *result)
{
	*result = __nextafter(x, y);
	
	return errNone;
}

Err __attribute__ ((alias ("impl_MathLibDRem")))impl_MathLibRemainder(double x, double y, double *result);

Err impl_MathLibScalB(double x, double exponent, double *result)
{
	extern double scalb(double x, double exp);	//gcc built-in not declared in math.h
	*result = __ieee754_scalb(x, exponent);
	
	return errNone;
}

Err impl_MathLibRound(double x, double *result)
{
	*result = __round(x);
	
	return errNone;
}

Err impl_MathLibTrunc(double x, double *result)
{
	*result = __trunc(x);
	
	return errNone;
}

Err impl_MathLibSignBit(double x, uint32_t *result)
{
	*result = __signbit(x);
	
	return errNone;
}

static Err mathLibPrvPaceEntry(EmulStateRef ref, void* param, uint16_t call)
{
	if(call == 0)
		((void**)param)[5] = "MathLib";
	else if (call != 1) {
		
		Err ret;	//value returned to 68k
		double x, y, r, r2;
		uint32_t u32;
		int16_t s16;
		
		switch(call) {
			case sysLibTrapOpen:
			case sysLibTrapClose:
			case sysLibTrapSleep:
			case sysLibTrapWake:
				ret = errNone;
				break;
			
			DOUBLE_IN_DOUBLE_OUT(MathLibACos)
			DOUBLE_IN_DOUBLE_OUT(MathLibASin)
			DOUBLE_IN_DOUBLE_OUT(MathLibATan)
			DOUBLEx2_IN_DOUBLE_OUT(MathLibATan2)
			DOUBLE_IN_DOUBLE_OUT(MathLibCos)
			DOUBLE_IN_DOUBLE_OUT(MathLibSin)
			DOUBLE_IN_DOUBLE_OUT(MathLibTan)
			DOUBLE_IN_DOUBLEx2_OUT(MathLibSinCos)
			DOUBLE_IN_DOUBLE_OUT(MathLibCosH)
			DOUBLE_IN_DOUBLE_OUT(MathLibSinH)
			DOUBLE_IN_DOUBLE_OUT(MathLibTanH)
			DOUBLE_IN_DOUBLE_OUT(MathLibACosH)
			DOUBLE_IN_DOUBLE_OUT(MathLibASinH)
			DOUBLE_IN_DOUBLE_OUT(MathLibATanH)
			DOUBLE_IN_DOUBLE_OUT(MathLibExp)
			
			case MATHLIB_TRAP_NO_MathLibFrExp:
				x = mathLibPrvReadStackDouble(ref, 2);
				ret = impl_MathLibFrExp(x, &r, &s16);
				mathLibPrvWriteMemDoubleToStackAddr(ref, 8, r);
				mathLibPrvWriteMemS16ToStackAddr(ref, 12, s16);
				break;
			
			DOUBLE_AND_S16_IN_DOUBLE_OUT(MathLibLdExp)
			DOUBLE_IN_DOUBLE_OUT(MathLibLog)
			DOUBLE_IN_DOUBLE_OUT(MathLibLog10)
			DOUBLE_IN_DOUBLEx2_OUT(MathLibModF)
			DOUBLE_IN_DOUBLE_OUT(MathLibExpM1)
			DOUBLE_IN_DOUBLE_OUT(MathLibLog1P)
			DOUBLE_IN_DOUBLE_OUT(MathLibLogB)
			DOUBLE_IN_DOUBLE_OUT(MathLibLog2)
			DOUBLEx2_IN_DOUBLE_OUT(MathLibPow)
			DOUBLE_IN_DOUBLE_OUT(MathLibSqrt)
			DOUBLEx2_IN_DOUBLE_OUT(MathLibHypot)
			DOUBLE_IN_DOUBLE_OUT(MathLibCbrt)
			DOUBLE_IN_DOUBLE_OUT(MathLibCeil)
			DOUBLE_IN_DOUBLE_OUT(MathLibFAbs)
			DOUBLE_IN_DOUBLE_OUT(MathLibFloor)
			DOUBLEx2_IN_DOUBLE_OUT(MathLibFMod)
			DOUBLE_IN_S16_OUT(MathLibIsInf)
			DOUBLE_IN_S16_OUT(MathLibFinite)
			DOUBLE_AND_S16_IN_DOUBLE_OUT(MathLibScalBN)
			DOUBLEx2_IN_DOUBLE_OUT(MathLibDRem)
			DOUBLE_IN_DOUBLE_OUT(MathLibSignificand)
			DOUBLEx2_IN_DOUBLE_OUT(MathLibCopySign)
			DOUBLE_IN_S16_OUT(MathLibIsNaN)
			DOUBLE_IN_S16_OUT(MathLibILogB)
			DOUBLE_IN_DOUBLE_OUT(MathLibRInt)
			DOUBLEx2_IN_DOUBLE_OUT(MathLibNextAfter)
			DOUBLEx2_IN_DOUBLE_OUT(MathLibRemainder)
			DOUBLEx2_IN_DOUBLE_OUT(MathLibScalB)
			DOUBLE_IN_DOUBLE_OUT(MathLibRound)
			DOUBLE_IN_DOUBLE_OUT(MathLibTrunc)
			
			case MATHLIB_TRAP_NO_MathLibSignBit:
				x = mathLibPrvReadStackDouble(ref, 2);
				ret = impl_MathLibSignBit(x, &u32);
				mathLibPrvWriteMemU32ToStackAddr(ref, 8, s16);
				break;
			
			default:
				return sysErrNotAllowed;
		}
		//all our calls return the same type so that is nice
		PceSet68KInt16ReturnResult(ref, ret);
	}
	return errNone;
}

uint32_t __attribute__((used)) PilotMain(uint16_t cmd, void* cmdPBP, uint16_t flags)
{
	if (cmd == RAL_CMD_GET_PACE_ENTRY)
		*(void**)cmdPBP = &mathLibPrvPaceEntry;
	
	return errNone;
}



