#include "bitfield.h"




uint32_t bitfieldRead(const uint32_t *bf, uint32_t elemSz, uint32_t idx)	//the value will at most be in two uint32 values
{
	uint32_t firstIdx = idx * elemSz / 32, startBit = idx * elemSz % 32, secondIdx = firstIdx + 1, numBitsAvailFirstByte = 32 - startBit;
	uint32_t numBitsUsedFirstWord = numBitsAvailFirstByte > elemSz ? elemSz : numBitsAvailFirstByte;
	uint32_t numBitsSecondWord = elemSz - numBitsUsedFirstWord, val;
	
	val = (bf[firstIdx] >> startBit) & ((1 << numBitsUsedFirstWord) - 1);	//get low bits
	if (numBitsSecondWord)
		val += (bf[secondIdx] & ((1 << numBitsSecondWord) - 1)) << numBitsUsedFirstWord;
	
	return val;
}

void bitfieldWrite(uint32_t *bf, uint32_t elemSz, uint32_t idx, uint32_t val)
{
	uint32_t firstIdx = idx * elemSz / 32, startBit = idx * elemSz % 32, secondIdx = firstIdx + 1, numBitsAvailFirstByte = 32 - startBit;
	uint32_t numBitsUsedFirstWord = numBitsAvailFirstByte > elemSz ? elemSz : numBitsAvailFirstByte;
	uint32_t numBitsSecondWord = elemSz - numBitsUsedFirstWord;
	uint32_t firstWordMask = ((1 << numBitsUsedFirstWord) - 1) << startBit;
	uint32_t secondWordMask = (1 << numBitsSecondWord) - 1;
	
	bf[firstIdx] = (bf[firstIdx] &~ firstWordMask) | ((val << startBit) & firstWordMask);
	if (numBitsSecondWord)
		bf[secondIdx] = (bf[secondIdx] &~ secondWordMask) | ((val >> numBitsUsedFirstWord) & secondWordMask);
}

