#ifndef __PSOC40xx__
#define __PSOC40xx__

#ifdef __cplusplus
 extern "C" {
#endif 


typedef enum IRQn
{
/******  Cortex-M0 Processor Exceptions Numbers ***************************************************/
  Reset_IRQn                    = -15,    /*!< 1 Reset Vector, invoked on Power up and warm reset*/  
  NonMaskableInt_IRQn           = -14,    /*!< 2 Non Maskable Interrupt                           */
  HardFault_IRQn                = -13,    /*!< 3 Cortex-M0 Hard Fault Interrupt                   */
  SVCall_IRQn                   = -5,     /*!< 11 Cortex-M0 SV Call Interrupt                     */
  PendSV_IRQn                   = -2,     /*!< 14 Cortex-M0 Pend SV Interrupt                     */
  SysTick_IRQn                  = -1,     /*!< 15 Cortex-M0 System Tick Interrupt                 */

/******  PSoC4 Specific Interrupt Numbers ********************************************************/

  GPIO0_IRQn                    =  0,
  GPIO1_IRQn                    =  1,
  GPIO2_IRQn                    =  2,
  GPIO3_IRQn                    =  3,
  WDT_IRQn                      =  4,
  SCB_IRQn                      =  5,
  SPC_IRQn                      =  6,
  CSD_IRQn                      =  7,
  TCPWM0_IRQn                   =  8,
} IRQn_Type;


#define __NVIC_PRIO_BITS          2         /*!< Number of Bits used for Priority Levels          */
#define __Vendor_SysTickConfig    0         /*!< Set to 1 if different SysTick Config is used     */

struct PsocGpioPrtType {
	struct {
		volatile uint32_t DR;
		volatile uint32_t PS;
		volatile uint32_t PC;
		volatile uint32_t INTR_CFG;
		volatile uint32_t INTR;
		uint32_t reserved1;
		volatile uint32_t PC2;
		uint32_t reserved2[9];
		volatile uint32_t DR_SET;
		volatile uint32_t DR_CLR;
		volatile uint32_t DR_INV;
		uint32_t reserved3[45];
	}PRT[4];
};

struct PsocHsiomPrtType {
	struct {
		volatile uint32_t SEL;
		uint32_t reserved3[63];
		
	}PRT[4];
};

struct PsocCpussType {
	volatile uint32_t CONFIG;
	volatile uint32_t SYSREQ;
	volatile uint32_t SYSARG;
	volatile uint32_t PROTECTION;	/*PRIVILEDGED*/
	volatile uint32_t PRIV_ROM;		/*PRIVILEDGED*/ //low16 - BROM, high16 - SROM
	volatile uint32_t PRIV_RAM;		/*PRIVILEDGED*/
	volatile uint32_t PRIV_FLASH;	/*PRIVILEDGED*/
	volatile uint32_t WOUNDING;		/*PRIVILEDGED*/
	uint32_t reserved3[4];
	volatile uint32_t FLASH_CTL;
	volatile uint32_t ROM_CTL;
};

struct PsocSpcifType {
	volatile uint32_t GEOMETRY;
	volatile uint32_t ADRCTRL;				/*PRIVILEDGED*/
	volatile uint32_t FLASH_OP_TIMER;		/*PRIVILEDGED*/
	volatile uint32_t FLASH_LL_CTRL;		/*PRIVILEDGED*/
	volatile uint32_t WRITE_LATCH_VAL;		/*PRIVILEDGED*/
	uint32_t reserved1[5];
	volatile uint32_t NONBLOCKING_STATUS;	/*PRIVILEDGED*/
	uint32_t reserved2[1];
	volatile uint32_t FLASH_VIEWCTL;		/*PRIVILEDGED*/
	uint32_t reserved3[495];
	volatile uint32_t INTR;
	volatile uint32_t INTR_SET;
	volatile uint32_t INTR_MASK;
	volatile uint32_t INTR_MASKED;
	uint32_t reserved4[15808];
	volatile uint32_t TRIM_M0_DAC0;			/*PRIVILEDGED*/
	volatile uint32_t unknown_ff04;			/*PRIVILEDGED*/
	volatile uint32_t DAC_SETTINGS;			/*PRIVILEDGED*/
	volatile uint32_t unknown_ff0c;			/*PRIVILEDGED*/
};




#include "core_cm0.h"
#include "core_cmInstr.h"



#define HSIOM_PRT		((struct PsocHsiomPrtType*)0x40020000ul)
#define GPIO_PRT		((struct PsocGpioPrtType*) 0x40040000ul)
#define CPUSS			((struct PsocCpussType*)   0x40100000ul)
#define SPCIF			((struct PsocSpcifType*)   0x40110000ul)


#define SROM_START		0x0FFFF000ul

#ifdef __cplusplus
}
#endif

#endif
