#include "app.h"


#define REFRESH_PRESCALE_NONE	0x08
#define REFRESH_PRESCALE_2X		0x00
#define REFRESH_PRESCALE_4X		0x01
#define REFRESH_PRESCALE_8X		0x02
#define REFRESH_PRESCALE_16X	0x03
#define REFRESH_PRESCALE_32X	0x04
#define REFRESH_PRESCALE_64X	0x05
#define REFRESH_PRESCALE_128X	0x06
#define REFRESH_PRESCALE_256X	0x07




#ifdef PIC16F1823
	__CONFIG(FOSC_INTOSC & WDTE_OFF & PWRTE_OFF & MCLRE_OFF & CP_OFF & CPD_OFF & BOREN_OFF & CLKOUTEN_OFF & IESO_OFF & FCMEN_OFF);
	__CONFIG(WRT_OFF & PLLEN_OFF & STVREN_OFF & BORV_19  & LVP_OFF);
	
	#ifdef CONST_BRI
		#define REFRESH_TIMER				0x60
		#define REFRESH_TIMER_PRESCALER		REFRESH_PRESCALE_8X
	#else
		#define REFRESH_TIMER				0x40
		#define REFRESH_TIMER_PRESCALER		REFRESH_PRESCALE_64X
	#endif

#else
	__CONFIG(FOSC_INTOSCIO & WDTE_OFF & PWRTE_OFF & MCLRE_OFF & CP_OFF & CPD_OFF & BOREN_OFF & IESO_OFF & FCMEN_OFF);

	#ifdef CONST_BRI
		#define REFRESH_TIMER				0xD0
		#define REFRESH_TIMER_PRESCALER		REFRESH_PRESCALE_NONE
	#else
		#define REFRESH_TIMER				0x00
		#define REFRESH_TIMER_PRESCALER		REFRESH_PRESCALE_8X
	#endif

#endif

#define TMR1_TICKS_NEEDED				(_XTAL_FREQ/4/8/RTC_TICKS_PER_SEC)
#define TMR1_RESET_VAL					(0x10000UL - TMR1_TICKS_NEEDED)	//rtc is kept in units of 1/50 of a second

#if TMR1_TICKS_NEEDED > 0x10000UL			//this check never fires...sorry...
	#error "clock too fast or RTC_TICKS_PER_SEC too low"
#endif


//each 2 horizontally- consequitive LEDs are in opposite polarity, so we do not need to store 110 points, just 55
//high nibble is pin to raise, low is pin to lower
static const UInt8 led2wire[] =	{
									0x05, 0x04, 0x03, 0x02, 0x01,
									0x0A, 0x08, 0x09, 0x07, 0x06,
									0x16, 0x15, 0x14, 0x13 ,0x12,
									0x82, 0x1A, 0x18, 0x19, 0x17,
									0x27, 0x26, 0x25, 0x24, 0x23,
									0x83, 0x93, 0x73, 0x2A, 0x29,
									0x94, 0x3A, 0x36, 0x35, 0x34,
									0x4A, 0x48, 0x47, 0x46, 0x45,
									0x5A, 0x58, 0x59, 0x57, 0x56,
									0x87, 0x6A, 0x68, 0x69, 0x67,
									0x7A, 0x79, 0x9A, 0x98, 0x8A,
									0xBB		//here to allow us to light no LEDs and still use up the same exact amount of cycles
								};

#ifdef CONST_BRI
	static const UInt8 shifts[] = {1, 2, 4, 8, 16, 32, 64, 128};
#else
	static const UInt8 wire2led[11][10] =	{	//wire# to led whose high end this wire goes to
												{0, 2, 4, 6, 8, 10, 12, 14, 16, 18},			// 0
												{20, 22, 24, 26, 28, 32, 34, 36, 38, 9},		// 1
												{40, 42, 44, 46, 48, 56, 58, 7, 29, 31},		// 2
												{62, 64, 66, 68, 5, 27, 49, 51, 53, 55},		// 3
												{70, 72, 74, 76, 78, 3, 25, 47, 61, 69},		// 4
												{80, 82, 84, 86, 88, 1, 23, 45, 67, 79},		// 5
												{92, 94, 96, 98, 19, 21, 43, 65, 77, 89},		// 6
												{100, 102, 91, 17, 39, 41, 54, 75, 87, 99},		// 7
												{30, 50, 90, 108, 13, 35, 73, 83, 95, 107},		// 8
												{60, 104, 106, 15, 37, 52, 59, 85, 97, 103}, 	// 9
												{11, 33, 57, 63, 71, 81, 93, 101, 105, 109}		// 10
											};										
#endif

static const UInt8 wire2trisa[] = { 0xDF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFD, 0xFE, 0xFF};
static const UInt8 wire2porta[] = { 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x01, 0x00};
static const UInt8 wire2trisc[] = { 0xFF, 0xFF, 0xDF, 0xEF, 0xF7, 0xFB, 0xFD, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF};
static const UInt8 wire2portc[] = { 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00};


#ifdef DOUBLE_BUFFER
	static UInt8 fb[2][14] = {0};
	static UInt8 fbWhich = 0;	//which bufer is front?
#else
	static UInt8 fb[1][14] = {0};
	#define fbWhich 0
#endif

static volatile UInt8 frameNo = 0;


static volatile UInt32 rtc = 0;

void interrupt isr(void){

	if(INTCONbits.T0IF){

		#ifdef CONST_BRI

			static UInt8 curNum = 0;
			UInt8 num;
			UInt8* img_f = fb[fbWhich];
		
			num =(img_f[curNum >> 3] & shifts[curNum & 7]) ? curNum : 110;
		
			//static void LED(UInt8 num)
			{
				UInt8 hi, lo, trisa, trisc, porta, portc;
			
				//look up LED data
				hi = led2wire[num >> 1];
			
				//decode LED data into high and low wires
				if(num & 1){
					lo = hi >> 4;
					hi &= 0x0F;
				}
				else{
					lo = hi & 0x0F;
					hi >>= 4;
				}
			
				trisa = wire2trisa[hi] & wire2trisa[lo];
				trisc = wire2trisc[hi] & wire2trisc[lo];
				porta = wire2porta[hi];
				portc = wire2portc[hi];
			
				//put settings in effect. We are careful to avoid needless LED flashes here
				TRISA = 0x3F;
				TRISC = trisc;
				PORTC = 0;
				TRISA = trisa;
				PORTA = porta;
				PORTC = portc;
			}
			curNum++;
			if(curNum == 110){
				curNum = 0;
				frameNo++;
			}
		#else
			static UInt8 curWire = 0;
			UInt8 i, w, hi, lo, trisa, trisc, porta, portc;
			UInt8* img_f = fb[fbWhich];	
	
			trisa = wire2trisa[curWire];
			trisc = wire2trisc[curWire];
			porta = wire2porta[curWire];
			portc = wire2portc[curWire];
	
			for(i = 0; i < 10; i++){
	
				w = wire2led[curWire][i];
				if(img_f[w >> 3] & (1 << (w & 7))){
	
					hi = led2wire[w >> 1];
					if(w & 1){
						lo = hi >> 4;
						hi &= 0x0F;
					}
					else{
						lo = hi & 0x0F;
						hi >>= 4;
					}
		
					trisa &= wire2trisa[lo];
					trisc &= wire2trisc[lo];
				}
			}
	
			TRISA = 0x3F;
			TRISC = trisc;
			PORTC = 0;
			TRISA = trisa;
			PORTA = porta;
			PORTC = portc;
	
			if(++curWire == 11){
	
				curWire = 0;
				frameNo++;
			}
		#endif

		INTCONbits.T0IF = 0;
		TMR0 = REFRESH_TIMER;		//if your array flickers, increase this. If it doesn't, decrease this till it does to give main app more CPU time
	}
	if(PIR1bits.TMR1IF){	//fake RTC

		rtc++;
		TMR1			+= TMR1_RESET_VAL;	//start RTC
		PIR1bits.TMR1IF = 0;
	}
	if(IOCIF){

		static UInt8 ctr = 0;

		if(ctr++ == 60){

			ctr = 0;
			rtc++;
		}
		IOCAF3 = 0;
		IOCIF = 0;
		(volatile UInt8)PORTA;
	}
}			

UInt32 appReadRtc(void){

	UInt32 v;
	
	do{		//think about it :)

		v = rtc;

	}while(rtc != v);

	return v;
}

UInt16 appGetRand(){

	static UInt16 v = 0x3145;
	UInt8 i;
	UInt32 j;
	
	for(i = 0; i < 8; i++){

		UInt16 adc;
		{	//read i-th ADC
		
			UInt16 H, L;
		
			ADCON0 = 0b10000001 | (i << 2);
			ADCON1 = 0x00;	//fast = more noisy?
			ADCON0 |= 2;
			while(ADCON0 & 2);
		
			H = ADRESH & 0x03;
			L = ADRESL;
			adc = (H << 8) | L;
		}
		v = (v >> 3) | (v << 13);
		v ^= adc;
	}
	
	j = v;
	j *= 17;
	j += 31;
	j %= 0x1000001UL;
	v = j;
	return j >> 8;
}

UInt8* appBufGet(Boolean back){

#ifdef DOUBLE_BUFFER
	UInt8 which = fbWhich ^ back;
#else
	UInt8 which = fbWhich;
#endif
	return fb[which];
}

void appBufFlip(void){

#ifdef DOUBLE_BUFFER
	fbWhich ^= 1;
#endif
}

void appBufCopy(void){

#ifdef DOUBLE_BUFFER
	UInt8 i;
	UInt8* f;
	UInt8* b;

	f = fb[fbWhich];
	b = fb[fbWhich ^ 1];

	for(i = 0; i < 14; i++) f[i] = b[i];
#endif
}

UInt8 appGetFrameNo(void){

	return frameNo;
}


char* strend(char* dst){

	while(*dst) dst++;
	return dst;
}

void strcpy(char* dst, const char* src){

	while(*dst++ = *src++);
}

void strcat(char* dst, const char* str){

	strcpy(strend(dst), str);
}

void stratoicat(char* dst, UInt16 v){

	UInt16 t;

	dst = strend(dst);
	

	t = v;
	do{
		dst++;
		t /= 10;
	}while(t);

	*dst-- = 0;

	do{

		*dst-- = '0' + (v % 10);
		v /= 10;
	}while(v);
}

void main(void){

	OPTION_REG = 0x80 | REFRESH_TIMER_PRESCALER;
#ifdef PIC16F1823
	OSCCON		= 0xF0;	//32MHz
	OSCTUNE		= 0x1F;	//max tuned speed (33MHz)
#else
	OSCCON		= 0x77;	//use internal 8MHz clock
	OSCTUNE		= 0x0F;	//max tuned speed (9MHz)
#endif
	WPUA		= 0x00;	//no pullups
#ifndef PIC16F1823
	IOCA		= 0x00;	//no interupts
#endif
	PIE1		= 0x00;	//no peripheral ints on
	PIR1		= 0x00;	//clear periph ints status
	INTCON		= 0xC0;	//ints enabled in general, perpheral ints too
#ifdef PIC16F1823
	ANSELA		= 0x00;	//no analog pins
#else
	ANSEL		= 0x00;	//no analog pins
#endif
	ADCON0		= 0x00;	//A/D converters off
	TXSTA		= 0x00;	//no UART transmit
	RCSTA		= 0x00;	//no UART receive
#ifndef PIC16F1823
	VRCON		= 0x00;	//no voltage reference
	CMCON0		= 0x07;	//comparators off
#endif

#if defined(PIC16F1823) && 0	//uses real rtc

		IOCAP3 = 1;
		IOCAN3 = 0;
		IOCIF = 0;
		IOCIE = 1;

#else				//fake rtc

		T1CON		= 0x31;	//timer1 on, increments on 250 KHz clock
	
		TMR1			= TMR1_RESET_VAL;	//start RTC
		PIE1bits.TMR1IE	= 1;
#endif

	TMR0 			= 0x00;				//start display sometime soon
	INTCONbits.T0IE	= 1;

//	appIgor();
//	appMarquee(NULL);

	appMarquee("  - CoolLedBoard v1.0 - Life Game v 2.1 - ");

	while(1){
		UInt16 started, born, died, generations;
		UInt32 livedTime;
		char str[77];

		appLife(&started, &born, &died, &generations, &livedTime);

/*
		appMarquee("  Game over");

		strcpy(str, "  ");
		stratoicat(str, started);
		strcat(str, " started, ");
		stratoicat(str, born);
		strcat(str, " born, ");
		stratoicat(str, died);
		strcat(str, " died over ");
		stratoicat(str, generations);
		strcat(str, " generations ");
		appMarquee(str);

		strcpy(str, "Avg lifespan: ");
		born += started;
		stratoicat(str, livedTime / born);
		strcat(str, ".");
		stratoicat(str, ((livedTime % born) * 10 + (born / 2)) / born);
		strcat(str, " ");
		appMarquee(str);
*/
	}
}
