#include "protocol.h"
#include "nwk.h"
#include "nRF.h"

static uint32_t my_addr;


#define MY_PROTO_VER		0x00010000
#define MY_FW_VER		0x00010002

void nwkInit(uint32_t _my_addr)
{
	nrfInit(RF_CHANNEL, RF_PWR_3);	
	nrfSetPowerState(true);
	nrfRxEnable(true);
	my_addr = _my_addr;
	nrfSetAddr(NRF_ADDR_MINE, _my_addr);
}

char nwkPoll(uint8_t *briP, uint8_t *paramP)
{
	struct rf_packet p;
	uint32_t from;
	uint8_t in_len, len;
	
	len = nrfRecv(&p, sizeof(p));
	if (len < sizeof(struct rf_hdr)) return false;	//too small
	len -= sizeof(struct rf_hdr);
	from = p.hdr.addr;
	nrfSetAddr(NRF_ADDR_TO, from);
	p.hdr.addr = my_addr;
	in_len = len;
	len = 0;
	
	switch (p.hdr.type){
	
		case PKT_PROTO_VERSION:
			if (in_len  != 0) break;
			p.hdr.type = PKT_PROTO_VER;
			p.ver = MY_PROTO_VER;
			len = sizeof(uint32_t) + sizeof(struct rf_hdr);
			break;
		
		case PKT_GET_FW_VER:
			if (in_len  != 0) break;
			p.hdr.type = PKT_FW_VER;
			p.ver = MY_FW_VER;
			len = sizeof(uint32_t) + sizeof(struct rf_hdr);
			break;
			
		case PKT_CHG_BRI:
			if (in_len != 1) break;
			(*briP) += p.change;
			if (!(*briP)) (*briP) = 1;
			if ((*briP) == 32) (*briP) = 31;
			break;
		
		case PKT_CHG_SPEED:
			if (in_len != 1) break;
			if (!(*paramP) && p.change < 0) break;
			if ((*paramP) == 255 && p.change > 0) break;
			(*paramP) += p.change;
			break;
		
		case PKT_CHG_PATTERN:
			if (in_len != 1) break;
			return true;
			break;
	}
	
	if(len) {
		nrfRxEnable(false);
		nrfSend(&p, len, NUM_RETRIES);
		nrfRxEnable(true);
	}
	
	return false;
}
