#include <avr/io.h>
#include <avr/interrupt.h>
#include "LEDs.h"

//this code ASSUMES the cpu clock is between 19.2MHz and 24MHz  (19.2 gives perfect timing to spec, 24 has been shown to mostly work)
//this code assumes we're using USART0

#define OUT_PORT	PORTD
#define OUT_DDR		DDRD
#define OUT_PIN_NR	1

static uint8_t gData[NUM_RGBS * 3] = {0,};

void rgbInit(void)
{
	OUT_PORT &=~ (1 << OUT_PIN_NR);	//pin is output and low
	OUT_DDR  |= 1 << OUT_PIN_NR;
}

void rgbSet(uint16_t idx, uint8_t R, uint8_t G, uint8_t B)
{
	uint8_t *ptr = gData;
	ptr += idx * 3;
	
	*ptr++ = G;
	*ptr++ = R;
	*ptr++ = B;
}

void rgbGet(uint16_t idx, uint8_t *RP, uint8_t *GP, uint8_t *BP)
{
	uint8_t *ptr = gData;
	ptr += idx * 3;
	
	*GP = *ptr++;
	*RP = *ptr++;
	*BP = *ptr++;
}



#define UP	"	sbi  0x0B, 1"
#define DOWN	"	cbi  0x0B, 1"
#define NOP2	"	rjmp 3f\n\t3:\n\t"

//assumes pin D1, appropriate clock speed
void __attribute__((naked, noinline)) rgbSyncGuts(uint8_t *data, uint16_t num_bytes)
{
	//XXX: TODO: the sync pulse at end is a huge delay..we should use a timer and let cpu do stuff in that time...
	
	//data in r25:r24, num_bytes in r23:r22
	//send: GBR, MSB first, 1.25us/bit, 0 -> 100, 1-> 110 pattern
	asm volatile (
			"	movw  r30, r24	\n\t"	//Z = data
			"	movw  r26, r22	\n\t"	//X = num_bytes
			"byte_loop:		\n\t"
			"	ld    r24, Z+	\n\t"
			"	ldi   r25, 8	\n\t"
			"bit_loop:		\n\t"
			"	"UP"		\n\t"
			"	"NOP2"		\n\t"
			"	"NOP2"		\n\t"
			"	lsl   r24	\n\t"
			"	brcs  bit_send_1\n\t"
			"	"DOWN"		\n\t"
			"	rjmp  bit_sent	\n\t"
			"bit_send_1:		\n\t"
			"	"NOP2"		\n\t"
			"	nop		\n\t"
			"bit_sent:		\n\t"
			"	"NOP2"		\n\t"
			"	"NOP2"		\n\t"
			"	"DOWN"		\n\t"
			"	dec   r25	\n\t"
			"	brne  more_bits	\n\t"
			"	sbiw  r26, 1	\n\t"
			"	brne  byte_loop	\n\t"
			"	rjmp  all_done	\n\t"
			"more_bits:		\n\t"
			"	nop		\n\t"
			"	rjmp  bit_loop	\n\t"
			"all_done:		\n\t"
			"	"NOP2"		\n\t"
			"	"NOP2"		\n\t"
			"	"UP"		\n\t"
			"	rcall del_7cy	\n\t"
			"	rcall del_7cy	\n\t"
			"	"DOWN"		\n\t"
			"			\n\t"
			"del_7cy:		\n\t"
			"	ret		\n\t"
			//do we need this ...?
	);
}

void rgbSync_nowait(void)
{
	rgbSyncGuts(gData, NUM_RGBS * 3);
}

void rgbSync(void)
{
	rgbSyncGuts(gData, NUM_RGBS * 3);
	
	asm volatile(
			"sync_loop:		\n\t"
			"	nop		\n\t"
			"	dec r1		\n\t"
			"	brne sync_loop	\n\t"
			"	"UP"		\n\t"
			"	rcall del_7cy	\n\t"
			"	rcall del_7cy	\n\t"
			"	"DOWN"		\n\t"
	);
}



