/*    brack1.c, the center part of the famous LCARS brackets
   The message boxes should be in your main program so they
   can change as required. Cut and paste them from the
   clock/calendar program and change the labels. Specify
   standard LCARS colors (ORANGE, LILAC, PALEBLUE, BRICK,
   NAPLES, SKYBLUE, MANGO, PURPLE, BIGBLUE).
   Usage example: Brackets1(ORANGE, PALEBLUE);
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "brack1.h"


void UpperElbow(int Hue)
{
	ellipsefill(screen,46,2+uy-15,36,25,Hue);  /* 37 */
	rectfill(screen,10,126,110,2+uy-12,Hue);
	rectfill(screen,49,uy-24,110,2+uy,Hue);
	rectfill(screen,47,uy,28+(291*m),2+uy+9,Hue);
	bc=BLACK;
	FadeOut(Hue);

	SouthwestCorner(111,uy-1); /* build a smooth inner corner */
/* sand, polish, and wax the outer curve */
uy+=2;
	hline(screen,	 41,	 uy+9, 42, ac1);
	hline(screen,	 39,	 uy+9, 40, ac2);
	hline(screen,	 37,	 uy+9, 38, ac3);
	hline(screen,	 35,	 uy+9, 36, ac4);
	putpixel(screen, 35,	 uy+8, ac1);
	putpixel(screen, 34,	 uy+8, ac2);
	putpixel(screen, 33,	 uy+8, ac3);
	putpixel(screen, 32,	 uy+8, ac4);
	putpixel(screen, 31,	 uy+7, ac2);
	putpixel(screen, 30,	 uy+7, ac2);
	putpixel(screen, 29,	 uy+7, ac4);
	putpixel(screen, 27,	 uy+6, ac3);
	putpixel(screen, 25,	 uy+5, ac3);
	putpixel(screen, 23,	 uy+4, ac3);
	putpixel(screen, 20,	 uy+2, ac3);
	putpixel(screen, 21,	 uy+3, ac3);
	putpixel(screen, 16,	 uy-1, bc);
	putpixel(screen, 15,	 uy-2, bc);
	putpixel(screen, 14,	 uy-3, bc);
	putpixel(screen, 13,	 uy-5, ac2);
	putpixel(screen, 11,	 uy-8, ac3);
	putpixel(screen, 12,	 uy-6, ac3);
	putpixel(screen, 10,	 uy-13, ac1);
	putpixel(screen, 10,	 uy-12, ac2);
	putpixel(screen, 10,	 uy-11, ac3);
	putpixel(screen, 10,	 uy-10, ac4);
	uy-=2;
}
void LowerElbow(int Hue)
{
	int boxtop;
	boxtop=590 - (54*5) - 16;

	ellipsefill(screen,46,ly+19+5,36,25,Hue);
	rectfill(screen,10,ly+20,110,boxtop,Hue);
	rectfill(screen,49,ly+8,110,ly+20,Hue);
	rectfill(screen,47,ly,28+(291*m),ly+11,Hue);
	bc=BLACK;
	FadeOut(Hue);
	NorthwestCorner(111,ly+12);
/* sand, polish, and wax the outer curve */
	hline(screen,	 39,	 ly, 41, ac2);
	putpixel(screen, 38,	 ly, ac3);
	putpixel(screen, 37,	 ly, ac4);
	putpixel(screen, 36,	 ly, ac4);
	putpixel(screen, 34,	 ly+1, ac2);
	putpixel(screen, 33,	 ly+1, ac3);
	putpixel(screen, 32,	 ly+1, ac4);
	putpixel(screen, 31,	 ly+2, ac2);
	putpixel(screen, 30,	 ly+2, ac2);
	putpixel(screen, 29,	 ly+2, ac4);
	putpixel(screen, 27,	 ly+3, ac3);
	putpixel(screen, 25,	 ly+4, ac3);
	putpixel(screen, 23,	 ly+5, ac3);
	putpixel(screen, 21,	 ly+6, ac3);	 /*****/
	putpixel(screen, 20,	 ly+7, ac3);
	putpixel(screen, 15,	 ly+11, BLACK);
	putpixel(screen, 14,	 ly+13, ac3);
	putpixel(screen, 13,	 ly+14, ac2);
	putpixel(screen, 11,	 ly+17, ac3);
	putpixel(screen, 12,	 ly+15, ac3);
	putpixel(screen, 10,	 ly+22, ac2);
	putpixel(screen, 10,	 ly+21, ac2);
	putpixel(screen, 10,	 ly+20, ac3);
	putpixel(screen, 10,	 ly+19, ac4);
}
void UpperExtension1(int Hue)
{
	rectfill(screen,28+(294*m),uy-4,28+(306*m),uy+11,Hue);
}
void UpperExtension2(int Hue)
{
	rectfill(screen,28+(309*m),uy,504,uy+11,Hue);
}
void UpperExtension3(int Hue)
{
	rectfill(screen,508,uy,761,uy+11,Hue);
}
void UpperExtension4(int Hue)
{
	rectfill(screen,765,uy,790,uy+11,Hue);
}
void LowerExtension1(int Hue)
{
	rectfill(screen,28+(294*m),ly,28+(306*m),ly+11+4,Hue);
}
void LowerExtension2(int Hue)
{
	rectfill(screen,28+(309*m),ly,504,ly+6,Hue);
}
void LowerExtension3(int Hue)
{
	rectfill(screen,508,ly,761,ly+11,Hue);
}
void LowerExtension4(int Hue)
{
	rectfill(screen,765,ly,790,ly+11,Hue);
}

void Brackets1(int UpperColor, int LowerColor)
{
	UpperElbow(UpperColor);
	UpperExtension1(NAPLES);
	UpperExtension2(LowerColor);
	UpperExtension3(UpperColor);
	UpperExtension4(LowerColor);
	LowerElbow(LowerColor);
/* Clean up Allegro slop between the two elbows */
	rectfill(screen,10,2+uy+10,110,ly-1,BLACK);
	LowerExtension1(NAPLES);
	LowerExtension2(LILAC);
	LowerExtension3(LowerColor);
	LowerExtension4(LILAC);
}
void TelescopeBracket(int amount)
{
	BITMAP *bmp;
	int p;

	bmp=create_bitmap(112,40);
	clear_bitmap(bmp);
	blit(screen,bmp,388,194,0,0,112,40); /* to bmp */

	for(p=1; p < amount; p++) {
/*		vsync(); */
		blit(bmp,screen,0,0,388-p,194,112,40); /* to screen */
	}
	destroy_bitmap(bmp);
}

void Br1Box(int boxtop, int Color, char *Str1, char *Str2)
{
	rectfill(screen,10,boxtop,110,boxtop+53,Color);
	rectfill(screen,10,boxtop-3,110,boxtop-1,BLACK);
	rectfill(screen,10,boxtop+54,110,boxtop+56,BLACK);
	PutsLuna(14,boxtop+4,BLACK,Color,Str1);
	PutsLuna(107-StrLenLuna(Str2),boxtop+4,BLACK,Color, Str2);
}
void Br1F1Box(int Color, char *Str1, char *Str2)
{
	Br1Box(536,Color,Str1,Str2);
}
void Br1F2Box(int Color, char *Str1, char *Str2)
{
	Br1Box(479,Color,Str1,Str2);
}
void Br1F3Box(int Color, char *Str1, char *Str2)
{
	Br1Box(422,Color,Str1,Str2);
}
void Br1F4Box(int Color, char *Str1, char *Str2)
{
	Br1Box(365,Color,Str1,Str2);
}
void Br1F5Box(int Color, char *Str1, char *Str2)
{
	Br1Box(308,Color,Str1,Str2);
}
void UpperElbowLabel(int Color, char *Str1, char *Str2)
{
	PutsLuna(14,130,BLACK,Color, Str1);
	PutsLuna(107-StrLenLuna(Str2),130,BLACK,Color,Str2);
}
void LowerElbowLabel(int Color, char *Str1, char *Str2)
{
	PutsLuna(14,287,BLACK,Color, Str1);
	PutsLuna(107-StrLenLuna(Str2),287,BLACK,Color,Str2);
}


/* eof */


