/* Phone, the LCARS 24 instant-access phonebook program */
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "text24.h"

void PbBrackets()
{
	NortheastElbow(MaxX-12-125,13,LILAC);
	rectfill(screen,12,13,MaxX-12-126,27+12,LILAC);
	SoutheastElbow(MaxX-12-125,MaxY-12,LILAC);
	rectfill(screen,12, MaxY-26-12, MaxX-12-126, MaxY-12, LILAC);
	min_old=70;
	T24PutTime();
	strcpy(ProgramTitle,"PHONEBOOK");
	Title(ProgramTitle);
}
void PbDisplayFilename()
{
	rectfill(screen,169,1+12,600,27+12,LILAC);
	PutsLuna(169,20,BLACK,LILAC,MakeDisplayName(CurrentFile));
}
void PbDoSave()
{
	T24Box(NAPLES, 1, "SAVING", "");
	SaveTextFile();
	Action=0;
	T24Box(PURPLE, 1, "FILE (S)","F1");
}
void PbMessageBoxes()
{	 /* position range: 1 to 10 */
	T24ClearUpperMessageBoxes();
	T24Box(PURPLE, 1, "SAVE (S)","F1");
	T24Box(BRICK, 2, "FIND (F)","F2");
	T24Box(BRICK, 3, "FIND & R (H)","F3");
	T24Box(BRICK, 4, "NEXT (L)","F4");
	T24Box(LAVENDER, 5, "WORLD TIME","F5");
	T24Box(BIGBLUE, 6, "COLOR (T)","F6");
}
void PbLowerMessageBoxes()
{
	T24Box(LAVENDER, 10, "MATH","F10");
	T24Box(ORANGE, 11, "HELP","F11");
	T24Box(ORANGE, 12, "CLOSE","F12");
}
void PbScreen1()
{
	rectfill(screen,0,0,MaxX,MaxY,BLACK);
	PbBrackets();
	PbMessageBoxes();
	PbLowerMessageBoxes();
	PutsLuna(160,567,BLACK,LILAC, "SELECT: SHIFT + ARROW KEYS	SELECT ALL: (A)	CUT: (X)	COPY: (C)	PASTE: (V) (CTRL+)");
}
void PbDoFind()
{
	if(EndText >1) T24Find();
	if(NoFind==FALSE) MarkWord=1;
	rectfill(screen,12,13,MaxX-12-126,27+12,LILAC);
	Title(ProgramTitle);
	PbDisplayFilename();
}
void PbDoFindAndReplace()
{
	if(EndText >1) T24FindAndReplace();
	rectfill(screen,12,13,MaxX-12-126,27+12,LILAC);
	Title(ProgramTitle);
	PbDisplayFilename();
}
void PbDoNext()
{
	if(NoFind==FALSE) {
		WordRight();
		T24NextFind();
	}
	if(NoFind==FALSE) MarkWord=1;
	if(FindMode==2) MarkWord=0;
	Title(ProgramTitle);
	PbDisplayFilename();
}
void PbDoHelp()
{
	char HelpPath[80];

	strcpy(HelpPath, LcarsPath);
	strcat(HelpPath,"\\LC24APPS\\PHONE\\PBHELP.TXT");
	OpenHelp(HelpPath);
	min_old=70;
}
void PbDoMath()
{  /* saves the screen then restores it after Math module closes */
	BITMAP *bmp = create_bitmap(800,600);

	clear_bitmap(bmp);
	blit(screen, bmp, 0, 0, 0, 0, 800, 600);
	MathMode();
	blit(bmp, screen, 0, 0, 0, 0, 800, 600);
	destroy_bitmap(bmp);
}
void PbDoWorldTime()
{  /* saves the screen then restores it after World Time closes */
	BITMAP *bmp = create_bitmap(800,600);

	clear_bitmap(bmp);
	blit(screen, bmp, 0, 0, 0, 0, 800, 600);
	TimeZoneMode();
	blit(bmp, screen, 0, 0, 0, 0, 800, 600);
	destroy_bitmap(bmp);
}
void PbEdit()
{
/*
	char bx[4];
	char by[4];
	char ex[4];
	char ey[4];
*/

	x=1;
	y=0;
	T24PutTime();
	T24DrawCursor();

loopback:
	T24Infoxy();
	T24DrawCursor();
	do {
		T24PutTime();
	} while(!keypressed());
	c=GetKey();
	T24DrawCursor();
	switch( c )
	{
		case 1:			SelectAll();
					goto loopback;
		case 3:			T24DoCopy();
					goto loopback;
		case 4:			HighlightWord();
					goto loopback;
		case F2:
		case 6:			PbDoFind();
					goto loopback;
		case 8:			if(ControlKeyStatus() != 0) PbDoFindAndReplace();
					Action=1;
					goto loopback;
		case BS:		Backspace();
					Action=1;
					goto loopback;
		case 9:			Tab();
					Action=1;
					goto loopback;
		case F4:
		case 12:		PbDoNext();
					Action=1;
					goto loopback;
		case 13:		Xreturn();
					Action=1;
					goto loopback;
		case F1:
		case 19:		PbDoSave();
					goto loopback;
		case F6:
		case 20:		T24DoTextColor();
					goto loopback;
		case 21:		CtrlU();
					goto loopback;
		case 22:		T24DoPaste();
					goto loopback;
		case 24:		T24DoCut();
					goto loopback;
		case 25: 		CtrlY();
					Action=1;
					goto loopback;
		case LEFTARROW: 	CursorLeft();
					goto loopback;
		case SHFT_LEFTARROW: 	SelectLeft();
					goto loopback;
		case RIGHTARROW: 	CursorRight();
					goto loopback;
		case SHFT_RIGHTARROW:	SelectRight();
					goto loopback;
		case CTRL_UPARROW:
		case UPARROW:		CursorUp();
					goto loopback;
		case SHFT_UPARROW:	SelectUp();
					goto loopback;
		case CTRL_DOWNARROW:
		case DOWNARROW:		CursorDown();
					goto loopback;
		case SHFT_DOWNARROW:	SelectDown();
					goto loopback;
		case DELKEY:		DelKey();
					Action=1;
					goto loopback;
		case PGUPKEY:		PageUp();
					goto loopback;
		case PGDNKEY:		PageDown();
					goto loopback;
		case HOMEKEY:		CursorBOL();
					goto loopback;
		case ENDKEY:		CursorEOL();
					goto loopback;
		case CTRL_LEFTARROW:	WordLeft();
					goto loopback;
		case CTRL_RIGHTARROW:	WordRight();
					goto loopback;
		case SHFT_CTRL_RIGHTARROW: SelectWordRight();
					goto loopback;

		case CTRL_HOMEKEY:	TopOfFile();
					goto loopback;
		case CTRL_ENDKEY:	BottomOfFile();
					goto loopback;
		case F3: 		T24DoFindAndReplace();
					goto loopback;
		case F5:		PbDoWorldTime();
					goto loopback;
		case F10:		PbDoMath();
					goto loopback;
		case F11:		PbDoHelp();
					PanelBeep();
					goto loopback;
		case F12:		if(Action!=0) {
						Result=T24Safety();
						if(Result==1) return;
						if(Result==2) {
							PbMessageBoxes();
							PbLowerMessageBoxes();
							goto loopback;
						}
						if(Result==3) {
							SaveTextFile();
							return;
						}
					} else {
						return;
					}
		case CTRL_F1:	Screenshot792("Phone8.bmp");
				goto loopback;
		case CTRL_F2:	Screenshot1024("Phone10.bmp");
				goto loopback;
		default:	if( c > 31 && c < 126) {
					T24PutOneChar();
					Action=1;
				}
				goto loopback;
	}
}
int PhoneBookMode()
{
	int Result;

	rectfill(screen,0,0,0,0,BLACK);
	T24Init();
	PbScreen1();
	T24buf=create_bitmap(650,504);
	T24linebuf=create_bitmap(650,lp);
	SetCurrentFile("\\PHONE\\PHONE.TXT");
	AutoCorrectOff=TRUE;
	T24ClearWindow();
	PbDisplayFilename();
	if(LoadTextFile() !=0) goto abort; /* bail out after error screen */
	T24RefreshAll();
	T24DrawCursor();
	PanelBeep();
	PbEdit();
abort:
	destroy_bitmap(T24buf);
	destroy_bitmap(T24linebuf);
	return(Result);
}

