/* 	Mars28.c, 8 x 28 scalable LCARS font, caps and a few punctuation marks
	Use sizes 2 to 10 and predefined LCARS colors only.
	Double-buffered output is automatic, with black background
	(smooth change, no need to erase, numerics of equal width)
	Usage:
	void MarsF(int x,int y,int Size,int ForeColor,int BackColor,char *cStr)
	int StrLenMars(int s,char *cStr)
*/

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "mars28.h"

void MarsFadeUp(int x, int y, int Hue, int range)
{
	int r,b,g,dr,dg,db,z,limit;

	r=getr(Hue);
	g=getg(Hue);
	b=getb(Hue);
	dr = r;
	dg = g;
	db = b;

	limit = range;
	range += range * .125;		/* slows fade to produce nice slants */
	for( z=1; z <= limit; ++z ) {
		dr -= r/range;
		dg -= g/range;
		db -= b/range;
		putpixel(marsbmp,x,y+1-z,makecol(dr,dg,db));
	}
}
void MarsFadeDown(int x, int y, int Hue, int range)
{
	int r,b,g,dr,dg,db,z,limit;

	r=getr(Hue);
	g=getg(Hue);
	b=getb(Hue);
	dr = r;
	dg = g;
	db = b;

	limit = range;
	range += range * .125;		/* slows fade to produce nice slants */
	for( z=1; z <= limit; ++z ) {
		dr -= r/range;
		dg -= g/range;
		db -= b/range;
		putpixel(marsbmp,x,y-1+z,makecol(dr,dg,db));
	}
}


int UphillHinting(int slant,int x,int y,float th)
{
/* Slant values passed to this and the following three functions
can be 14, 7, 4, or 2 to make perfect figures, crisp at both ends,
since the characters are size x 28 in height.  In fact, compensation
for values is not evenly divisible into 28 has been removed. */

	int a=x;
	int b;
	int quarter, half;

	quarter = slant * .25;
	half = slant * .5;
	b=y+(s*28);

	while(b > y ) {
		MarsFadeUp(a, b, fc, slant+1);
		++a;
		b=b-slant;
		MarsFadeDown(a+(s*th)+1, b, fc, slant+1);
	}
	return(a);
}
int DownhillHinting(int slant,int x,int y,float th)
{
	int a,b,quarter,half;

	quarter = slant * .25;
	half = slant * .5;

	a=x-1;
	b=y+slant;

	while(b <= y+(s*28) ) {
		MarsFadeDown(a, b-slant, fc, slant+1);
		++a;
		MarsFadeUp(a+(s*th)+1, b, fc, slant+1);
		b=b+slant;
	}
	--a;
	--a;
	return(a);
}
int Uphill(int slant,int x,int y,float th)
{
	int a=x;
	int b;

	a=x;
	b=y+(s*28);
	while(b >= y+slant) {
		++a;
		b=b-slant;
		rectfill(marsbmp, a,b,a+(s*th),b+slant,fc);
	}
	return(a);
}
int Downhill(int slant,int x,int y,float th)
{
	int a=x;
	int b=y;

	while(b <= y+(s*28)-slant ) {
		rectfill(marsbmp, a,b,a+(s*th),b+slant,fc);
		++a;
		b=b+slant;
	}
	return(a);
}
void WfSoftCap(int x, int y)
{ /* some antialiasing for round tops */

	CropCircle(marsbmp,0,x+(s*4),y+(s*4),(s*4)+1);
	if(s==2) {
		putpixel(marsbmp,x+6,y,ac2);
		putpixel(marsbmp,x+5,y,ac3);
		putpixel(marsbmp,x+3,y+1,ac4);
		putpixel(marsbmp,x+2,y+2,ac4);
		putpixel(marsbmp,x+1,y+3,ac4);
		putpixel(marsbmp,x,y+5,ac3);
		putpixel(marsbmp,x,y+6,ac2);

		putpixel(marsbmp,x+10,y,ac2);
		putpixel(marsbmp,x+11,y,ac3);
		putpixel(marsbmp,x+13,y+1,ac4);
		putpixel(marsbmp,x+14,y+2,ac4);
		putpixel(marsbmp,x+15,y+3,ac4);
		putpixel(marsbmp,x+16,y+5,ac3);
		putpixel(marsbmp,x+16,y+6,ac2);
	}
	if(s==4) {
		putpixel(marsbmp,x+4,y+4,bc);
		putpixel(marsbmp,x+28,y+4,bc);
	}
	if(s==6) {
		putpixel(marsbmp,x+16,y,bc);
		putpixel(marsbmp,x+32,y,bc);
		putpixel(marsbmp,x+19,y,ac3);
		putpixel(marsbmp,x+29,y,ac3);
		putpixel(marsbmp,x+20,y,ac2);
		putpixel(marsbmp,x+21,y,ac2);
		putpixel(marsbmp,x+27,y,ac2);
		putpixel(marsbmp,x+28,y,ac2);

		putpixel(marsbmp,x,y+16,bc);
		putpixel(marsbmp,x,y+19,ac3);
		putpixel(marsbmp,x,y+20,ac2);
		putpixel(marsbmp,x,y+21,ac2);
		putpixel(marsbmp,x,y+22,ac1);

		putpixel(marsbmp,x+48,y+16,bc);
		putpixel(marsbmp,x+48,y+19,ac3);
		putpixel(marsbmp,x+48,y+20,ac2);
		putpixel(marsbmp,x+48,y+21,ac2);
		putpixel(marsbmp,x+48,y+22,ac1);
	}
	if(s==10) {
		hline(marsbmp,x+36,y,x+44,fc);
		putpixel(marsbmp,x+30,y,bc);
		putpixel(marsbmp,x+50,y,bc);
		putpixel(marsbmp,x+34,y,ac2);
		putpixel(marsbmp,x+46,y,ac2);

		putpixel(marsbmp,x,y+30,bc);
		putpixel(marsbmp,x,y+33,ac2);
		putpixel(marsbmp,x,y+34,ac2);
		putpixel(marsbmp,x,y+35,ac1);

		putpixel(marsbmp,x+80,y+30,bc);
		putpixel(marsbmp,x+80,y+33,ac2);
		putpixel(marsbmp,x+80,y+34,ac2);
		putpixel(marsbmp,x+80,y+35,ac1);
	}
}
void WfSoftFoot(int x, int y)
{
	CropCircle(marsbmp,0,x+(s*4),y+(s*24),(s*4)+1);
	if(s==2) {
		putpixel(marsbmp,x+6,y+56,ac2);
		putpixel(marsbmp,x+5,y+56,ac3);
		putpixel(marsbmp,x+3,y+55,ac4);
		putpixel(marsbmp,x+2,y+54,ac4);
		putpixel(marsbmp,x+1,y+53,ac4);
		putpixel(marsbmp,x,y+51,ac3);
		putpixel(marsbmp,x,y+50,ac2);

		putpixel(marsbmp,x+10,y+56,ac2);
		putpixel(marsbmp,x+11,y+56,ac3);
		putpixel(marsbmp,x+13,y+55,ac4);
		putpixel(marsbmp,x+14,y+54,ac4);
		putpixel(marsbmp,x+15,y+53,ac4);
		putpixel(marsbmp,x+16,y+51,ac3);
		putpixel(marsbmp,x+16,y+50,ac2);
	}
	if(s==4) {
		putpixel(marsbmp,x+4,y+108,bc);
		putpixel(marsbmp,x+28,y+108,bc);
	}
	if(s==6) {
		putpixel(marsbmp,x+16,y+168,bc);
		putpixel(marsbmp,x+32,y+168,bc);
		putpixel(marsbmp,x+19,y+168,ac3);
		putpixel(marsbmp,x+29,y+168,ac3);
		putpixel(marsbmp,x+20,y+168,ac2);
		putpixel(marsbmp,x+21,y+168,ac2);
		putpixel(marsbmp,x+27,y+168,ac2);
		putpixel(marsbmp,x+28,y+168,ac2);

		putpixel(marsbmp,x,y+152,bc);
		putpixel(marsbmp,x,y+151,ac4);
		putpixel(marsbmp,x,y+149,ac3);
		putpixel(marsbmp,x,y+148,ac2);
		putpixel(marsbmp,x,y+147,ac2);
		putpixel(marsbmp,x,y+146,ac1);

		putpixel(marsbmp,x+48,y+152,bc);
		putpixel(marsbmp,x+48,y+149,ac3);
		putpixel(marsbmp,x+48,y+148,ac2);
		putpixel(marsbmp,x+48,y+147,ac2);
		putpixel(marsbmp,x+48,y+146,ac1);
	}
	if(s==10) {
		hline(marsbmp,x+36,y+280,x+44,fc);
		putpixel(marsbmp,x+30,y+280,bc);
		putpixel(marsbmp,x+50,y+280,bc);
		putpixel(marsbmp,x+34,y+280,ac2);
		putpixel(marsbmp,x+46,y+280,ac2);

		putpixel(marsbmp,x,y+250,bc);
		putpixel(marsbmp,x,y+249,ac4);
		putpixel(marsbmp,x,y+247,ac2);
		putpixel(marsbmp,x,y+246,ac2);
		putpixel(marsbmp,x,y+245,ac1);

		putpixel(marsbmp,x+80,y+250,bc);
		putpixel(marsbmp,x+80,y+247,ac2);
		putpixel(marsbmp,x+80,y+246,ac2);
		putpixel(marsbmp,x+80,y+245,ac1);
	}
}
void Smooth1(int x, int y)
{
	if(s==10) {
		putpixel(marsbmp,x+29,y+0,ac4);
		putpixel(marsbmp,x+29,y+1,ac4);
		putpixel(marsbmp,x+29,y+2,ac3);
		putpixel(marsbmp,x+29,y+3,ac3);
		putpixel(marsbmp,x+29,y+4,ac2);
		putpixel(marsbmp,x+29,y+5,ac2);
		putpixel(marsbmp,x+28,y+7,ac4);
		putpixel(marsbmp,x+28,y+8,ac3);
		putpixel(marsbmp,x+28,y+9,ac2);
		putpixel(marsbmp,x+27,y+11,ac3);
		putpixel(marsbmp,x+27,y+12,ac2);
		putpixel(marsbmp,x+26,y+13,ac4);
		putpixel(marsbmp,x+26,y+14,ac2);
		putpixel(marsbmp,x+25,y+15,ac4);
		putpixel(marsbmp,x+25,y+16,ac2);
		putpixel(marsbmp,x+24,y+17,ac4);

		putpixel(marsbmp,x+23,y+19,ac2);
		putpixel(marsbmp,x+22,y+20,ac2);
		putpixel(marsbmp,x+21,y+21,ac2);
		putpixel(marsbmp,x+20,y+22,ac2);
		putpixel(marsbmp,x+19,y+23,ac2);

		putpixel(marsbmp,x+17,y+24,ac4);
		putpixel(marsbmp,x+16,y+25,ac2);
		putpixel(marsbmp,x+15,y+25,ac4);
		putpixel(marsbmp,x+14,y+26,ac2);
		putpixel(marsbmp,x+13,y+26,ac4);
		putpixel(marsbmp,x+12,y+27,ac2);
		putpixel(marsbmp,x+11,y+27,ac3);

		putpixel(marsbmp,x+9,y+28,ac2);
		putpixel(marsbmp,x+8,y+28,ac3);
		putpixel(marsbmp,x+7,y+28,ac4);
		putpixel(marsbmp,x+5,y+29,ac2);
		putpixel(marsbmp,x+4,y+29,ac2);
		putpixel(marsbmp,x+3,y+29,ac3);
		putpixel(marsbmp,x+2,y+29,ac3);
		putpixel(marsbmp,x+1,y+29,ac4);
		putpixel(marsbmp,x,y+29,ac4);
	}
	if(s==6) {
		putpixel(marsbmp,x+17,y+0,ac4);
		putpixel(marsbmp,x+17,y+1,ac4);
		putpixel(marsbmp,x+17,y+2,ac3);
		putpixel(marsbmp,x+17,y+3,ac3);
		putpixel(marsbmp,x+17,y+4,ac2);
		putpixel(marsbmp,x+16,y+6,ac4);
		putpixel(marsbmp,x+16,y+7,ac2);
		putpixel(marsbmp,x+15,y+9,ac3);
		putpixel(marsbmp,x+14,y+11,ac2);
		putpixel(marsbmp,x+13,y+12,ac2);
		putpixel(marsbmp,x+12,y+13,ac2);
		putpixel(marsbmp,x+11,y+14,ac2);
		putpixel(marsbmp,x+9,y+15,ac2);
		putpixel(marsbmp,x+8,y+15,ac4);
		putpixel(marsbmp,x+7,y+16,ac2);
		putpixel(marsbmp,x+6,y+16,ac3);
		putpixel(marsbmp,x+4,y+17,ac2);
		putpixel(marsbmp,x+3,y+17,ac3);
		putpixel(marsbmp,x+2,y+17,ac3);
		putpixel(marsbmp,x+1,y+17,ac4);
		putpixel(marsbmp,x,y+17,ac4);
	}
	if(s==4) {
		putpixel(marsbmp,x+11,y+0,ac4);
		putpixel(marsbmp,x+11,y+1,ac4);
		putpixel(marsbmp,x+11,y+2,ac3);
		putpixel(marsbmp,x+11,y+3,ac2);
		putpixel(marsbmp,x+11,y+4,ac1);
		putpixel(marsbmp,x+10,y+5,ac3);
		putpixel(marsbmp,x+10,y+6,ac2);
		putpixel(marsbmp,x+9,y+7,ac4);
		putpixel(marsbmp,x+8,y+8,ac4);
		putpixel(marsbmp,x+7,y+9,ac4);
		putpixel(marsbmp,x+6,y+10,ac2);
		putpixel(marsbmp,x+5,y+10,ac3);
		putpixel(marsbmp,x+4,y+11,ac1);
		putpixel(marsbmp,x+3,y+11,ac2);
		putpixel(marsbmp,x+2,y+11,ac3);
		putpixel(marsbmp,x+1,y+11,ac4);
		putpixel(marsbmp,x+0,y+11,ac4);
	}
	if(s==3) {
		putpixel(marsbmp,x+8,y+0,ac4);
		putpixel(marsbmp,x+8,y+1,ac3);
		putpixel(marsbmp,x+8,y+2,ac2);
		putpixel(marsbmp,x+7,y+4,ac4);
		putpixel(marsbmp,x+7,y+5,ac2);
		putpixel(marsbmp,x+6,y+6,ac4);
		putpixel(marsbmp,x+5,y+7,ac2);
		putpixel(marsbmp,x+4,y+7,ac4);
		putpixel(marsbmp,x+2,y+8,ac2);
		putpixel(marsbmp,x+1,y+8,ac3);
		putpixel(marsbmp,x+0,y+8,ac4);
	}
	if(s==2) {
		putpixel(marsbmp,x+5,y+0,ac4);
		putpixel(marsbmp,x+5,y+1,ac3);
		putpixel(marsbmp,x+5,y+2,ac2);
		putpixel(marsbmp,x+4,y+3,ac4);
		putpixel(marsbmp,x+4,y+4,ac1);
		putpixel(marsbmp,x+3,y+4,ac4);
		putpixel(marsbmp,x+2,y+5,ac2);
		putpixel(marsbmp,x+1,y+5,ac3);
		putpixel(marsbmp,x+0,y+5,ac4);
	}
}
void Smooth2(int x, int y)
{
	if(s==2) {
		putpixel(marsbmp,x+9,y+20,ac4);
		putpixel(marsbmp,x+9,y+21,ac3);
		putpixel(marsbmp,x+8,y+23,ac3);
		putpixel(marsbmp,x+7,y+25,ac3);
		putpixel(marsbmp,x+7,y+26,ac2);
		putpixel(marsbmp,x+6,y+26,ac4);
		putpixel(marsbmp,x+6,y+27,ac3);
		putpixel(marsbmp,x+5,y+28,ac4);
		putpixel(marsbmp,x+5,y+29,ac4);
		putpixel(marsbmp,x+5,y+30,ac2);
		putpixel(marsbmp,x+4,y+30,ac4);
		putpixel(marsbmp,x+4,y+31,ac4);
		putpixel(marsbmp,x+4,y+32,ac3);
		putpixel(marsbmp,x+3,y+33,ac4);
		putpixel(marsbmp,x+3,y+34,ac3);
		putpixel(marsbmp,x+2,y+36,ac3);
		putpixel(marsbmp,x+1,y+38,ac4);
		putpixel(marsbmp,x+1,y+39,ac3);
		putpixel(marsbmp,x,y+41,ac4);
		putpixel(marsbmp,x,y+42,ac3);
		putpixel(marsbmp,x,y+43,ac2);
		putpixel(marsbmp,x,y+44,ac1);
		vline(marsbmp,x+16,y+12,y+15,fc);
		MarsFadeDown(x+16,y+16,fc,4);
		putpixel(marsbmp,x+15,y+21,ac2);
		putpixel(marsbmp,x+15,y+22,ac3);
		putpixel(marsbmp,x+14,y+24,ac3);
		putpixel(marsbmp,x+13,y+26,ac2);
		putpixel(marsbmp,x+13,y+27,ac3);
		putpixel(marsbmp,x+12,y+29,ac3);
		putpixel(marsbmp,x+11,y+31,ac3);
		putpixel(marsbmp,x+10,y+33,ac3);
		putpixel(marsbmp,x+9,y+35,ac3);
		putpixel(marsbmp,x+8,y+38,ac3);
		putpixel(marsbmp,x+7,y+40,ac1);
		putpixel(marsbmp,x+7,y+41,ac2);
		putpixel(marsbmp,x+7,y+42,ac3);
		putpixel(marsbmp,x+7,y+43,ac4);
		MarsFadeDown(x+6,y+44,fc,10);
		return;
	}
	if(s==3) {
/* left side */
		MarsFadeUp(x+15,y+27,fc,4);
		putpixel(marsbmp,x+14,y+29,ac4);
		putpixel(marsbmp,x+13,y+31,ac4);
		putpixel(marsbmp,x+13,y+32,ac3);
		putpixel(marsbmp,x+12,y+33,ac4);
		putpixel(marsbmp,x+12,y+34,ac3);
		putpixel(marsbmp,x+11,y+36,ac3);
		putpixel(marsbmp,x+10,y+38,ac3);
		putpixel(marsbmp,x+10,y+39,ac2);
		putpixel(marsbmp,x+9,y+40,ac4);
		putpixel(marsbmp,x+9,y+41,ac3);
		putpixel(marsbmp,x+8,y+43,ac3);
		putpixel(marsbmp,x+7,y+45,ac4);
		putpixel(marsbmp,x+7,y+46,ac3);
		putpixel(marsbmp,x+6,y+48,ac3);
		putpixel(marsbmp,x+5,y+50,ac3);
		putpixel(marsbmp,x+4,y+52,ac4);
		putpixel(marsbmp,x+4,y+53,ac3);
		putpixel(marsbmp,x+3,y+55,ac3);
		MarsFadeUp(x+2,y+59,fc,3);
		MarsFadeUp(x+1,y+62,fc,2);
		MarsFadeUp(x,y+70,fc,7);

/* right side */
		MarsFadeDown(x+24,y+22,fc,8);
		putpixel(marsbmp,x+23,y+31,ac3);
		putpixel(marsbmp,x+23,y+32,ac4);
		putpixel(marsbmp,x+22,y+33,ac2);
		putpixel(marsbmp,x+22,y+34,ac4);
		putpixel(marsbmp,x+21,y+36,ac2);
		putpixel(marsbmp,x+20,y+38,ac3);
		putpixel(marsbmp,x+20,y+39,ac4);
		putpixel(marsbmp,x+19,y+40,ac2);
		putpixel(marsbmp,x+19,y+41,ac3);
		putpixel(marsbmp,x+18,y+43,ac3);
		putpixel(marsbmp,x+17,y+45,ac2);
		putpixel(marsbmp,x+17,y+46,ac3);
		putpixel(marsbmp,x+16,y+48,ac3);
		putpixel(marsbmp,x+15,y+50,ac3);
		putpixel(marsbmp,x+15,y+51,ac4);
		putpixel(marsbmp,x+14,y+52,ac2);
		putpixel(marsbmp,x+14,y+53,ac3);
		putpixel(marsbmp,x+13,y+55,ac3);
		putpixel(marsbmp,x+12,y+59,bc);
		putpixel(marsbmp,x+12,y+57,ac2);
		putpixel(marsbmp,x+12,y+58,ac3);
		vline(marsbmp,x+11,y+61,y+63,bc);
		putpixel(marsbmp,x+11,y+60,ac3);
		vline(marsbmp,x+10,y+65,y+69,bc);
		MarsFadeDown(x+10,y+63,fc,3);
		MarsFadeDown(x+9,y+67,fc,14);
		return;
	}
	if(s==4) {
/* left side */
		MarsFadeUp(x+20,y+36,fc,5);
		putpixel(marsbmp,x+19,y+38,ac3);
		putpixel(marsbmp,x+18,y+40,ac3);
		putpixel(marsbmp,x+18,y+41,ac2);
		putpixel(marsbmp,x+17,y+42,ac4);
		putpixel(marsbmp,x+17,y+43,ac3);
		putpixel(marsbmp,x+16,y+45,ac3);
		putpixel(marsbmp,x+15,y+47,ac4);
		putpixel(marsbmp,x+15,y+48,ac3);
		putpixel(marsbmp,x+14,y+50,ac3);
		putpixel(marsbmp,x+13,y+52,ac4);
		putpixel(marsbmp,x+13,y+53,ac3);
		putpixel(marsbmp,x+12,y+55,ac4);
		putpixel(marsbmp,x+11,y+57,ac3);
		putpixel(marsbmp,x+10,y+59,ac4);
		putpixel(marsbmp,x+10,y+60,ac3);
		putpixel(marsbmp,x+9,y+62,ac3);
		putpixel(marsbmp,x+8,y+64,ac4);
		putpixel(marsbmp,x+8,y+65,ac3);
		putpixel(marsbmp,x+7,y+67,ac3);
		putpixel(marsbmp,x+6,y+69,ac4);
		putpixel(marsbmp,x+6,y+70,ac3);
		putpixel(marsbmp,x+5,y+72,ac4);
		putpixel(marsbmp,x+5,y+73,ac3);
		putpixel(marsbmp,x+4,y+75,ac4);
		putpixel(marsbmp,x+4,y+76,ac3);
		putpixel(marsbmp,x+3,y+78,ac4);
		putpixel(marsbmp,x+3,y+79,ac3);
		MarsFadeUp(x+2,y+83,fc,3);
		MarsFadeUp(x+1,y+87,fc,3);
		MarsFadeUp(x,y+96,fc,8);

/* right side */
		MarsFadeDown(x+32,y+31,fc,9);
		putpixel(marsbmp,x+31,y+41,ac3);
		putpixel(marsbmp,x+31,y+42,ac4);
		putpixel(marsbmp,x+30,y+44,ac3);
		putpixel(marsbmp,x+29,y+46,ac3);
		putpixel(marsbmp,x+29,y+47,ac4);
		putpixel(marsbmp,x+28,y+49,ac3);
		putpixel(marsbmp,x+27,y+51,ac2);
		putpixel(marsbmp,x+27,y+52,ac3);
		putpixel(marsbmp,x+26,y+54,ac3);
		putpixel(marsbmp,x+25,y+56,ac3);
		putpixel(marsbmp,x+24,y+58,ac3);
		putpixel(marsbmp,x+24,y+59,ac4);
		putpixel(marsbmp,x+23,y+61,ac3);
		putpixel(marsbmp,x+22,y+63,ac3);
		putpixel(marsbmp,x+22,y+64,ac4);
		putpixel(marsbmp,x+21,y+66,ac3);
		putpixel(marsbmp,x+20,y+68,ac3);
		putpixel(marsbmp,x+20,y+69,ac4);
		putpixel(marsbmp,x+19,y+71,ac2);
		putpixel(marsbmp,x+19,y+72,ac3);
		putpixel(marsbmp,x+18,y+74,ac3);
		putpixel(marsbmp,x+18,y+75,ac4);
		putpixel(marsbmp,x+17,y+77,ac2);
		putpixel(marsbmp,x+17,y+78,ac3);
		MarsFadeDown(x+16,y+80,fc,3);
		MarsFadeDown(x+15,y+84,fc,3);
		MarsFadeDown(x+14,y+88,fc,5);
		MarsFadeDown(x+13,y+94,fc,12);
		return;
	}
	if(s==6) {
/* left side */
		MarsFadeUp(x+30,y+54,fc,7);
		putpixel(marsbmp,x+29,y+56,ac3);
		putpixel(marsbmp,x+28,y+58,ac3);
		putpixel(marsbmp,x+27,y+60,ac4);
		putpixel(marsbmp,x+27,y+61,ac3);
		putpixel(marsbmp,x+26,y+62,ac3);
		putpixel(marsbmp,x+25,y+65,ac4);
		putpixel(marsbmp,x+25,y+66,ac3);
		putpixel(marsbmp,x+24,y+68,ac3);
		putpixel(marsbmp,x+23,y+70,ac4);
		putpixel(marsbmp,x+23,y+71,ac3);
		putpixel(marsbmp,x+22,y+73,ac3);
		putpixel(marsbmp,x+21,y+75,ac4);
		putpixel(marsbmp,x+21,y+76,ac3);
		putpixel(marsbmp,x+20,y+78,ac4);
		putpixel(marsbmp,x+20,y+79,ac3);
		putpixel(marsbmp,x+19,y+81,ac3);
		putpixel(marsbmp,x+18,y+83,ac4);
		putpixel(marsbmp,x+18,y+84,ac3);
		putpixel(marsbmp,x+17,y+86,ac3);
		putpixel(marsbmp,x+16,y+88,ac4);
		putpixel(marsbmp,x+16,y+89,ac3);
		putpixel(marsbmp,x+15,y+91,ac3);
		putpixel(marsbmp,x+14,y+93,ac4);
		putpixel(marsbmp,x+14,y+94,ac3);
		putpixel(marsbmp,x+13,y+96,ac3);
		putpixel(marsbmp,x+12,y+98,ac4);
		putpixel(marsbmp,x+12,y+99,ac3);
		putpixel(marsbmp,x+11,y+101,ac3);
		putpixel(marsbmp,x+10,y+103,ac4);
		putpixel(marsbmp,x+10,y+104,ac3);
		putpixel(marsbmp,x+9,y+106,ac4);
		putpixel(marsbmp,x+9,y+107,ac3);
		putpixel(marsbmp,x+8,y+109,ac4);
		putpixel(marsbmp,x+8,y+110,ac3);
		putpixel(marsbmp,x+7,y+112,ac4);
		putpixel(marsbmp,x+7,y+113,ac3);
		putpixel(marsbmp,x+6,y+115,ac4);
		putpixel(marsbmp,x+6,y+116,ac3);

		MarsFadeUp(x+5,y+120,fc,3);
		putpixel(marsbmp,x+4,y+122,ac4);
		putpixel(marsbmp,x+4,y+123,ac3);
		MarsFadeUp(x+3,y+128,fc,4);
		MarsFadeUp(x+2,y+132,fc,3);
		MarsFadeUp(x+1,y+138,fc,5);
		MarsFadeUp(x,y+149,fc,10);
/* right side */
		MarsFadeDown(x+48,y+49,fc,8);
		putpixel(marsbmp,x+47,y+59,ac3);
		putpixel(marsbmp,x+47,y+60,ac4);
		putpixel(marsbmp,x+46,y+62,ac3);
		putpixel(marsbmp,x+45,y+64,ac3);
		putpixel(marsbmp,x+45,y+65,ac4);
		putpixel(marsbmp,x+44,y+67,ac3);
		putpixel(marsbmp,x+43,y+69,ac3);
		putpixel(marsbmp,x+43,y+70,ac4);
		putpixel(marsbmp,x+42,y+72,ac3);
		putpixel(marsbmp,x+41,y+74,ac3);
		putpixel(marsbmp,x+41,y+75,ac4);
		putpixel(marsbmp,x+40,y+77,ac3);
		putpixel(marsbmp,x+40,y+78,ac4);
		putpixel(marsbmp,x+39,y+80,ac3);
		putpixel(marsbmp,x+38,y+82,ac3);
		putpixel(marsbmp,x+38,y+83,ac4);
		putpixel(marsbmp,x+37,y+85,ac3);
		putpixel(marsbmp,x+36,y+87,ac3);
		putpixel(marsbmp,x+36,y+88,ac4);
		putpixel(marsbmp,x+35,y+90,ac3);
		putpixel(marsbmp,x+34,y+92,ac3);
		putpixel(marsbmp,x+34,y+93,ac4);
		putpixel(marsbmp,x+33,y+95,ac3);
		putpixel(marsbmp,x+33,y+96,ac4);
		putpixel(marsbmp,x+32,y+98,ac3);
		putpixel(marsbmp,x+31,y+100,ac3);
		putpixel(marsbmp,x+31,y+101,ac4);
		putpixel(marsbmp,x+30,y+103,ac3);
		putpixel(marsbmp,x+29,y+105,ac3);
		putpixel(marsbmp,x+29,y+106,ac4);
		putpixel(marsbmp,x+28,y+108,ac3);
		putpixel(marsbmp,x+28,y+109,ac4);
		putpixel(marsbmp,x+27,y+111,ac3);
		putpixel(marsbmp,x+27,y+112,ac4);
		putpixel(marsbmp,x+26,y+114,ac3);
		putpixel(marsbmp,x+26,y+115,ac3);
		putpixel(marsbmp,x+25,y+117,ac3);
		putpixel(marsbmp,x+25,y+118,ac4);
		putpixel(marsbmp,x+24,y+121,ac3);
		putpixel(marsbmp,x+24,y+121,ac4);
		MarsFadeDown(x+23,y+124,fc,4);
		MarsFadeDown(x+22,y+129,fc,3);
		MarsFadeDown(x+21,y+133,fc,5);
		MarsFadeDown(x+20,y+139,fc,5);
		MarsFadeDown(x+19,y+145,fc,10);
	}
	if(s==10) {
/* left side */
		MarsFadeUp(x+50,y+90,fc,10);
		putpixel(marsbmp,x+49,y+90,ac4);
		putpixel(marsbmp,x+49,y+91,ac3);
		putpixel(marsbmp,x+49,y+92,ac2);
		putpixel(marsbmp,x+48,y+94,ac4);
		putpixel(marsbmp,x+47,y+97,ac3);
		putpixel(marsbmp,x+46,y+100,ac3);
		putpixel(marsbmp,x+45,y+102,ac3);
		putpixel(marsbmp,x+44,y+105,ac3);
		putpixel(marsbmp,x+43,y+107,ac4);
		putpixel(marsbmp,x+42,y+110,ac3);
		putpixel(marsbmp,x+41,y+112,ac4);
		putpixel(marsbmp,x+40,y+115,ac3);
		putpixel(marsbmp,x+39,y+118,ac3);
		putpixel(marsbmp,x+38,y+120,ac4);
		putpixel(marsbmp,x+37,y+123,ac3);
		putpixel(marsbmp,x+36,y+125,ac3);
		putpixel(marsbmp,x+35,y+128,ac3);
		putpixel(marsbmp,x+34,y+131,ac3);
		putpixel(marsbmp,x+33,y+133,ac3);
		putpixel(marsbmp,x+32,y+135,ac4);
		putpixel(marsbmp,x+32,y+136,ac3);
		putpixel(marsbmp,x+31,y+138,ac4);
		putpixel(marsbmp,x+30,y+140,ac4);
		putpixel(marsbmp,x+30,y+141,ac3);
		putpixel(marsbmp,x+29,y+143,ac3);
		putpixel(marsbmp,x+28,y+145,ac4);
		putpixel(marsbmp,x+28,y+146,ac3);
		putpixel(marsbmp,x+27,y+148,ac4);
		putpixel(marsbmp,x+27,y+149,ac3);
		putpixel(marsbmp,x+26,y+151,ac3);
		putpixel(marsbmp,x+25,y+153,ac4);
		putpixel(marsbmp,x+25,y+154,ac3);
		putpixel(marsbmp,x+24,y+156,ac3);
		putpixel(marsbmp,x+23,y+158,ac4);
		putpixel(marsbmp,x+23,y+159,ac3);
		putpixel(marsbmp,x+22,y+161,ac4);
		putpixel(marsbmp,x+21,y+163,ac4);
		putpixel(marsbmp,x+21,y+164,ac3);
		putpixel(marsbmp,x+20,y+166,ac4);
		putpixel(marsbmp,x+20,y+167,ac3);
		putpixel(marsbmp,x+19,y+169,ac4);
		putpixel(marsbmp,x+18,y+172,ac4);
		putpixel(marsbmp,x+18,y+173,ac3);
		putpixel(marsbmp,x+17,y+175,ac4);
		putpixel(marsbmp,x+17,y+176,ac3);
		putpixel(marsbmp,x+16,y+178,ac4);
		putpixel(marsbmp,x+16,y+179,ac3);
		putpixel(marsbmp,x+15,y+181,ac4);
		putpixel(marsbmp,x+14,y+183,ac4);
		putpixel(marsbmp,x+14,y+184,ac3);
		putpixel(marsbmp,x+13,y+186,ac4);
		putpixel(marsbmp,x+13,y+187,ac3);
		putpixel(marsbmp,x+12,y+190,ac4);
		putpixel(marsbmp,x+12,y+191,ac3);
		putpixel(marsbmp,x+11,y+194,ac3);
		putpixel(marsbmp,x+10,y+196,ac4);
		putpixel(marsbmp,x+10,y+197,ac3);
		putpixel(marsbmp,x+9,y+200,ac4);
		putpixel(marsbmp,x+9,y+201,ac3);
		putpixel(marsbmp,x+8,y+204,ac4);
		putpixel(marsbmp,x+8,y+205,ac3);
		putpixel(marsbmp,x+7,y+208,ac4);
		putpixel(marsbmp,x+7,y+209,ac3);
		putpixel(marsbmp,x+6,y+212,ac4);
		putpixel(marsbmp,x+6,y+213,ac3);
		putpixel(marsbmp,x+5,y+216,ac4);
		putpixel(marsbmp,x+5,y+217,ac3);
		MarsFadeUp(x+4,y+222,fc,4);
		MarsFadeUp(x+3,y+228,fc,4);
		MarsFadeUp(x+2,y+234,fc,4);
		MarsFadeUp(x+1,y+243,fc,8);
		MarsFadeUp(x,y+252,fc,9);
/* right side */
		MarsFadeDown(x+80,y+85,fc,8);
		putpixel(marsbmp,x+79,y+94,ac2);
		putpixel(marsbmp,x+79,y+95,ac3);
		putpixel(marsbmp,x+78,y+98,ac3);
		putpixel(marsbmp,x+76,y+103,ac3);
		putpixel(marsbmp,x+74,y+108,ac3);
		putpixel(marsbmp,x+72,y+113,ac3);
		putpixel(marsbmp,x+71,y+116,ac3);
		putpixel(marsbmp,x+69,y+121,ac3);
		putpixel(marsbmp,x+67,y+126,ac3);
		putpixel(marsbmp,x+66,y+129,ac3);
		putpixel(marsbmp,x+64,y+134,ac3);
		putpixel(marsbmp,x+62,y+139,ac3);
		putpixel(marsbmp,x+60,y+144,ac4);
		putpixel(marsbmp,x+59,y+147,ac3);
		putpixel(marsbmp,x+57,y+152,ac3);
		putpixel(marsbmp,x+56,y+155,ac4);
		putpixel(marsbmp,x+55,y+157,ac3);
		putpixel(marsbmp,x+55,y+158,ac4);
		putpixel(marsbmp,x+54,y+160,ac2);
		putpixel(marsbmp,x+54,y+161,ac3);
		putpixel(marsbmp,x+53,y+163,ac2);
		putpixel(marsbmp,x+53,y+164,ac4);
		putpixel(marsbmp,x+52,y+166,ac2);
		putpixel(marsbmp,x+52,y+167,ac4);
		putpixel(marsbmp,x+51,y+169,ac3);
		putpixel(marsbmp,x+50,y+171,ac2);
		putpixel(marsbmp,x+50,y+172,ac4);
		putpixel(marsbmp,x+49,y+174,ac3);
		putpixel(marsbmp,x+48,y+177,ac3);
		putpixel(marsbmp,x+47,y+180,ac4);
		putpixel(marsbmp,x+46,y+182,ac3);
		putpixel(marsbmp,x+45,y+185,ac3);
		putpixel(marsbmp,x+44,y+188,ac3);
		putpixel(marsbmp,x+43,y+191,ac2);
		putpixel(marsbmp,x+43,y+192,ac3);
		putpixel(marsbmp,x+42,y+195,ac3);
		putpixel(marsbmp,x+41,y+198,ac3);
		putpixel(marsbmp,x+41,y+199,ac4);
		putpixel(marsbmp,x+40,y+202,ac3);
		putpixel(marsbmp,x+40,y+203,ac4);
		putpixel(marsbmp,x+39,y+206,ac3);
		putpixel(marsbmp,x+39,y+207,ac4);
		putpixel(marsbmp,x+38,y+210,ac3);
		putpixel(marsbmp,x+38,y+211,ac4);
		MarsFadeDown(x+37,y+214,fc,3);
		MarsFadeDown(x+36,y+218,fc,4);
		MarsFadeDown(x+35,y+223,fc,4);
		MarsFadeDown(x+34,y+229,fc,5);
		MarsFadeDown(x+33,y+235,fc,6);
		MarsFadeDown(x+32,y+242,fc,16);
	}
}
void WfClean(int x, int y)
{
/* full-height verticals to erase antialiasing slopover */
	line(marsbmp,x-1,y,x-1,y+(s*28),bc);
	line(marsbmp,x-2,y,x-2,y+(s*28)+2,bc);
	line(marsbmp,x+(s*8)+1,y,x+(s*8)+1,y+(s*28),bc);
}
int WfSpace()
{
	return(8);
}
int WfExclamPoint(int x,int y)
{
	rectfill(marsbmp, x,y,x+(s*3)-1,y+(s*22),fc);
	rectfill(marsbmp, x,y+(s*25),x+(s*3),y+(s*28),fc);
	return(3);
}
int WfApostrophe(int x,int y)
{
	rectfill(marsbmp, x,y,x+(s*3)-1,y+(s*9),fc);
	return(3);
}
int WfPlusSign(int x,int y)
{
	rectfill(marsbmp, x,y+(s*15),x+(s*13),y+(s*18),fc);
	rectfill(marsbmp, x+(s*5),y+(s*10),x+(s*8),y+(s*24),fc);
	return(12);
}
int WfComma(int x,int y)
{
	int a=x;

	rectfill(marsbmp, x,y+(s*25),x+(s*3),y+(s*28),fc);
	while(a <= x+s) {
		line(marsbmp, a+(s*2),y+(s*28),a,y+(s*31),fc);
		++a;
	}
	return(2);
}
int WfHyphen(int x,int y)
{
	rectfill(marsbmp, x+(s*0),y+(s*15),x+(s*6),y+(s*18),fc);
	return(6);
}
int WfPeriod(int x,int y)
{
	rectfill(marsbmp, x,y+(s*25),x+(s*3),y+(s*28),fc);
	return(3);
}
int WfSlash(int x,int y)
{
	float th;

	th=1;
	UphillHinting(4,x,y,th);
	Uphill(4,x,y,th);
	th=2;
	return(8);
}
int Wf0(int x,int y)
{
	WfO(x,y);
	return(8);
}
int Wf1(int x,int y)
{
	int a=x+(s*2);
	int b=y;

	rectfill(marsbmp,x+(s*2),y+(s*3),x+(s*7)-1,y+(s*5),fc);
	rectfill(marsbmp,x+(s*5),y,x+(s*7)-1,y+(s*5),fc);
	rectfill(marsbmp,x+(s*4),y+(s*5),x+(s*7)-1,y+(s*28),fc);
	while(a < x+(s*3)) {
		arc(marsbmp,a,b,0xC0FFFF,0,s*3,fc);
		arc(marsbmp,a,b+1,0xC0FFFF,0,s*3,fc);
		++a;
		++b;
	}
	Smooth1(x+(s*2),y);
	return(8);
}
int Wf2(int x,int y)
{
	int a=x;

	WfSoftCap(x,y);
	rectfill(marsbmp,x,y+(s*4),x+(s*3),y+(s*10)-1,fc);
	rectfill(marsbmp,x+(s*5),y+(s*4),x+(s*8),y+(s*9),fc);  /**/
	rectfill(marsbmp,x,y+(s*25),x+(s*8),y+(s*28),fc);
	BlackHole(marsbmp,x+(s*4),y+(s*4),s+1);
	rectfill(marsbmp,x+(s*3),y+(s*4),x+(s*5),y+(s*15),bc);
	rectfill(marsbmp,x,y+(s*11),x+(s*3),y+(s*15),bc);
	if(s==2) line(marsbmp,x+(s*5),y+(s*8),x+(s*5),y+(s*8.5),ac3);
	line(marsbmp,x+(s*5),y+(s*8.5)+1,x+(s*5),y+(s*9),ac1);

 arc(marsbmp, a+(s*30)-2,y+(s*28)+2,0x76FFFF,0x7EFFFF,s*30,ac3);

while(a <= x+(s*3) ) {
		arc(marsbmp, a+(s*30)-1,y+(s*28),0x6EFFFF,0x7EFFFF,s*30,fc);
		line(marsbmp, a+(s*2)-1,y+(s*17)+1,a+(s*5),y+(s*9 )+1,fc);    /**/
		++a;
	}
	line(marsbmp,x+(s*8),y+(s*9 )-5,x+(s*8),y+(s*9-3 ),ac2);
	line(marsbmp,x+(s*8),y+(s*9 )-2,x+(s*8),y+(s*9 )+2,ac4);
	rectfill(marsbmp,x-3,y+(s*22),x-1,y+(s*28),bc);
	WfClean(x,y);
	Smooth2(x,y);
	rectfill(marsbmp,x+(s*2),y+(s*25),x+(s*8),y+(s*28),fc);
	return(8);
}
int Wf3(int x,int y)
{
	Wf8(x,y);
	rectfill(marsbmp, x,y+(s*10),x+(s*4),y+(s*18),bc);
	rectfill(marsbmp, x+(s*3),y+(s*12)+1,x+(s*4),y+(s*15)-1,fc);
	return(8);
}
int Wf4(int x,int y)
{
	int a=x-(s*.25);
	int b;
	int slant=5;
	float th=2.5;

	if(s==1) th=1;
	if(s==2) th=2;
	b=y+(s*18)+(slant*.5);
	while(b >= y+slant) {
		b=b-slant;
		putpixel(marsbmp, a,b-1, ac4);
		putpixel(marsbmp, a,b, ac3);
		putpixel(marsbmp, a,b+1, ac2);
		putpixel(marsbmp, a,b+2, ac2);
		putpixel(marsbmp, a,b+3, fc);
		putpixel(marsbmp, a+(s*th),b+(slant*2)+2, ac4);
		putpixel(marsbmp, a+(s*th),b+(slant*2)+1, ac3);
		putpixel(marsbmp, a+(s*th),b+(slant*2), ac2);
		putpixel(marsbmp, a+(s*th),b+(slant*2)-1, ac2);
		++a;
	}
	a=x-(s*.25);
	b=y+(s*18);
	while(b >= y+slant) {
		++a;
		b=b-slant;
		rectfill(marsbmp, a,b,a+(s*th),b+slant,fc);
	}
	++a;
	rectfill(marsbmp, a,y,a+s,b+1,fc);
	rectfill(marsbmp, x+(s*5),y,x+(s*8)-1,y+(s*28),fc);
	rectfill(marsbmp, x-(s*.25),y+(s*18)+1,x+(s*9)-1,y+(s*21),fc);
	rectfill(marsbmp, x+(s*4),y,x+(s*6),y+s,fc);
	rectfill(marsbmp, x-1,y+(s*21)+1,x+(s*4),y+(s*28),bc);
	return(8);
}
int Wf5(int x,int y)
{
	Wf6(x,y);
	rectfill(marsbmp, x,y,x+(s*8),y+(s*10),bc);
	rectfill(marsbmp, x,y+(s*16),x+(s*3),y+(s*18),bc);
	rectfill(marsbmp, x,y,x+(s*3)-1,y+(s*11),fc);
	rectfill(marsbmp, x+(s*3),y,x+(s*8),y+(s*3),fc);
	return(8);
}
int Wf6(int x,int y)
{
	WfC(x,y);
	CropCircle(marsbmp,0,x+(s*5.5),y+(s*13),(s*2.5)+1);
	rectfill(marsbmp, x+(s*3),y+(s*13),x+(s*8),y+(s*18),fc); /**/
	BlackHole(marsbmp,x+(s*4),y+(s*15),s+1);
	rectfill(marsbmp, x+(s*3),y+(s*15),x+(s*5),y+(s*24),bc);
	return(8);
}
int Wf7(int x,int y)
{
	float th;

	th=3;
	if(s<6) th=2.5;
	UphillHinting(7,x+s,y,th);
	Uphill(7,x+s,y,th);
	rectfill(marsbmp, x,y,x+(s*6),y+(s*3),fc);
	return(8);
}
int Wf8(int x,int y)
{
	WfSoftCap(x,y);
	WfSoftFoot(x,y);

	CropCircle(marsbmp,0,x+(s*5.5),y+(s*11),(s*2.5)+1);
	CropCircle(marsbmp,0,x+(s*5.5),y+(s*16),(s*2.5)+1);
	CropCircle(marsbmp,0,x+(s*2.5),y+(s*11),(s*2.5)+1);
	CropCircle(marsbmp,0,x+(s*2.5),y+(s*16),(s*2.5)+1);
	rectfill(marsbmp, x,y+(s*4)-1,x+(s*8),y+(s*11),fc);   /**/
	rectfill(marsbmp, x,y+(s*16),x+(s*8),y+(s*24)+1,fc);
	rectfill(marsbmp, x+(s*2),y+(s*11),x+(s*6),y+(s*16),fc);
	BlackHole(marsbmp,x+(s*4),y+(s*4),s+1);
	BlackHole(marsbmp,x+(s*4),y+(s*24),s+1);
	BlackHole(marsbmp,x+(s*4),y+(s*11),s+1);
	BlackHole(marsbmp,x+(s*4),y+(s*16),s+1);
	rectfill(marsbmp, x+(s*3),y+(s*4),x+(s*5),y+(s*11),bc);
	rectfill(marsbmp, x+(s*3),y+(s*16),x+(s*5),y+(s*24),bc);
	WfClean(x,y);
	return(8);
}
int Wf9(int x,int y)
{
	WfO(x,y);
	rectfill(marsbmp, x,y+(s*14),x+(s*3),y+(s*18)+1,bc);
	CropCircle(marsbmp,0,x+(s*2.5),y+(s*15),(s*2.5)+1);
	rectfill(marsbmp, x,y+(s*11),x+(s*6),y+(s*15)+1,fc);
	BlackHole(marsbmp,x+(s*4),y+(s*13),s+1);
	rectfill(marsbmp, x+(s*3),y+(s*11),x+(s*5),y+(s*13),bc);
	return(8);
}
int WfColon(int x,int y)
{
	rectfill(marsbmp, x,y+(s*7)-1,x+(s*3),y+(s*10)-1,fc);
	rectfill(marsbmp, x,y+(s*25),x+(s*3),y+(s*28),fc);
	return(3);
}
int WfA(int x,int y)
{
	int a;
	int slant=14;
	float th=2.5;

	if(s==1) slant=9;
	th=2.3;
	if(s==2) th=2;
	a=UphillHinting(slant,x,y,th);
	a=a+(s*.5);
	DownhillHinting(slant,a+(s*2),y,th);
	a=Uphill(slant,x,y,th);
	a=a+(s*.5);
	Downhill(slant,a+(s*2),y,th);
	rectfill(marsbmp, x+(s*2.5),y+(s*18)+1,x+(s*6.5),y+(s*21),fc); /* rung */
	if(s==1) return(11);
	rectfill(marsbmp, x+(s*4)-1,y,x+(s*5)+1,y+(s*6),fc); /* top patch */
	return(9);
}
int WfB(int x,int y)
{
	WfSoftCap(x,y);
	WfSoftFoot(x,y);
	CropCircle(marsbmp,0,x+(s*5),y+(s*11),(s*3)+1);
	CropCircle(marsbmp,0,x+(s*5),y+(s*16),(s*3)+1);
	rectfill(marsbmp, x+(s*3)-1,y+(s*4),x+(s*8),y+(s*11)+1,fc);
	rectfill(marsbmp, x+(s*3)-1,y+(s*16),x+(s*8),y+(s*24)+1,fc);
	rectfill(marsbmp, x+(s*2)-1,y+(s*11),x+(s*6),y+(s*18)+1,fc);
	BlackHole(marsbmp,x+(s*4),y+(s*4),s+1);
	BlackHole(marsbmp,x+(s*4),y+(s*24),s+1);
	BlackHole(marsbmp,x+(s*4),y+(s*11),s+1);
	BlackHole(marsbmp,x+(s*4),y+(s*16),s+1);
	rectfill(marsbmp, x+(s*3),y+(s*4),x+(s*5),y+(s*11),bc);
	rectfill(marsbmp, x,y+(s*3),x+(s*4),y+(s*12),bc);
	rectfill(marsbmp, x+(s*3),y+(s*16),x+(s*5),y+(s*24),bc);
	rectfill(marsbmp, x,y+(s*15),x+(s*4),y+(s*25),bc);        /**/
	WfI(x,y);
	rectfill(marsbmp, x,y,x+(s*4),y+s,fc);
	rectfill(marsbmp, x,y+(26*s),x+(s*4),y+(s*28),fc);     /* ? */
	rectfill(marsbmp, x+(s*5),y+(s*12),x+(s*6.5)+1,y+(s*15),fc);
	WfClean(x,y);
	return(8);
}
int WfC(int x,int y)
{
	WfO(x,y);
	rectfill(marsbmp, x+(s*5),y+(s*10),x+(s*8),y+(s*18),bc);
	return(8);
}
int WfD(int x,int y)
{
	WfSoftCap(x,y);
	WfSoftFoot(x,y);
	rectfill(marsbmp, x,y+(s*4),x+(s*8),y+(s*24),fc);   /**/
	rectfill(marsbmp, x,y,x+(s*4),y+(s*28),fc);
	BlackHole(marsbmp,x+(s*4),y+(s*4),s+1);
	BlackHole(marsbmp,x+(s*4),y+(s*24),s+1);
	rectfill(marsbmp, x+(s*3),y+(s*4),x+(s*5),y+(s*24),bc);
	rectfill(marsbmp, x+(s*3),y+(s*3),x+(s*4),y+(s*25),bc);  /**/
	WfI(x,y);
	WfClean(x,y);
	return(8);
}
int WfE(int x,int y)
{
	WfF(x,y);
	rectfill(marsbmp, x+s,y+(s*25),x+(s*7),y+(s*28),fc);
	return(7);
}
int WfF(int x,int y)
{
	WfI(x,y);
	rectfill(marsbmp, x+s,y,x+(s*7),y+(s*3),fc);
	rectfill(marsbmp, x+s,y+(s*11),x+(s*7),y+(s*14),fc);
	return(7);
}
int WfG(int x,int y)
{
	WfC(x,y);
	rectfill(marsbmp, x+(s*4)+1,y+(s*14)+1,x+(s*8),y+(s*17)+1,fc);
	rectfill(marsbmp, x+(s*5)+1,y+(s*17)+1,x+(s*8),y+(s*19),fc);
	rectfill(marsbmp, x+(s*7),y+(s*25)+1,x+(s*8),y+(s*28),fc);
	return(8);
}
int WfH(int x,int y)
{
	WfI(x,y);
	rectfill(marsbmp, x+(s*5)+1,y,x+(s*8),y+(s*28),fc);
	rectfill(marsbmp, x+s,y+(s*11),x+(s*5),y+(s*14),fc);
	return(8);
}
int WfI(int x,int y)
{
	rectfill(marsbmp, x,y,x+(s*3)-1,y+(s*28),fc);
	return(3);
}
int WfJ(int x,int y)
{
	WfU(x,y);
	rectfill(marsbmp, x,y,x+(s*3),y+(s*18),bc);
	return(8);
}
int WfK(int x,int y)
{
	int a=x+(s/2)+1;
	int b;
	int slant=3;
	float th;

	th=3;
	b=y+(s*15);
	while(b >= y+slant) {
		MarsFadeUp(a, b, fc, slant+1);
		++a;
		b=b-slant;
		rectfill(marsbmp, a,b,a+(s*3),b+slant,fc);
		MarsFadeDown(a+(s*th), b, fc, slant+1);
	}
	++a;
	rectfill(marsbmp, a,y,a+s,b+1,fc);
	slant=3;
	a=x+(s/2)+1;
	b=y+(s*11);
	while(b <= y+(s*28)-slant) {
		++a;
		b=b+slant;
		rectfill(marsbmp, a,b,a+(s*3),b+slant,fc);
		MarsFadeDown(a, b, fc, slant+1);
		MarsFadeUp(a+(s*th)+1, b+slant, fc, slant+1);
	}
	rectfill(marsbmp, a-1,y+(s*29)+1,a+(s*3.5),y+(s*30)-slant,BLACK);
	WfI(x,y);
	if(s==2) {
		putpixel(marsbmp, x+(s*5),y+(s*13)-1,ac3);
		putpixel(marsbmp, x+(s*5),y+(s*13),ac3);
		putpixel(marsbmp, x+(s*5),y+(s*13)+1,ac3);
	}
	rectfill(marsbmp, x,y+(s*10),x+(s*4)+2,y+(s*13.5),fc);
	return(9);
}
int WfL(int x,int y)
{
	WfI(x,y);
	rectfill(marsbmp, x+s,y+(s*25),x+(s*7),y+(s*28),fc);
	return(7);
}
int WfM(int x,int y)
{
	int trim;
	float th;

	th=1.5;
	trim=0;
	if(s<6) trim=1;

	DownhillHinting(14,x+(s*2),y,th);
	UphillHinting(14,x+(s*4.5),y,th);
	Downhill(14,x+(s*2),y,th);
	Uphill(14,x+(s*4.5),y,th);
	rectfill(marsbmp, x,y,x+(s*2.5)-trim,y+(s*28),fc);
	rectfill(marsbmp, x+(s*7.5)+1,y,x+(s*10),y+(s*28),fc);
	rectfill(marsbmp, x+(s*2),y+(s*9),x+(s*3),y+(s*14),fc);
	rectfill(marsbmp, x+(s*7),y+(s*9),x+(s*8),y+(s*14),fc);
	rectfill(marsbmp, x+(s*5)-1,y+(s*18),x+(s*5)+1,y+(s*24),fc);
	return(10);
}
int WfN(int x,int y)
{
	float th;

	th=1.5;
	DownhillHinting(7,x+(s*1.5),y,th);
	Downhill(7,x+(s*1.5),y,th);
	rectfill(marsbmp, x,y,x+(s*2.5),y+(s*28),fc);
	rectfill(marsbmp, x+(s*5.5)+1,y,x+(s*8),y+(s*28),fc);
	return(8);
}
int WfO(int x,int y)
{
	WfSoftCap(x,y);
	WfSoftFoot(x,y);
	rectfill(marsbmp, x,y+(s*4)-1,x+(s*8),y+(s*24)+1,fc);
	BlackHole(marsbmp,x+(s*4),y+(s*4),s+1);
	BlackHole(marsbmp,x+(s*4),y+(s*24),s+1);
	rectfill(marsbmp, x+(s*3),y+(s*4),x+(s*5),y+(s*24),bc);
	WfClean(x,y);
	return(8);
}
int WfP(int x,int y)
{
	WfSoftCap(x,y);
	CropCircle(marsbmp,0,x+(s*4),y+(s*13),(s*4)+1);
	rectfill(marsbmp, x,y+(s*4),x+(s*8),y+(s*13),fc);
	rectfill(marsbmp, x,y,x+(s*4),y+s,fc);
	BlackHole(marsbmp,x+(s*4),y+(s*4),s+1);
	BlackHole(marsbmp,x+(s*4),y+(s*13),s+1);
	rectfill(marsbmp, x+(s*3),y+(s*4),x+(s*5),y+(s*13),bc);
	rectfill(marsbmp, x+(s*3),y+(s*3),x+(s*4),y+(s*14),bc);
	WfI(x,y);
	WfClean(x,y);
	return(8);
}
int WfQ(int x,int y)
{
	int a=x;
	int b;
	int c=0;
	float slant=1.5;

	WfO(x,y);
	a=x+s;
	b=y+(s*26);
	rectfill(marsbmp, a,b,a+(s*3),b+(slant/2),fc);
	while(b <= y+(s*30)-slant) {
		++a;
		++c;
		if (c < 4) ++a;
		rectfill(marsbmp, a,b,a+(s*3),b+slant,fc);
		b=b+slant;
	}
	WfClean(x,y);
	return(8);
}
int WfR(int x,int y)
{
	WfB(x,y);
	rectfill(marsbmp, x+(s*5),y+(s*24),x+(s*8),y+(s*28),fc);
	rectfill(marsbmp, x+(s*3),y+(s*23),x+(s*5),y+(s*28),bc);
	line(marsbmp, x+(s*5)+1,y+(s*28)-s/2,x+(s*5)+1,y+(s*28),ac3);
	line(marsbmp, x+(s*5)+1,y+(s*27),x+(s*5)+1,y+(s*28)-s/2,ac2);
	line(marsbmp, x+(s*8)+1,y+(s*27),x+(s*8)+1,y+(s*28)-s/2,ac3);
	line(marsbmp, x+(s*8)+1,y+(s*28)-s/2,x+(s*8)+1,y+(s*28),ac2);
	return(8);
}
int WfS(int x,int y)
{
	int a=x;

	WfSoftCap(x,y);
	WfSoftFoot(x,y);

	ellipsefill(marsbmp, x+(s*4),y+(s*7)+2,s*4,s*6,ac2);
	ellipsefill(marsbmp, x+(s*4),y+(s*20)-2,s*4,s*6,ac2);

	ellipsefill(marsbmp, x+(s*4),y+(s*7),s*4,s*6,fc);
	ellipsefill(marsbmp, x+(s*4),y+(s*20),s*4,s*6,fc);

	rectfill(marsbmp, x,y+(s*4),x+(s*3),y+(s*8),fc);
	rectfill(marsbmp, x+(s*5),y+(s*4),x+(s*8),y+(s*10),fc); /**/
	rectfill(marsbmp, x,y+(s*18),x+(s*4),y+(s*24)+1,fc);
	rectfill(marsbmp, x+(s*5),y+(s*20),x+(s*8),y+(s*24)+1,fc);
	rectfill(marsbmp, x,y+(s*14),x+(s*4),y+(s*18),bc);
	rectfill(marsbmp, x+(s*5),y+(s*10),x+(s*8),y+(s*16),bc);  /**/
	BlackHole(marsbmp,x+(s*4),y+(s*4),s+1);
	BlackHole(marsbmp,x+(s*4),y+(s*24),s+1);
	rectfill(marsbmp, x+(s*3),y+(s*4),x+(s*5),y+(s*24),bc);
	line(marsbmp, x+(s*3),y+(s*8),x+(s*3),y+(s*8.5),ac3);
	line(marsbmp, x+(s*3),y+(s*8.5),x+(s*3),y+(s*9),ac1);
	line(marsbmp, x+(s*5),y+(s*18.5),x+(s*5),y+(s*19),ac3);
	line(marsbmp, x+(s*5),y+(s*18.5),x+(s*5),y+(s*18),ac1);
	a=x-1;
	line(marsbmp, a+s,y+(s*11),a+(s*5),y+(s*18),bc);
	line(marsbmp, a+s,y+(s*11)-1,a+(s*5),y+(s*18)-1,ac3);
	while(a <= x+(s*2)) {
		++a;
		line(marsbmp, a+s,y+(s*11),a+(s*5),y+(s*18),fc);
	}
	a=x+1;
	line(marsbmp, a+(s*3),y+(s*9),a+(s*7),y+(s*16),bc);
	line(marsbmp, a+(s*3),y+(s*9)+1,a+(s*7),y+(s*16)+1,ac3);
	while(a >= x-(s*2)) {
		--a;
		line(marsbmp, a+(s*3),y+(s*9 ),a+(s*7),y+(s*16),fc);
	}
	WfClean(x,y);
/*
	if(s==2) {
		MarsFadeDown(x,y+16,fc,4);
		MarsFadeUp(x+16,y+39,fc,5);
	}
*/
		MarsFadeDown(x,y+(s*8),fc,s*2);
		MarsFadeUp(x+(s*8),y+(s*19),fc,s*2);
	return(8);
}
int WfT(int x,int y)
{
	rectfill(marsbmp, x,y,x+(s*9),y+(s*3),fc);
	rectfill(marsbmp, x+(s*3),y,x+(s*6)-1,y+(s*28),fc);
	return(9);
}
int WfU(int x,int y)
{
	WfSoftFoot(x,y);
	rectfill(marsbmp, x,y,x+(s*8),y+(s*24),fc);
	BlackHole(marsbmp,x+(s*4),y+(s*24),s+1);
	rectfill(marsbmp, x+(s*3),y,x+(s*5),y+(s*24),bc);
	WfClean(x,y);
	return(8);
}
int WfV(int x,int y)
{
	int a;
	int slant=14;
	float th;

	th=2.3;
	DownhillHinting(slant,x,y,th);
	UphillHinting(slant,x+(s*3.5),y,th);
	a=a+(s*.5);

	Downhill(slant,x,y,th);
	Uphill(slant,x+(s*3.5),y,th);
	rectfill(marsbmp, x+(s*3),y+(s*20),x+(s*5),y+(s*23),fc); /* 14 -> 16 -> 17 */
	return(9);
}
int WfW(int x,int y)
{
	int slant=14;
	float th;

	th=2;
	DownhillHinting(slant,x,y,th);
	th=1.7;
	UphillHinting(slant,x+(s*2.5),y,th);
	DownhillHinting(slant,x+(s*6),y,th);
	th=2;
	UphillHinting(slant,x+(s*8),y,th);

	Downhill(slant,x,y,th);
	th=1.7;
	Uphill(slant,x+(s*2.5),y,th);
	Downhill(slant,x+(s*6),y,th);
	th=2;
	Uphill(slant,x+(s*8),y,th);
	rectfill(marsbmp, x+(s*2),y+(s*14),x+(s*4),y+(s*19),fc);
	rectfill(marsbmp, x+(s*8)-1,y+(s*14),x+(s*10),y+(s*19),fc);
	return(13);
}
int WfX(int x,int y)
{
	float th=2.5;

	UphillHinting(4,x,y,th);
	DownhillHinting(4,x,y,th);
	Uphill(4,x,y,th);
	Downhill(4,x,y,th);
	return(9);
}
int WfY(int x,int y)
{
	int i=0;

	if(s==4) i=1;
	WfX(x,y);
	rectfill(marsbmp, x,y+(s*14)+i,x+(s*9.5),y+(s*28),bc);
	rectfill(marsbmp, x+(s*3.5)-i,y+(s*13),x+(s*6.5)-i-1,y+(s*28),fc);
	return(10);
}
int WfZ(int x,int y)
{
	float th=2.5;

	UphillHinting(7,x,y,th);
	Uphill(7,x,y,th);
	rectfill(marsbmp, x,y,x+(s*6),y+(s*3),fc);
	rectfill(marsbmp, x+s,y+(s*25),x+(s*7),y+(s*28),fc);
	return(7);
}
int Special(int x,int y)
{
	rectfill(marsbmp, x,y,x+3,y+35,fc);
	return(3);
}
void MarsF(int x,int y,int Size,int ForeColor,int BackColor,char *cStr)
{
	char szCapture[80];
	int i,k;
	int p; /* pitch */
	int d; /* position */
	int Width, Height;
	int x_holder, y_holder;
	size_t j;

	x_holder=x;
	y_holder=y;
	x=0;
	y=0;

	Width=StrLenMars(Size, cStr)+1;
	Height=(Size*28)+1;

	marsbmp=create_bitmap(Width,Height);
	clear_to_color(marsbmp,BLACK);

	fc=ForeColor;  /* 3 globals */
	bc=BackColor;
	s=Size;
	if(bc==BLACK) FadeOut(fc);
/*	if(fc==BLACK) FadeIn(bc);  */

	d=x;
	j=strlen(cStr);
	strcpy(szCapture,cStr);
	k=0;
	szCapture[j+1]=(k);
	for(k=0; k < j; ++k) {
		i=toupper(szCapture[k]);
		switch(i)
		{
		case 32:
		p=WfSpace();
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 33:
		p=WfExclamPoint(d,y);
		d=d+(p*s)+(s*1.5)+3;
		break;
		case 39:
		p=WfApostrophe(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 43:
		p=WfPlusSign(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 44:
		p=WfComma(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 45:
		p=WfHyphen(d,y);
		d=d+(p*s)+(s*1.5)+2;
		if(szCapture[k+1]==45) d=d-(s*3);
		break;
		case 46:
		p=WfPeriod(d,y);
		d=d+(p*s)+(s*1.5)+3;
		break;
		case 47:
		p=WfSlash(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 48:
		p=Wf0(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 49:
		p=Wf1(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 50:
		p=Wf2(d,y);
		d=d+(p*s)+(s*1.5)+2;
                break;
		case 51:
		p=Wf3(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 52:
		p=Wf4(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 53:
		p=Wf5(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 54:
		p=Wf6(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 55:
		p=Wf7(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 56:
		p=Wf8(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 57:
		p=Wf9(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 58:
		p=WfColon(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 65:
		p=WfA(d,y);
		d=d+(p*s)+(s*1.5)+1;
		if(szCapture[k+1]==84) d=d-s;
		if(szCapture[k+1]==86) d=d-s;
		if(szCapture[k+1]==87) d=d-s;
		if(szCapture[k+1]==89) d=d-(s*1.5);
		break;
		case 66:
		p=WfB(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 67:
		p=WfC(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 68:
		p=WfD(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 69:
		p=WfE(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 70:
		p=WfF(d,y);
		d=d+(p*s)+(s*1.5)+2;
		if(szCapture[k+1]==65) d=d-s;
		break;
		case 71:
		p=WfG(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 72:
		p=WfH(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 73:
		p=WfI(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 74:
		p=WfJ(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 75:
		p=WfK(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 76:
		p=WfL(d,y);
		d=d+(p*s)+(s*1.5)+2;
		if(szCapture[k+1]==84) d=d-s;
		if(szCapture[k+1]==86) d=d-s;
		if(szCapture[k+1]==87) d=d-s;
		if(szCapture[k+1]==89) d=d-(s*2);
		break;
		case 77:
		p=WfM(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 78:
		p=WfN(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 79:
		p=WfO(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 80:
		p=WfP(d,y);
		d=d+(p*s)+(s*1.5)+2;
		if(szCapture[k+1]==65) d=d-s;
		break;
		case 81:
		p=WfQ(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 82:
		p=WfR(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 83:
		p=WfS(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 84:
		p=WfT(d,y);
		d=d+(p*s)+(s*1.5)+2;
		if(szCapture[k+1]==65) d=d-s;
		if(szCapture[k+1]==74) d=d-s;
		break;
		case 85:
		p=WfU(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 86:
		if(k==0) d+=1;
		p=WfV(d,y);
		d=d+(p*s)+s+1;
		if(szCapture[k+1]==65) d=d-s;
		break;
		case 87:
		if(k==0) d+=1;
		p=WfW(d,y);
		d=d+(p*s)+s+1;
		if(szCapture[k+1]==65) d=d-s;
		break;
		case 88:
		p=WfX(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		case 89:
		p=WfY(d,y);
		d=d+(p*s)+s+1;
		if(szCapture[k+1]==65) d=d-s;
		break;
		case 90:
		p=WfZ(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		default:
		p=WfHyphen(d,y);
		d=d+(p*s)+(s*1.5)+2;
		break;
		}
	}
	blit(marsbmp, screen, 0, 0, x_holder, y_holder, Width, Height);
	destroy_bitmap(marsbmp);
}
int StrLenMars(int s,char *cStr)
{
	char szCapture[120];
	int i,k;
	int d; /* position */
	size_t j;

	d=0;
	j=strlen(cStr);
	strcpy(szCapture,cStr);
	k=0;
	szCapture[j+1]=(k);
	for(k=0; k < j; ++k) {
		i=toupper(szCapture[k]);
		switch(i)
		{
		case 32:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 33:
		d+=(3*s)+(s*1.5)+2;
		break;
		case 39:
		d+=(3*s)+(s*1.5)+2;
		break;
		case 43:
		d+=(12*s)+(s*1.5)+2;
		break;
		case 44:
		d+=(12*s)+(s*1.5)+2; /*******/
		break;
		case 45:
		d+=(6*s)+(s*1.5)+2;
		if(szCapture[k+1]==45) d=d-(s*3);
		break;
		case 46:
		d+=(3*s)+(s*1.5)+2;
		break;
		case 47:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 48:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 49:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 50:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 51:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 52:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 53:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 54:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 55:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 56:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 57:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 58:
		d+=(3*s)+(s*1.5)+2;
		break;
		case 65:
		d+=(9*s)+(s*1.5)+2;
		if(szCapture[k+1]==84) d=d-s;
		if(szCapture[k+1]==86) d=d-s;
		if(szCapture[k+1]==87) d=d-s;
		if(szCapture[k+1]==89) d=d-(s*2);
		break;
		case 66:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 67:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 68:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 69:
		d+=(7*s)+(s*1.5)+2;
		break;
		case 70:
		d+=(7*s)+(s*1.5)+2;
		if(szCapture[k+1]==65) d=d-s;
		break;
		case 71:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 72:
		d+=(8*s)+(s*1.5)+2; /* H */
		break;
		case 73:
		d+=(3*s)+(s*1.5)+2;
		break;
		case 74:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 75:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 76:
		d+=(7*s)+(s*1.5)+2;
		if(szCapture[k+1]==84) d=d-s;
		if(szCapture[k+1]==86) d=d-s;
		if(szCapture[k+1]==87) d=d-s;
		if(szCapture[k+1]==89) d=d-(s*2);
		break;
		case 77:
		d+=(10*s)+(s*1.5)+2;
		break;
		case 78:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 79:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 80:
		d+=(8*s)+(s*1.5)+2;
		if(szCapture[k+1]==65) d=d-s;
		break;
		case 81:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 82:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 83:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 84:
		d+=(9*s)+(s*1.5)+2;
		if(szCapture[k+1]==65) d=d-s;
		if(szCapture[k+1]==74) d=d-s;
		break;
		case 85:
		d+=(8*s)+(s*1.5)+2;
		break;
		case 86:
		if(k==0) d+=1;
		d+=(9*s)+(s*1.5)+2;
		if(szCapture[k+1]==65) d=d-s;
		break;
		case 87:
		if(k==0) d+=1;
		d+=(13*s)+(s*1.5)+2;
		if(szCapture[k+1]==65) d=d-s;
		break;
		case 88:
		d+=(9*s)+(s*1.5)+2;
		break;
		case 89:
		d+=(10*s)+(s*1.5)+2;
		if(szCapture[k+1]==65) d=d-s;
		break;
		case 90:
		d+=(7*s)+(s*1.5)+2;
		break;
		default:
		d+=(8*s)+(s*1.5)+2;
		break;
		}
	}
	return(d);
}

