/* MathEng.h, the math engine for LCARS 24 Math Service

	First load input to the string MathInput[1], then call the
	function LcMath(). Output goes to the string MathOutput.
	If there is a problem, output first goes to ErrMessage but
	is then copied to MathOutput for easy programming of the
	side of the calling interface.

	Adapted from a program whose history is described below
*/

/*
* By Dale Holt	 3945 Vondelpark Place, Colorado Springs, CO 80907
* AmigaBasic. November 1986, March 1991
* Conversion to C.  May 1993
* Fixed fmtcomma.  23 Oct 1993  (memmove ...l -> l+1)
* Fixed checks for 'e' and 'E' for scientific notation.  7 Mar 1994
* Added pi as a constant.  2 Sept 1994
* Fixed unary - and + after =.  6 Feb 1995
* Further unary - and + checks.  23 Aug 1995
* Remove spaces, better unary - check.  6 Oct 1997
* Fix handling of [,],{,} and remove terminating decimal point.  20 May 1999
* Fix handling of [,],{,} and add option for no comma in output.  7 Jul 1999
* Implement angles in degrees instead of radians.  22 Jan 2004
*/

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#ifndef MATHENG_H
#define MATHENG_H


#include "lcars24.h"


#ifndef max
#define max(A, B) ((A) > (B) ? (A) : (B))
#endif
#ifndef min
#define min(A, B) ((A) > (B) ? (B) : (A))
#endif

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#define DEGREES * M_PI / 180.0	/* For degrees */
/* #define DEGREES */ /* For radians */

char *MeStrTrim(char *string);
char *MeStrLower(char *string);
void MeFmtComma(char *value, double number, int comma);
int MeCompile(char *infunct, int *postfix_array, double *constant,
			int *use_x, int *use_y, int *use_z, int *use_equal,
			int *stack);
double MeEvaluate(int *postfix, double *constant, int numops,
					 double xpt, double ypt, double zpt, int stack_size);

int LcMath();

#endif

