/* 12/13/09 */
/* Headline.c, various routines for 14-, 19-, 21-, and 26-point LCARS fonts */


/*  To output LCARS fonts in a choice of three sizes, regardless
    of background and foreground colors, for use in Web-page
    rendering, with ASCII 32 to 126 supported, and the tight
    antialiasing required for LCARS fonts.

    Font data will be taken from Font19, Font21, and Scorpio.
    For string lengths, use the StrLenXX functions for those font.
    Those functions are now included in this file.

    For Web-page headlines:
    int Headline19(BITMAP *bmp, int x,int y, int Hue, char *Str)
    int Headline21(BITMAP *bmp, int x,int y, int Hue, char *Str)
    int Headline26(BITMAP *bmp, int x,int y, int Hue, char *Str)
*/

/* 	The follow three font functions are old and now take their
	functionality from the three newer functions above but still
	appear in many LCARS 24 programs. The three Headline functions
	are clones of these older functions but with double buffering
	and more the flexible color mixing required for use in Web-page
	rendering, where they replace usage of TrueType fonts in order
	to render headlines in Star Trek LCARS fonts.
	Their original functions for loading and finding string lengths
	still support usage of the above Headline functions and have
	been moved to this file.
	All antialiasing is tighter than with TrueType, since the method
	used in TrueType can't produce proper LCARS fonts.
*/

/* 	Font19: 6 x 19 bitmapped, anitaliased, and shadow-thickened
	Starfleet font with upper- and lowercase, etc., only for an
	LCARS color against a black background
	Usage:	PutsFont19(int x,int y, int Hue, char *Str)
			(where Hue is the foreground color and the background
			color is black)
			StrLenFont19(char *Str)
			The font data should be loaded at the beginning of the
			program, by calling LoadFont19(), but after initializing
			the graphics.
*/
/* 	Font21: 6 x 21 bitmapped, anitaliased, and shadow-thickened
	Starfleet font with upper- and lowercase, etc., only for an
	LCARS color against a black background
	Usage:	PutsFont21(int x,int y, int Hue, char *Str)
			(where Hue is the foreground color and the background
			color is black)
			StrLenFont21(char *Str)
			The font data should be loaded at the beginning of the
			program, by calling LoadFont21().
*/
/* 	Scorpio: 8 x 26 bitmapped, anitaliased Starfleet font
	with upper- and lowercase, etc.
	Usage:  PutsScorpio( x, y,  color, *string);
	(although it is called in the programs, the antialiasing color is no
	longer used but produced elsewhere, since this old font routine now
	takes is functionality from the newer Headline26() function.

*/


#include "headline.h"


int DiskWakeup()
{
/* Do nothing but cause a sleeping disk to wake up, used to delay
   program exit until the disk is active, thus avoiding a black
   screen when returning to LCARS 24 Standby
*/
	PACKFILE *Fp;

	SetCurrentFile("\\SYSTEM\\FONTS\\font21.sff");
	Fp = pack_fopen(CurrentFile, "rb");
	pack_fclose( Fp );
	return(0);
}
int LoadFont14()
{
	long z;
	PACKFILE *Fp;

	memset(Font14, (null), 12544);
	SetCurrentFile("\\SYSTEM\\FONTS\\font14.sff");
	Fp = pack_fopen(CurrentFile, "rb");
	if (Fp == NULL) {
		FontLoadError(CurrentFile);
		exit(0);
	}
	for(z = 0; z < 12544; ++z ) Font14[z] = pack_getc(Fp);
	pack_fclose( Fp );
	return(0);
}
int StrLenFont14(char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	size_t j;

	pos = 1;
	j = strlen(Str);
	strcpy(Capture, Str);
	if( Capture[j-1] <= 32 ) Capture[j-1] = 32;
	if( Capture[j] <= 32 ) Capture[j] = 32;
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		i = Capture[k];
		if( Capture[k] == 9 ) pos = (40 + ((pos/40)*40) );
			else pos += Font14[i]-65;
	}
	return(pos);
}
int LoadFont19()
{
	long z;
	PACKFILE *Fp;

	memset(Font19, (null), 12544);
	SetCurrentFile("\\SYSTEM\\FONTS\\font19.sff");
	Fp = pack_fopen(CurrentFile, "rb");
	if (Fp == NULL) {
		FontLoadError(CurrentFile);
		exit(0);
	}
	for(z = 0; z < 12544; ++z ) Font19[z] = pack_getc(Fp);
	pack_fclose( Fp );
	return(0);
}
int StrLenFont19(char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	size_t j;

	pos = 1;
	j = strlen(Str);
	strcpy(Capture, Str);
	if( Capture[j-1] <= 32 ) Capture[j-1] = 32;
	if( Capture[j] <= 32 ) Capture[j] = 32;
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		i = Capture[k];
		if( Capture[k] == 9 ) pos = (40 + ((pos/40)*40) );
			else pos += Font19[i]-65;
	}
	return(pos);
}
int LoadFont21()
{
	long z;
	PACKFILE *Fp;

	memset(Font21, (null), 12544);
	SetCurrentFile("\\SYSTEM\\FONTS\\font21.sff");
	Fp = pack_fopen(CurrentFile, "rb");
	if (Fp == NULL) {
		FontLoadError(CurrentFile);
		exit(0);
	}
	for(z = 0; z < 12544; ++z ) Font21[z] = pack_getc(Fp);
	pack_fclose( Fp );
	return(0);
}
int StrLenFont21(char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos=1;
	size_t j;

	j = strlen(Str);
	strcpy(Capture, Str);
	if( Capture[j-1] <= 32 ) Capture[j-1] = 32;
	if( Capture[j] <= 32 ) Capture[j] = 32;
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		i = Capture[k];
		if( Capture[k] == 9 ) pos = (40 + ((pos/40)*40) );
			else pos += Font21[i]-65;
	}
	return(pos);
}

int LoadScorpioFont()
{
	long z;
	PACKFILE *Fp;

	memset(ScorpioFont, (null), 12544);
	SetCurrentFile("\\SYSTEM\\FONTS\\scorpio.sff");
	Fp = pack_fopen(CurrentFile, "rb");
	if (Fp == NULL) {
		FontLoadError(CurrentFile);
		exit(0);
	}
	for(z = 0; z < 12544; ++z ) ScorpioFont[z] = pack_getc(Fp);
	pack_fclose( Fp );
	return(0);
}
int StrLenScorpio(char *cStr)
{
	char Capture[80];
	int i;
	int k;
	int pos;
	size_t j;

	pos = 1;
	j = strlen(cStr);
	strcpy(Capture, cStr);
	if( Capture[j-1] <= 32 ) Capture[j-1] = 32;
	if( Capture[j] <= 32 ) Capture[j] = 32;
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		i = Capture[k];
		pos += ScorpioFont[i]-65;
	}
	return(pos);
}
int FindShadow(int Fc, int Bc)
{
	int Result;
	int fr, fb, fg, br, bb, bg;
	int r,g,b;

	fr=getr(Fc);
	fb=getb(Fc);
	fg=getg(Fc);
	br=getr(Bc);
	bb=getb(Bc);
	bg=getg(Bc);

	r=(fr+fr+fr+br)/4;
	b=(fb+fb+fb+bb)/4;
	g=(fg+fg+fg+bg)/4;

	Result=makecol( r,g,b );
	return(Result);
}
int FindStrongShadow(int Fc, int Bc)
{
	int Result;
	int fr, fb, fg, br, bb, bg;
	int r,g,b;

	fr=getr(Fc);
	fb=getb(Fc);
	fg=getg(Fc);
	br=getr(Bc);
	bb=getb(Bc);
	bg=getg(Bc);

	r=(fr+fr+fr+br)/4;
	b=(fb+fb+fb+bb)/4;
	g=(fg+fg+fg+bg)/4;

	Result=makecol( r,g,b );
	return(Result);
}
int HeadlineFadeUp(BITMAP *bmp,int x, int y, int Color, int range)
{
	int r1,b1,g1,r2,b2,g2,z;
	int dr,db,dg;
	int diffR, diffG, diffB;
	int fade, fadeR, fadeG, fadeB;

	dr=r1=getr(Color);
	dg=g1=getg(Color);
	db=b1=getb(Color);
	r2=getr(BackgroundColor);
	g2=getg(BackgroundColor);
	b2=getb(BackgroundColor);

	diffR=r1-r2;
	diffG=g1-g2;
	diffB=b1-b2;
	fade=range*1.25;
	fadeR=diffR/fade;
	fadeG=diffG/fade;
	fadeB=diffB/fade;

	for( z=1; z <= range; ++z ) {
		dr -= fadeR;
		dg -= fadeG;
		db -= fadeB;
		putpixel(bmp,x,y+1-z,makecol(dr,dg,db));
	}
	return(0);
}
int HeadlineFadeDown(BITMAP *bmp,int x, int y, int Color, int range)
{
	int r1,b1,g1,r2,b2,g2,z;
	int dr,db,dg;
	int diffR, diffG, diffB;
	int fade, fadeR, fadeG, fadeB;

	dr=r1=getr(Color);
	dg=g1=getg(Color);
	db=b1=getb(Color);
	r2=getr(BackgroundColor);
	g2=getg(BackgroundColor);
	b2=getb(BackgroundColor);

	diffR=r1-r2;
	diffG=g1-g2;
	diffB=b1-b2;

	fade=range*1.25;
	fadeR=diffR/fade;
	fadeG=diffG/fade;
	fadeB=diffB/fade;

	for( z=1; z <= range; ++z ) {
		dr -= fadeR;
		dg -= fadeG;
		db -= fadeB;
		putpixel(bmp,x,y-1+z,makecol(dr,dg,db));
	}
	return(0);
}
int SmoothHeadline19(BITMAP *bmp, int TargetChar, int x, int y, int Hue)
{  /* fine antialiasing for a few characters */
	int extra;
		switch( TargetChar )
		{
			case 50: /* 2 (a patch) */
				putpixel(bmp,x,y+6,BackgroundColor);
				putpixel(bmp,x+1,y+6,BackgroundColor);
				putpixel(bmp,x+2,y+6,BackgroundColor);
				break;
			case 65: /* A */
				HeadlineFadeUp(bmp,x,y+18,Hue,10);
				HeadlineFadeUp(bmp,x+1,y+9,Hue,10);
				HeadlineFadeUp(bmp,x+6,y+18,Hue,10);
				HeadlineFadeUp(bmp,x+5,y+9,Hue,10);
				HeadlineFadeDown(bmp,x+2,y+9,Hue,10);
				HeadlineFadeDown(bmp,x+4,y+9,Hue,10);
				break;
			case 77: /* M */
				HeadlineFadeDown(bmp,x+3,y+8,Hue,9);
				HeadlineFadeDown(bmp,x+7,y+8,Hue,9);
				HeadlineFadeUp(bmp,x+4,y+10,Hue,11);
				HeadlineFadeUp(bmp,x+6,y+10,Hue,11);
				break;
			case 78: /* N */
				HeadlineFadeUp(bmp,x+4,y+8,Hue,9);
				HeadlineFadeDown(bmp,x+4,y+9,Hue,10);
				break;
			case 86: /* V */
				HeadlineFadeDown(bmp,x,y,Hue,9);
				HeadlineFadeDown(bmp,x+1,y+9,Hue,10);
				HeadlineFadeUp(bmp,x+2,y+10,Hue,11);
				HeadlineFadeUp(bmp,x+4,y+10,Hue,11);
				HeadlineFadeDown(bmp,x+6,y,Hue,9);
				HeadlineFadeDown(bmp,x+5,y+9,Hue,10);
				break;
			case 87: /* W */
				HeadlineFadeDown(bmp,x,y,Hue,9);
				HeadlineFadeDown(bmp,x+1,y+9,Hue,10);
				HeadlineFadeUp(bmp,x+2,y+10,Hue,11);
				HeadlineFadeDown(bmp,x+4,y+10,Hue,9);
				HeadlineFadeDown(bmp,x+6,y+10,Hue,9);
				HeadlineFadeUp(bmp,x+8,y+10,Hue,11);
				HeadlineFadeDown(bmp,x+9,y+9,Hue,10);
				HeadlineFadeDown(bmp,x+10,y,Hue,9);
				break;
			case 88: /* X */
				HeadlineFadeDown(bmp,x,y,Hue,5);
				HeadlineFadeDown(bmp,x+1,y+5,Hue,5);
				HeadlineFadeUp(bmp,x,y+18,Hue,5);
				HeadlineFadeUp(bmp,x+1,y+13,Hue,5);

				HeadlineFadeUp(bmp,x+3,y+4,Hue,5);
				HeadlineFadeUp(bmp,x+5,y+4,Hue,5);
				HeadlineFadeUp(bmp,x+4,y+7,Hue,3);

				HeadlineFadeDown(bmp,x+3,y+14,Hue,5);
				HeadlineFadeDown(bmp,x+5,y+14,Hue,5);
				HeadlineFadeDown(bmp,x+4,y+11,Hue,3);

				HeadlineFadeDown(bmp,x+8,y,Hue,5);
				HeadlineFadeDown(bmp,x+7,y+5,Hue,5);
				HeadlineFadeUp(bmp,x+8,y+18,Hue,5);
				HeadlineFadeUp(bmp,x+7,y+13,Hue,5);
				break;
			case 89: /* Y */
				HeadlineFadeDown(bmp,x,y,Hue,5);
				HeadlineFadeDown(bmp,x+1,y+4,Hue,5);
				HeadlineFadeDown(bmp,x+2,y+8,Hue,5);

				HeadlineFadeUp(bmp,x+2,y+3,Hue,4);
				HeadlineFadeUp(bmp,x+3,y+7,Hue,3);
				HeadlineFadeUp(bmp,x+4,y+7,Hue,3);
				HeadlineFadeUp(bmp,x+5,y+3,Hue,4);
				HeadlineFadeDown(bmp,x+7,y,Hue,5);
				HeadlineFadeDown(bmp,x+6,y+4,Hue,5);

				HeadlineFadeDown(bmp,x+5,y+8,Hue,5);
				extra=getpixel(bmp,x+5,y+11);
				vline(bmp,x+2,y+12,y+18,extra);
				vline(bmp,x+5,y+12,y+18,extra);
				break;
			case 90: /* Z */
				HeadlineFadeUp(bmp,x+2,y+7,Hue,6);
				HeadlineFadeUp(bmp,x+1,y+11,Hue,6);
				HeadlineFadeUp(bmp,x,y+17,Hue,6);

				HeadlineFadeDown(bmp,x+4,y+2,Hue,6);

				HeadlineFadeDown(bmp,x+3,y+7,Hue,6);
				HeadlineFadeDown(bmp,x+2,y+12,Hue,5);
				break;
			case 118: /* v */
			case 121: /* y (same as v for this process) */
				HeadlineFadeDown(bmp,x,y+5,Hue,5);
				HeadlineFadeDown(bmp,x+1,y+10,Hue,5);
				HeadlineFadeDown(bmp,x+2,y+15,Hue,4);
				HeadlineFadeUp(bmp,x+2,y+7,Hue,4);
				HeadlineFadeUp(bmp,x+3,y+12,Hue,5);
				HeadlineFadeUp(bmp,x+4,y+12,Hue,5);
				HeadlineFadeUp(bmp,x+5,y+7,Hue,4);
				HeadlineFadeDown(bmp,x+7,y+5,Hue,5);
				HeadlineFadeDown(bmp,x+6,y+10,Hue,5);
				HeadlineFadeDown(bmp,x+5,y+15,Hue,4);
				break;
			case 119: /* w */
				HeadlineFadeDown(bmp,x,y+4,Hue,8);
				HeadlineFadeDown(bmp,x+1,y+13,Hue,5);
				HeadlineFadeUp(bmp,x+2,y+12,Hue,9);

				HeadlineFadeDown(bmp,x+4,y+12,Hue,6);
				HeadlineFadeDown(bmp,x+6,y+12,Hue,6);

				HeadlineFadeDown(bmp,x+10,y+4,Hue,9);
				HeadlineFadeDown(bmp,x+9,y+13,Hue,5);
				HeadlineFadeUp(bmp,x+8,y+12,Hue,8);
				break;
			case 120: /* x */
				HeadlineFadeDown(bmp,x,y+4,Hue,4);
				HeadlineFadeDown(bmp,x+1,y+8,Hue,4);
				HeadlineFadeUp(bmp,x+1,y+14,Hue,4);
				HeadlineFadeUp(bmp,x,y+18,Hue,4);

				HeadlineFadeUp(bmp,x+3,y+7,Hue,4);
				HeadlineFadeUp(bmp,x+5,y+7,Hue,4);
				HeadlineFadeUp(bmp,x+4,y+10,Hue,3);
				HeadlineFadeDown(bmp,x+4,y+12,Hue,3);
				HeadlineFadeDown(bmp,x+3,y+15,Hue,4);
				HeadlineFadeDown(bmp,x+5,y+15,Hue,4);

				HeadlineFadeDown(bmp,x+8,y+4,Hue,4);
				HeadlineFadeDown(bmp,x+7,y+8,Hue,4);
				HeadlineFadeUp(bmp,x+7,y+14,Hue,4);
				HeadlineFadeUp(bmp,x+8,y+18,Hue,4);
				break;
			case 122: /* z */
				HeadlineFadeUp(bmp,x+2,y+9,Hue,4);
				HeadlineFadeUp(bmp,x+1,y+13,Hue,4);
				HeadlineFadeUp(bmp,x+0,y+16,Hue,3);
				HeadlineFadeDown(bmp,x+4,y+6,Hue,4);
				HeadlineFadeDown(bmp,x+3,y+10,Hue,3);
				HeadlineFadeDown(bmp,x+2,y+14,Hue,3);
				break;
			default: break;
		}
	return(0);
}
int StripeHeadline19(BITMAP *bmp, int TargetChar, int x, int y, int Hue)
{ /* to make characters look half a pixel thicker */
	int a,b;
	long z;
	unsigned char i;
	static unsigned char BitVal[] = { 128,64,32,16,8,4,2,1 };

	if( TargetChar <= 32 ) return(1);
	z=6272+((TargetChar-30)*64);
	for(b=0; b<25; ++b) {
		for(a=0; a<8; ++a) {
			i = Font19[b+z] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x, b+y, Hue);
		}
	}
	for(b=0; b<25; ++b) {
		for(a=0; a<8; ++a) {
			i = Font19[b+z+32] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x+8, b+y, Hue);
		}
	}
	return(0);
}
int BlitHeadline19(BITMAP *bmp, int TargetChar, int x, int y, int Hue)
{
	int a,b;
	int z;
	unsigned char i;
	static unsigned char BitVal[] = { 128,64,32,16,8,4,2,1 };

	if( TargetChar <= 32 ) return(1);
	z=(TargetChar-30)*64;
	for(b=0; b<25; ++b) {
		for(a=0; a<8; ++a) {
			i = Font19[b+z] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x, b+y, Hue);
		}
	}
	for(b=0; b<25; ++b) {
		for(a=0; a<8; ++a) {
			i = Font19[b+z+32] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x+8, b+y, Hue);
		}
	}
	return(0);
}

int Headline19(BITMAP *bmp, int x,int y, int Hue, char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	size_t j;
	int tabpos;
	unsigned int t;

	Shadow=FindShadow(Hue, BackgroundColor);
	t=32;
	pos = x;
	j = strlen(Str);
	strcpy(Capture, Str);
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		if( Capture[k] < 32 && Capture[k] != 9 ) i = (t);
		else i = Capture[k];
		if(y>0 && Capture[k] != 9 ) {
			StripeHeadline19(bmp,i,pos,y,Shadow);
			SmoothHeadline19(bmp,i,pos,y,Hue);
			BlitHeadline19(bmp,i,pos,y,Hue);
		}
		if( Capture[k] == 9 ) {
			tabpos=0;
			while( pos-x >= tabpos) tabpos += 40;
			pos = tabpos + x;
		} else pos += Font19[i]-65;
	}
	return(0);
}
int SmoothHeadline21(BITMAP *bmp,int TargetChar, int x, int y, int Hue)
{  /* fine antialiasing for a few characters */
	int extra;
		switch( TargetChar )
		{
			case 50: /* 2 (a patch) */
				putpixel(bmp,x,y+7,BackgroundColor);
				putpixel(bmp,x+1,y+7,BackgroundColor);
				break;
			case 65: /* A */
				HeadlineFadeUp(bmp,x-1,y+20,Shadow,7);
				HeadlineFadeUp(bmp,x,y+20,Hue,14);
				HeadlineFadeUp(bmp,x+1,y+10,Hue,11);
				HeadlineFadeUp(bmp,x+6,y+20,Hue,14);
				HeadlineFadeUp(bmp,x+7,y+20,Shadow,7);
				HeadlineFadeUp(bmp,x+5,y+10,Hue,11);
				HeadlineFadeDown(bmp,x+2,y+10,Hue,11);
				HeadlineFadeDown(bmp,x+4,y+10,Hue,11);
				break;
			case 77: /* M */
				HeadlineFadeDown(bmp,x+3,y+8,Hue,9);
				HeadlineFadeDown(bmp,x+7,y+8,Hue,9);
				HeadlineFadeUp(bmp,x+4,y+10,Hue,11);
				HeadlineFadeUp(bmp,x+6,y+10,Hue,11);
				break;
			case 78: /* N */
				HeadlineFadeUp(bmp,x+4,y+8,Hue,9);
				HeadlineFadeDown(bmp,x+4,y+11,Hue,10);
				break;
			case 86: /* V */
				HeadlineFadeDown(bmp,x,y,Hue,11);
				HeadlineFadeDown(bmp,x+1,y+11,Hue,10);
				HeadlineFadeUp(bmp,x+2,y+10,Hue,11);
				HeadlineFadeUp(bmp,x+4,y+10,Hue,11);
				HeadlineFadeDown(bmp,x+6,y,Hue,11);
				HeadlineFadeDown(bmp,x+5,y+11,Hue,10);
				break;
			case 87: /* W */
				HeadlineFadeDown(bmp,x,y,Hue,11);
				HeadlineFadeDown(bmp,x+1,y+11,Hue,10);
				HeadlineFadeUp(bmp,x+2,y+10,Hue,11);

				HeadlineFadeDown(bmp,x+4,y+10,Hue,11);
				HeadlineFadeDown(bmp,x+6,y+10,Hue,11);

				HeadlineFadeUp(bmp,x+8,y+10,Hue,11);
				HeadlineFadeDown(bmp,x+9,y+11,Hue,10);
				HeadlineFadeDown(bmp,x+10,y,Hue,11);
				break;
			case 88: /* X */
				HeadlineFadeDown(bmp,x,y,Hue,6);
				HeadlineFadeDown(bmp,x+1,y+6,Hue,5);
				HeadlineFadeUp(bmp,x,y+20,Hue,6);
				HeadlineFadeUp(bmp,x+1,y+14,Hue,5);

				HeadlineFadeUp(bmp,x+3,y+4,Hue,5);
				HeadlineFadeUp(bmp,x+5,y+4,Hue,5);
				HeadlineFadeUp(bmp,x+4,y+9,Hue,5);

				HeadlineFadeDown(bmp,x+3,y+16,Hue,5);
				HeadlineFadeDown(bmp,x+5,y+16,Hue,5);
				HeadlineFadeDown(bmp,x+4,y+11,Hue,5);

				HeadlineFadeDown(bmp,x+8,y,Hue,6);
				HeadlineFadeDown(bmp,x+7,y+6,Hue,5);
				HeadlineFadeUp(bmp,x+8,y+20,Hue,6);
				HeadlineFadeUp(bmp,x+7,y+14,Hue,5);

				break;
			case 89: /* Y */
				HeadlineFadeDown(bmp,x,y,Hue,5);
				HeadlineFadeDown(bmp,x+1,y+4,Hue,5);
				HeadlineFadeDown(bmp,x+2,y+8,Hue,5);

				HeadlineFadeUp(bmp,x+2,y+3,Hue,4);
				HeadlineFadeUp(bmp,x+3,y+7,Hue,3);
				HeadlineFadeUp(bmp,x+4,y+7,Hue,3);
				HeadlineFadeUp(bmp,x+5,y+3,Hue,4);
				HeadlineFadeDown(bmp,x+7,y,Hue,5);
				HeadlineFadeDown(bmp,x+6,y+4,Hue,5);

				HeadlineFadeDown(bmp,x+5,y+8,Hue,5);
				extra=getpixel(bmp,x+5,y+11); /* 11->10 */
				vline(bmp,x+2,y+12,y+20,extra); /* 12->11 */
				vline(bmp,x+5,y+12,y+20,extra); /* 12->11 */
				break;
			case 90: /* Z */
				HeadlineFadeUp(bmp,x+2,y+7,Hue,6);
				HeadlineFadeUp(bmp,x+1,y+13,Hue,6);
				HeadlineFadeUp(bmp,x,y+19,Hue,6);
				HeadlineFadeDown(bmp,x+4,y+2,Hue,6);
				HeadlineFadeDown(bmp,x+3,y+8,Hue,6);
				HeadlineFadeDown(bmp,x+2,y+14,Hue,5);
				break;
			case 118: /* v */
			case 121: /* y (same as v for this process) */
				HeadlineFadeDown(bmp,x,y+5,Hue,6);
				HeadlineFadeDown(bmp,x+1,y+11,Hue,6);
				HeadlineFadeDown(bmp,x+2,y+17,Hue,4);
				HeadlineFadeUp(bmp,x+2,y+8,Hue,5);
				HeadlineFadeUp(bmp,x+3,y+14,Hue,5);
				HeadlineFadeUp(bmp,x+4,y+14,Hue,5);
				HeadlineFadeUp(bmp,x+5,y+8,Hue,5);
				HeadlineFadeDown(bmp,x+7,y+5,Hue,6);
				HeadlineFadeDown(bmp,x+6,y+11,Hue,6);
				HeadlineFadeDown(bmp,x+5,y+17,Hue,4);
				break;
			case 119: /* w */
				HeadlineFadeDown(bmp,x,y+4,Hue,9);
				HeadlineFadeDown(bmp,x+1,y+13,Hue,8);
				HeadlineFadeUp(bmp,x+2,y+12,Hue,9);

				HeadlineFadeDown(bmp,x+4,y+12,Hue,9);
				HeadlineFadeDown(bmp,x+6,y+12,Hue,9);

				HeadlineFadeDown(bmp,x+10,y+4,Hue,9);
				HeadlineFadeDown(bmp,x+9,y+13,Hue,8);
				HeadlineFadeUp(bmp,x+8,y+12,Hue,9);
				break;
			case 120: /* x */
				HeadlineFadeDown(bmp,x,y+4,Hue,4);
				HeadlineFadeDown(bmp,x+1,y+8,Hue,5);
				HeadlineFadeUp(bmp,x+1,y+16,Hue,5);
				HeadlineFadeUp(bmp,x,y+20,Hue,4);

				HeadlineFadeUp(bmp,x+3,y+7,Hue,4);
				HeadlineFadeUp(bmp,x+5,y+7,Hue,4);
				HeadlineFadeUp(bmp,x+4,y+11,Hue,4);
				HeadlineFadeDown(bmp,x+4,y+13,Hue,4);
				HeadlineFadeDown(bmp,x+3,y+17,Hue,4);
				HeadlineFadeDown(bmp,x+5,y+17,Hue,4);

				HeadlineFadeDown(bmp,x+8,y+4,Hue,4);
				HeadlineFadeDown(bmp,x+7,y+8,Hue,5);
				HeadlineFadeUp(bmp,x+7,y+16,Hue,5);
				HeadlineFadeUp(bmp,x+8,y+20,Hue,4);
				break;
			case 122: /* z */
				HeadlineFadeUp(bmp,x+2,y+10,Hue,5);
				HeadlineFadeUp(bmp,x+1,y+14,Hue,4);
				HeadlineFadeUp(bmp,x+0,y+18,Hue,5);
				HeadlineFadeDown(bmp,x+4,y+6,Hue,5);
				HeadlineFadeDown(bmp,x+3,y+11,Hue,4);
				HeadlineFadeDown(bmp,x+2,y+15,Hue,5);
				break;
			default: break;
		}
	return(0);
}
int StripeHeadline21(BITMAP *bmp,int TargetChar, int x, int y, int Hue)
{ /* to make characters look half a pixel thicker */
	int a,b;
	long z;
	unsigned char i;
	static unsigned char BitVal[] = { 128,64,32,16,8,4,2,1 };

	if( TargetChar <= 32 ) return(1);
	z=6272+((TargetChar-30)*64);
	for(b=0; b<25; ++b) {
		for(a=0; a<8; ++a) {
			i = Font21[b+z] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x, b+y, Hue);
		}
	}
	for(b=0; b<25; ++b) {
		for(a=0; a<8; ++a) {
			i = Font21[b+z+32] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x+8, b+y, Hue);
		}
	}
	return(0);
}
int BlitHeadline21(BITMAP *bmp,int TargetChar, int x, int y, int Hue)
{
	int a,b;
	int z;
	unsigned char i;
	static unsigned char BitVal[] = { 128,64,32,16,8,4,2,1 };

	if( TargetChar <= 32 ) return(1);
	z=(TargetChar-30)*64;
	for(b=0; b<25; ++b) {
		for(a=0; a<8; ++a) {
			i = Font21[b+z] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x, b+y, Hue);
		}
	}
	for(b=0; b<25; ++b) {
		for(a=0; a<8; ++a) {
			i = Font21[b+z+32] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x+8, b+y, Hue);
		}
	}
	return(0);
}
int Headline21(BITMAP *bmp,int x,int y, int Hue, char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	size_t j;
	int tabpos;
	unsigned int t;

	Shadow=FindShadow(Hue, BackgroundColor);
	t=32;
	pos = x;
	j = strlen(Str);
	strcpy(Capture, Str);
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		if( Capture[k] < 32 && Capture[k] != 9 ) i = (t);
		if( Capture[k] > 126 ) return(86);
		else i = Capture[k];
		if(y>0 && Capture[k] != 9 ) {
			StripeHeadline21(bmp,i,pos,y,Shadow);
			SmoothHeadline21(bmp,i,pos,y,Hue);
			BlitHeadline21(bmp,i,pos,y,Hue);
		}
		if( Capture[k] == 9 ) {
			tabpos=0;
			while( pos-x >= tabpos) tabpos += 40;
			pos = tabpos + x;
		} else pos += Font21[i]-65;
	}
	return(0);
}
int SmoothHeadline26(BITMAP *bmp,int TargetChar, int x, int y, int Hue)
{  /* fine antialiasing for a few characters */
		switch( TargetChar )
		{

			case 50: /* 2 */
				HeadlineFadeUp(bmp,x+1,y+21,Hue,4);
				HeadlineFadeUp(bmp,x+2,y+17,Hue,3);
				HeadlineFadeUp(bmp,x+3,y+14,Hue,3);
				HeadlineFadeUp(bmp,x+4,y+11,Hue,3);
				HeadlineFadeUp(bmp,x+5,y+8,Hue,2);

				HeadlineFadeDown(bmp,x+8,y+8,Hue,3);
				HeadlineFadeDown(bmp,x+7,y+11,Hue,3);
				HeadlineFadeDown(bmp,x+6,y+14,Hue,3);
				HeadlineFadeDown(bmp,x+5,y+17,Hue,3);
				HeadlineFadeDown(bmp,x+4,y+20,Hue,4);
				break;
			case 52: /* 4 */
				HeadlineFadeUp(bmp,x,y+20,Hue,6);
				HeadlineFadeUp(bmp,x+1,y+14,Hue,5);
				HeadlineFadeUp(bmp,x+2,y+9,Hue,5);
				HeadlineFadeUp(bmp,x+3,y+4,Hue,5);
				HeadlineFadeDown(bmp,x+3,y+12,Hue,6);
				break;
			case 55: /* 7 */  /* tweaked */
				HeadlineFadeUp(bmp,x+5,y+6,Hue,5);
				HeadlineFadeUp(bmp,x+4,y+11,Hue,5);
				HeadlineFadeUp(bmp,x+3,y+16,Hue,5);
				HeadlineFadeUp(bmp,x+2,y+21,Hue,5);
				HeadlineFadeUp(bmp,x+1,y+26,Hue,5);

				HeadlineFadeDown(bmp,x+9,y,Hue,6);
				HeadlineFadeDown(bmp,x+8,y+5,Hue,6);
				HeadlineFadeDown(bmp,x+7,y+10,Hue,6);
				HeadlineFadeDown(bmp,x+6,y+15,Hue,6);
				HeadlineFadeDown(bmp,x+5,y+20,Hue,6);
				HeadlineFadeDown(bmp,x+4,y+24,Hue,3);
				break;
			case 63: /* ? */
				HeadlineFadeUp(bmp,x+5,y+11,Hue,3);
				HeadlineFadeUp(bmp,x+4,y+14,Hue,3);
				HeadlineFadeUp(bmp,x+3,y+17,Hue,3);
				HeadlineFadeDown(bmp,x+8,y+8,Hue,4);
				HeadlineFadeDown(bmp,x+7,y+12,Hue,3);
				HeadlineFadeDown(bmp,x+6,y+15,Hue,3);
				break;
			case 65: /* A */
				++x;
				HeadlineFadeUp(bmp,x,y+26,Hue,14);
				HeadlineFadeUp(bmp,x+1,y+12,Hue,13);

				HeadlineFadeDown(bmp,x+3,y+13,Hue,14);
				HeadlineFadeDown(bmp,x+5,y+13,Hue,14);

				HeadlineFadeDown(bmp,x+4,y+6,Hue,7);

				HeadlineFadeUp(bmp,x+8,y+26,Hue,14);
				HeadlineFadeUp(bmp,x+7,y+12,Hue,13);
				break;
			case 75: /* K */
				HeadlineFadeUp(bmp,x+4,y+11,Hue,4);
				HeadlineFadeUp(bmp,x+5,y+7,Hue,4);
				HeadlineFadeUp(bmp,x+6,y+3,Hue,4);
				HeadlineFadeDown(bmp,x+4,y+15,Hue,4);
				HeadlineFadeDown(bmp,x+5,y+19,Hue,4);
				HeadlineFadeDown(bmp,x+6,y+23,Hue,4);

				HeadlineFadeDown(bmp,x+9,y,Hue,4);
				HeadlineFadeDown(bmp,x+8,y+4,Hue,4);
				HeadlineFadeDown(bmp,x+7,y+8,Hue,4);
				HeadlineFadeUp(bmp,x+7,y+18,Hue,4);
				HeadlineFadeUp(bmp,x+8,y+22,Hue,4);
				HeadlineFadeUp(bmp,x+9,y+26,Hue,4);
				break;

			case 77: /* M */
				HeadlineFadeUp(bmp,x+5,y+12,Hue,13);
				HeadlineFadeUp(bmp,x+7,y+12,Hue,13);
				break;

			case 78: /* N */
				HeadlineFadeUp(bmp,x+4,y+3,Hue,4);
				HeadlineFadeUp(bmp,x+5,y+7,Hue,4);
				HeadlineFadeUp(bmp,x+6,y+11,Hue,4);
				HeadlineFadeUp(bmp,x+7,y+14,Hue,3);

				HeadlineFadeDown(bmp,x+4,y+12,Hue,3);
				HeadlineFadeDown(bmp,x+5,y+15,Hue,4);
				HeadlineFadeDown(bmp,x+6,y+19,Hue,4);
				HeadlineFadeDown(bmp,x+7,y+23,Hue,4);
				break;
			case 82: /* R */
				putpixel(bmp,x+6,y+26,Shadow);
				putpixel(bmp,x+9,y+26,Shadow);
				break;
			case 83: /* S */
				HeadlineFadeDown(bmp,x+1,y+8,Hue,3);
				HeadlineFadeDown(bmp,x+2,y+11,Hue,2);
				HeadlineFadeDown(bmp,x+3,y+13,Hue,2);
				HeadlineFadeDown(bmp,x+4,y+15,Hue,2);
				HeadlineFadeDown(bmp,x+5,y+17,Hue,2);

				HeadlineFadeUp(bmp,x+4,y+8,Hue,2);
				HeadlineFadeUp(bmp,x+5,y+10,Hue,2);
				HeadlineFadeUp(bmp,x+6,y+12,Hue,2);
				HeadlineFadeUp(bmp,x+7,y+14,Hue,2);
				HeadlineFadeUp(bmp,x+8,y+17,Hue,3);
				break;
			case 86: /* V */
				HeadlineFadeDown(bmp,x,y,Hue,14);
				HeadlineFadeDown(bmp,x+1,y+14,Hue,13);

				HeadlineFadeUp(bmp,x+3,y+13,Hue,14);
				HeadlineFadeUp(bmp,x+5,y+13,Hue,14);
				HeadlineFadeUp(bmp,x+4,y+20,Hue,7);

				HeadlineFadeDown(bmp,x+8,y,Hue,14);
				HeadlineFadeDown(bmp,x+7,y+14,Hue,13);
				break;
			case 87: /* W */
				HeadlineFadeDown(bmp,x,y,Hue,9);
				HeadlineFadeDown(bmp,x+1,y+9,Hue,9);
				HeadlineFadeDown(bmp,x+2,y+18,Hue,9);

				HeadlineFadeUp(bmp,x+3,y+8,Hue,9);
				HeadlineFadeUp(bmp,x+5,y+8,Hue,9);
				HeadlineFadeUp(bmp,x+9,y+8,Hue,9);
				HeadlineFadeUp(bmp,x+11,y+8,Hue,9);

				HeadlineFadeDown(bmp,x+14,y,Hue,9);
				HeadlineFadeDown(bmp,x+13,y+9,Hue,9);
				HeadlineFadeDown(bmp,x+12,y+18,Hue,9);

				HeadlineFadeDown(bmp,x+6,y+18,Hue,9);
				HeadlineFadeDown(bmp,x+8,y+18,Hue,9);

				HeadlineFadeDown(bmp,x+7,y+13,Hue,5);
				break;
			case 88: /* X */
				HeadlineFadeDown(bmp,x,y,Hue,4);
				HeadlineFadeDown(bmp,x+1,y+4,Hue,4);
				HeadlineFadeDown(bmp,x+2,y+8,Hue,4);
				HeadlineFadeUp(bmp,x+2,y+18,Hue,4);
				HeadlineFadeUp(bmp,x+1,y+22,Hue,4);
				HeadlineFadeUp(bmp,x,y+26,Hue,4);

				HeadlineFadeUp(bmp,x+3,y+3,Hue,4);
				HeadlineFadeUp(bmp,x+4,y+7,Hue,4);
				HeadlineFadeUp(bmp,x+5,y+11,Hue,4);
				HeadlineFadeUp(bmp,x+6,y+7,Hue,4);
				HeadlineFadeUp(bmp,x+7,y+3,Hue,4);

				HeadlineFadeDown(bmp,x+3,y+23,Hue,4);
				HeadlineFadeDown(bmp,x+4,y+19,Hue,4);
				HeadlineFadeDown(bmp,x+5,y+15,Hue,4);
				HeadlineFadeDown(bmp,x+6,y+19,Hue,4);
				HeadlineFadeDown(bmp,x+7,y+23,Hue,4);

				HeadlineFadeDown(bmp,x+10,y,Hue,4);
				HeadlineFadeDown(bmp,x+9,y+4,Hue,4);
				HeadlineFadeDown(bmp,x+8,y+8,Hue,4);
				HeadlineFadeUp(bmp,x+8,y+18,Hue,4);
				HeadlineFadeUp(bmp,x+9,y+22,Hue,4);
				HeadlineFadeUp(bmp,x+10,y+26,Hue,4);
				break;
			case 89: /* Y */
				HeadlineFadeDown(bmp,x,y,Hue,4);
				HeadlineFadeDown(bmp,x+1,y+4,Hue,4);
				HeadlineFadeDown(bmp,x+2,y+8,Hue,4);
				HeadlineFadeDown(bmp,x+3,y+12,Hue,4);

				HeadlineFadeUp(bmp,x+3,y+3,Hue,4);
				HeadlineFadeUp(bmp,x+4,y+7,Hue,4);
				HeadlineFadeUp(bmp,x+5,y+11,Hue,4);
				HeadlineFadeUp(bmp,x+6,y+7,Hue,4);
				HeadlineFadeUp(bmp,x+7,y+3,Hue,4);

				HeadlineFadeDown(bmp,x+10,y,Hue,4);
				HeadlineFadeDown(bmp,x+9,y+4,Hue,4);
				HeadlineFadeDown(bmp,x+8,y+8,Hue,4);
				HeadlineFadeDown(bmp,x+7,y+12,Hue,4);
				break;
			case 90: /* Z */
				HeadlineFadeUp(bmp,x+5,y+6,Hue,5);
				HeadlineFadeUp(bmp,x+4,y+11,Hue,5);
				HeadlineFadeUp(bmp,x+3,y+16,Hue,5);
				HeadlineFadeUp(bmp,x+2,y+21,Hue,5);
				HeadlineFadeUp(bmp,x+1,y+26,Hue,5);

				HeadlineFadeDown(bmp,x+9,y,Hue,5);
				HeadlineFadeDown(bmp,x+8,y+5,Hue,5);
				HeadlineFadeDown(bmp,x+7,y+10,Hue,5);
				HeadlineFadeDown(bmp,x+6,y+15,Hue,5);
				HeadlineFadeDown(bmp,x+5,y+20,Hue,5);
				break;
			case 107: /* k */
				HeadlineFadeUp(bmp,x+4,y+13,Hue,4);
				HeadlineFadeUp(bmp,x+5,y+9,Hue,4);
				HeadlineFadeDown(bmp,x+4,y+17,Hue,5);
				HeadlineFadeDown(bmp,x+5,y+22,Hue,5);

				HeadlineFadeDown(bmp,x+8,y+6,Hue,4);
				HeadlineFadeDown(bmp,x+7,y+10,Hue,4);
				HeadlineFadeUp(bmp,x+7,y+21,Hue,5);
				HeadlineFadeUp(bmp,x+8,y+26,Hue,5);
				break;
			case 118: /* v */
			case 121: /* y (same as v for this process) */
				HeadlineFadeDown(bmp,x+1,y+6,Hue,7);
				HeadlineFadeDown(bmp,x+2,y+13,Hue,7);
				HeadlineFadeDown(bmp,x+3,y+20,Hue,7);

				HeadlineFadeUp(bmp,x+4,y+12,Hue,7);
				HeadlineFadeUp(bmp,x+5,y+19,Hue,7);
				HeadlineFadeUp(bmp,x+6,y+12,Hue,7);

				HeadlineFadeDown(bmp,x+9,y+6,Hue,7);
				HeadlineFadeDown(bmp,x+8,y+13,Hue,7);
				HeadlineFadeDown(bmp,x+7,y+20,Hue,7);
				break;
			case 119: /* w */
				HeadlineFadeDown(bmp,x+1,y+6,Hue,7);
				HeadlineFadeDown(bmp,x+2,y+13,Hue,7);
				HeadlineFadeDown(bmp,x+3,y+20,Hue,7);

				HeadlineFadeUp(bmp,x+4,y+12,Hue,7);
				HeadlineFadeUp(bmp,x+5,y+19,Hue,7);
				HeadlineFadeUp(bmp,x+9,y+19,Hue,7);
				HeadlineFadeUp(bmp,x+10,y+12,Hue,7);

				HeadlineFadeDown(bmp,x+6,y+20,Hue,7);
				HeadlineFadeDown(bmp,x+8,y+20,Hue,7);

				HeadlineFadeDown(bmp,x+13,y+6,Hue,7);
				HeadlineFadeDown(bmp,x+12,y+13,Hue,7);
				HeadlineFadeDown(bmp,x+11,y+20,Hue,7);
				break;
			case 120: /* x */
				HeadlineFadeDown(bmp,x+1,y+6,Hue,4);
				HeadlineFadeDown(bmp,x+2,y+11,Hue,4);
				HeadlineFadeUp(bmp,x+2,y+21,Hue,4);
				HeadlineFadeUp(bmp,x+1,y+26,Hue,5);

				HeadlineFadeUp(bmp,x+4,y+9,Hue,4);
				HeadlineFadeUp(bmp,x+5,y+13,Hue,4);
				HeadlineFadeUp(bmp,x+6,y+9,Hue,4);

				HeadlineFadeDown(bmp,x+4,y+23,Hue,4);
				HeadlineFadeDown(bmp,x+5,y+19,Hue,4);
				HeadlineFadeDown(bmp,x+6,y+23,Hue,4);

				HeadlineFadeUp(bmp,x+8,y+21,Hue,4);
				HeadlineFadeDown(bmp,x+9,y+6,Hue,4);
				HeadlineFadeDown(bmp,x+8,y+11,Hue,4);
				HeadlineFadeUp(bmp,x+8,y+21,Hue,4);
				HeadlineFadeUp(bmp,x+9,y+26,Hue,5);
				break;
			case 122: /* z */
				HeadlineFadeUp(bmp,x+5,y+11,Hue,3);
				HeadlineFadeUp(bmp,x+4,y+14,Hue,3);
				HeadlineFadeUp(bmp,x+3,y+17,Hue,3);
				HeadlineFadeUp(bmp,x+2,y+20,Hue,3);
				HeadlineFadeUp(bmp,x+1,y+23,Hue,3);

				HeadlineFadeUp(bmp,x+9,y+6,Hue,3);
				HeadlineFadeUp(bmp,x+8,y+9,Hue,3);
				HeadlineFadeUp(bmp,x+7,y+12,Hue,3);
				HeadlineFadeUp(bmp,x+6,y+15,Hue,3);
				HeadlineFadeUp(bmp,x+5,y+18,Hue,3);
				HeadlineFadeUp(bmp,x+4,y+21,Hue,3);
				break;
			default: break;
		}
	return(0);
}
int StripeHeadline26(BITMAP *bmp,int TargetChar, int x, int y, int Color)
{
	int a,b;
	long z;
	unsigned char i;
	static unsigned char BitVal[] = { 128,64,32,16,8,4,2,1 };

	if( TargetChar <= 32 ) return(0);
	z=6272+((TargetChar-30)*64);
	for(b=0; b<32; ++b) {
		for(a=0; a<8; ++a) {
			i = ScorpioFont[b+z] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x, b+y, Color);
		}
	}
	for(b=0; b<32; ++b) {
		for(a=0; a<8; ++a) {
			i = ScorpioFont[b+z+32] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x+8, b+y, Color);
		}
	}
	return(0);
}
int BlitHeadline26(BITMAP *bmp,int TargetChar, int x, int y, int Color)
{
	int a,b;
	int z;
	unsigned char i;
	static unsigned char BitVal[] = { 128,64,32,16,8,4,2,1 };

	if( TargetChar <= 32 ) return(0);
	z=(TargetChar-30)*64;
	for(b=0; b<32; ++b) {
		for(a=0; a<8; ++a) {
			i = ScorpioFont[b+z] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x, b+y, Color);
		}
	}
	for(b=0; b<32; ++b) {
		for(a=0; a<8; ++a) {
			i = ScorpioFont[b+z+32] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x+8, b+y, Color);
		}
	}
	return(0);
}

int Headline26(BITMAP *bmp,int x,int y, int Hue, char *Str)
{
	char Capture[80];
	int i;
	int k;
	int pos;
	size_t j;
	unsigned int t;

	Shadow=FindShadow(Hue, BackgroundColor);
	t=32;
	pos = x;
	j = strlen(Str);
	strcpy(Capture, Str);
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		if( Capture[k] < 32) i = (t);
		else i = Capture[k];
		if(y>0) {
			StripeHeadline26(bmp,i,pos,y,Shadow);
			SmoothHeadline26(bmp,i,pos,y,Hue);
			BlitHeadline26(bmp,i,pos,y,Hue);
		}
		pos += ScorpioFont[i]-65;
	}
	return(0);
}
int BlitHeadline14(BITMAP *bmp, int TargetChar, int x, int y, int Hue)
{
	int a,b;
	int z;
	unsigned char i;
	static unsigned char BitVal[] = { 128,64,32,16,8,4,2,1 };

	if( TargetChar <= 32 ) return(1);
	z=(TargetChar-30)*64;
	for(b=0; b<18; ++b) {
		for(a=0; a<8; ++a) {
			i = Font14[b+z] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x, b+y, Hue);
		}
	}
	for(b=0; b<18; ++b) {
		for(a=0; a<8; ++a) {
			i = Font14[b+z+32] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x+8, b+y, Hue);
		}
	}
	return(0);
}

int SmoothHeadline14(BITMAP *bmp, int TargetChar, int x, int y, int Hue)
{  /* fine antialiasing for a few characters */
	int a,b;

		switch( TargetChar )
		{

			case 37: /* percent sign */
				putpixel(bmp, x,y+11, ac4);
				putpixel(bmp, x,y+12, ac3);
				putpixel(bmp, x+1,y+9, ac4);
				putpixel(bmp, x+1,y+10, ac3);
				putpixel(bmp, x+1,y+13, ac3);
				putpixel(bmp, x+2,y+7, ac4);
				putpixel(bmp, x+2,y+8, ac3);
				putpixel(bmp, x+2,y+11, ac3);
				putpixel(bmp, x+2,y+12, ac4);
				putpixel(bmp, x+3,y+6, ac3);
				putpixel(bmp, x+4,y+7, ac3);
				putpixel(bmp, x+5,y+1, ac4);
				putpixel(bmp, x+5,y+2, ac3);
				putpixel(bmp, x+5,y+5, ac3);
				putpixel(bmp, x+5,y+6, ac4);
				putpixel(bmp, x+6,y, ac3);
				putpixel(bmp, x+6,y+3, ac3);
				putpixel(bmp, x+6,y+4, ac4);
				putpixel(bmp, x+7,y+1, ac3);
				putpixel(bmp, x+7,y+2, ac4);
				break;
			case 38: /* ampersand */
				putpixel(bmp, x,y+7, ac4);
				putpixel(bmp, x,y+8, ac3);
				putpixel(bmp, x,y+12, ac3);
				putpixel(bmp, x+1,y+6, ac3);
				putpixel(bmp, x+2,y+8, ac3);
				vline(bmp, x+2,y+9,y+10,ac4);
				putpixel(bmp, x+2,y+11, ac3);
				putpixel(bmp, x+3,y+2, ac3);
				putpixel(bmp, x+3,y+8, ac3);
				putpixel(bmp, x+3,y+11, ac3);
				putpixel(bmp, x+5,y+6, ac3);
				putpixel(bmp, x+5,y+7, ac4);
				putpixel(bmp, x+6,y+10, ac3);
				putpixel(bmp, x+7,y+8, ac3);
				putpixel(bmp, x+7,y+9, ac4);
				break;
			case 40: /* opening parenthesis */
				vline(bmp, x,y+1,y+2,ac4);
				putpixel(bmp, x,y+3, ac3);
				putpixel(bmp, x,y+10, ac3);
				vline(bmp, x,y+11,y+12,ac4);
				putpixel(bmp, x+1,y, ac4);
				putpixel(bmp, x+1,y+1, ac3);
				putpixel(bmp, x+1,y+12, ac3);
				putpixel(bmp, x+1,y+13, ac4);
				putpixel(bmp, x+2,y+3, ac3);
				putpixel(bmp, x+2,y+4, ac4);
				putpixel(bmp, x+2,y+9, ac4);
				putpixel(bmp, x+2,y+10, ac3);
				putpixel(bmp, x+3,y+2, ac4);
				putpixel(bmp, x+3,y+11, ac4);
				break;
			case 41: /* closing parenthesis */
				vline(bmp, x+3,y+1,y+2,ac4);
				putpixel(bmp, x+3,y+3, ac3);
				putpixel(bmp, x+3,y+10, ac3);
				vline(bmp, x+3,y+11,y+12,ac4);
				putpixel(bmp, x+2,y, ac4);
				putpixel(bmp, x+2,y+1, ac3);
				putpixel(bmp, x+2,y+12, ac3);
				putpixel(bmp, x+2,y+13, ac4);
				putpixel(bmp, x+1,y+3, ac3);
				putpixel(bmp, x+1,y+4, ac4);
				putpixel(bmp, x+1,y+9, ac4);
				putpixel(bmp, x+1,y+10, ac3);
				putpixel(bmp, x,y+2, ac4);
				putpixel(bmp, x,y+11, ac4);
				break;
			case 47: /* slash */
				b=12;
				for(a=0; a<=6; ++a) {
					putpixel(bmp, x-1+a,y+1+b, ac3);
					putpixel(bmp, x-1+a,y+b, ac4);
					putpixel(bmp, x+1+a,y+b, ac3);
					putpixel(bmp, x+1+a,y+1+b, ac4);
					b-=2;
				}
				break;
			case 45: /* hyphen */
				hline(bmp,x,y+8,x+3,ac3);
				break;
			case 44: /* comma */
			case 46: /* period */
				hline(bmp, x,y+11,x+1, ac3);
				break;
			case 58: /* colon */
			case 59: /* semicolon */
				hline(bmp, x,y+5,x+1, ac3);
				hline(bmp, x,y+11,x+1, ac3);
				break;
			case 49: /* 1 */
				putpixel(bmp, x+1,y+1, ac4);
/*				putpixel(bmp, x+1,y+4, ac3);    */
				putpixel(bmp, x+2,y, ac3);
				putpixel(bmp, x+2,y+1, ac3); /* was ac1 */
				break;
			case 50: /* 2 */
				putpixel(bmp, x,y+9, ac4);
				putpixel(bmp, x,y+10, ac3);
				putpixel(bmp, x+1,y+7, ac4);
/*				putpixel(bmp, x+2,y+2, ac3);	*/
				putpixel(bmp, x+2,y+5, ac4);
				putpixel(bmp, x+2,y+9, ac3);
				putpixel(bmp, x+2,y+10, ac4);
				putpixel(bmp, x+3,y+7, ac3);
				putpixel(bmp, x+3,y+8, ac4);
				putpixel(bmp, x+4,y+5, ac4);
/*				hline(bmp, x+2,y+11,x+4,ac3);	*/
				break;
			case 52: /* 4 */
/*				hline(bmp, x,y+10,x+5,ac3);	*/
				putpixel(bmp, x,y+6, ac4);
				putpixel(bmp, x,y+7, ac3);
				putpixel(bmp, x+1,y+3, ac4);
				putpixel(bmp, x+1,y+4, ac3);
				vline(bmp, x+2,y,y+1,ac4);
				vline(bmp, x+2,y+2,y+6,ac3);
				break;
			case 53: /* 5 */
				putpixel(bmp, x+2,y+5, ac4);
				putpixel(bmp, x+2,y+7, ac4);
				putpixel(bmp, x+3,y+5, ac3);
				putpixel(bmp, x+4,y+6, ac4);
/*				hline(bmp, x+2,y+2,x+4, ac3);	*/
/*				putpixel(bmp, x+2,y+11, ac3);	*/
				break;
			case 54: /* 6 */
				putpixel(bmp, x+2,y+5, ac4);
				putpixel(bmp, x+2,y+7, ac4);
				putpixel(bmp, x+3,y+5, ac3);
				putpixel(bmp, x+4,y+6, ac4);

/*				putpixel(bmp, x+2,y+2, ac3);	*/
/*				putpixel(bmp, x+2,y+11, ac3);	*/
				break;
			case 55: /* 7 */
				if(fc==BLACK) {
					/* left side */
					FontFadeDown(bmp,x,y+10,bc,4);
					FontFadeDown(bmp,x+1,y+6,bc,4);
					FontFadeDown(bmp,x+2,y+2,bc,4);
					/* right side */
					FontFadeUp(bmp,x+2,y+13,bc,4);
					FontFadeUp(bmp,x+3,y+9,bc,4);
					FontFadeUp(bmp,x+4,y+5,bc,4);
				} else {
					/* left side */
					FontFadeUp(bmp,x,y+13,fc,4);
					FontFadeUp(bmp,x+1,y+9,fc,4);
					FontFadeUp(bmp,x+2,y+5,fc,4);
					/* right side */
					FontFadeDown(bmp,x+2,y+10,fc,4);
					FontFadeDown(bmp,x+3,y+6,fc,4);
					FontFadeDown(bmp,x+4,y+2,fc,4);
				}
				break;
			case 57: /* 9 */
				putpixel(bmp, x,y+7, ac4);
				putpixel(bmp, x+1,y+8, ac3);
				putpixel(bmp, x+2,y+6, ac3);
				putpixel(bmp, x+2,y+8, ac4);

/*				putpixel(bmp, x+2,y+2, ac3);	*/
/*				putpixel(bmp, x+2,y+11, ac3);   */
				break;
			case 65: /* A */
				if(fc==BLACK) {
					FontFadeDown(bmp,x,y,bc,14);
					FontFadeDown(bmp,x+4,y,bc,14);
					FontFadeUp(bmp,x+2,y+13,bc,14);
				} else {
					FontFadeUp(bmp,x,y+13,fc,14);
					FontFadeUp(bmp,x+4,y+13,fc,14);
					FontFadeDown(bmp,x+2,y,fc,14);
				}
/*
				vline(bmp,x+2,y+8,y+9,fc);
				putpixel(bmp, x+1,y, ac3);
				putpixel(bmp, x+2,y, fc);
				putpixel(bmp, x+3,y, ac3);
*/
				break;
			case 66: /* B */
/*				putpixel(bmp, x+2,y+2, ac3); 	*/
/*				putpixel(bmp, x+2,y+11, ac3);	*/
				putpixel(bmp, x+4,y+5, ac4);
				putpixel(bmp, x+4,y+6, ac4);
				break;
			case 48: /* zero */
			case 51: /* 3 */
			case 56: /* 8 */
			case 67: /* C */
			case 68: /* D */
			case 79: /* O */
			case 81: /* Q */
/*				putpixel(bmp, x+2,y+2, ac3);	*/
/*				putpixel(bmp, x+2,y+11, ac3);	*/
				break;
			case 71: /* G */
				vline(bmp, x+2,y+7,y+8,ac3);
/*				putpixel(bmp, x+2,y+2, ac3);	*/
/*				putpixel(bmp, x+2,y+11, ac3);	*/
				break;
			case 80: /* P */
/*				putpixel(bmp, x+2,y+2, ac3);	*/
				break;
			case 82: /* R */
/*				putpixel(bmp, x+2,y+2, ac3);	*/
				putpixel(bmp, x+4,y+5, ac4);
				putpixel(bmp, x+4,y+6, ac4);
				break;
			case 83: /* S */
				putpixel(bmp, x,y+5, ac2);
				putpixel(bmp, x,y+6, ac3);
				putpixel(bmp, x+2,y+5, ac3);
				putpixel(bmp, x+1,y+7, ac3);
				putpixel(bmp, x+2,y+8, ac3);
				putpixel(bmp, x+3,y+6, ac3);
				putpixel(bmp, x+4,y+7, ac3);
				putpixel(bmp, x+4,y+8, ac2);
/*				putpixel(bmp, x+2,y+2, ac3);	*/
/*				putpixel(bmp, x+2,y+11, ac3);	*/
				break;
			case 84: /* T */
/*				hline(bmp, x,y+2,x+3,ac3);	*/
				vline(bmp, x-1,y,y+1,ac4);
				vline(bmp, x+4,y,y+1,ac4);
				break;
			case 74: /* J */
			case 85: /* U */
/*				putpixel(bmp, x+2,y+11, ac3);	*/
				break;
			case 69: /* E */
/*				hline(bmp, x+2,y+2,x+3,ac3);	*/
/*				hline(bmp, x+2,y+7,x+3,ac3);	*/
/*				hline(bmp, x+2,y+11,x+3,ac3);	*/
				break;
			case 70: /* F */
/*				hline(bmp, x+2,y+2,x+3,ac3);	*/
/*				hline(bmp, x+2,y+7,x+3,ac3);    */
				break;
			case 72: /* H */
/*				hline(bmp, x+2,y+7,x+3,ac3);	*/
				break;
			case 75: /* K */
				if(fc==BLACK) {
					FontFadeDown(bmp,x+4,y+6,bc,8);
					FontFadeUp(bmp,x+4,y+7,bc,8);
					FontFadeDown(bmp,x+2,y,bc,7);
					FontFadeUp(bmp,x+2,y+13,bc,7);
				} else {
					FontFadeUp(bmp,x+4,y+13,fc,9);
					FontFadeDown(bmp,x+4,y,fc,9);
					FontFadeUp(bmp,x+2,y+7,fc,7);
					FontFadeDown(bmp,x+2,y+7,fc,7);
				}
				break;
			case 76: /* L */
/*				hline(bmp, x+2,y+11,x+3,ac3);	*/
				break;
			case 77: /* M */
				if(fc==BLACK) {
					FontFadeDown(bmp,x+3,y,bc,7);
					FontFadeDown(bmp,x+4,y,bc,7);
					FontFadeUp(bmp,x+2,y+12,bc,8);
					FontFadeUp(bmp,x+5,y+12,bc,8);
				} else {
					FontFadeUp(bmp,x+3,y+6,fc,7);
					FontFadeUp(bmp,x+4,y+6,fc,7);
					FontFadeDown(bmp,x+2,y+5,fc,8);
					FontFadeDown(bmp,x+5,y+5,fc,8);
				}
				vline(bmp, x,y,y+13,ac2);
				vline(bmp, x+7,y,y+13,ac2);
				break;
			case 78: /* N */
				if(fc==BLACK) {
					FontFadeDown(bmp,x+3,y+2,bc,5);
					FontFadeUp(bmp,x+2,y+10,bc,5);
				} else {
					FontFadeUp(bmp,x+3,y+6,fc,5);
					FontFadeDown(bmp,x+2,y+7,fc,5);
				}
				vline(bmp, x,y,y+13,ac2);
				vline(bmp, x+5,y,y+13,ac2);
				break;
			case 86: /* V */
				if(fc==BLACK) {
					FontFadeUp(bmp,x,y+13,bc,14);
					FontFadeUp(bmp,x+4,y+13,bc,14);
					FontFadeDown(bmp,x+2,y,bc,14);
				} else {
					FontFadeDown(bmp,x,y,fc,14);
					FontFadeDown(bmp,x+4,y,fc,14);
					FontFadeUp(bmp,x+2,y+13,fc,14);
				}
				break;
			case 87: /* W */
				vline(bmp, x,y,y+3,ac2);
				vline(bmp, x,y+4,y+7,ac3);
				vline(bmp, x,y+8,y+11,ac4);
				vline(bmp, x+2,y+2,y+3,ac4);
				vline(bmp, x+2,y+4,y+6,ac3);
				rectfill(bmp, x+3,y+8,x+4,y+10,ac3);
				rectfill(bmp, x+3,y+11,x+4,y+12,ac4);
				vline(bmp, x+5,y+2,y+3,ac4);
				vline(bmp, x+5,y+4,y+6,ac3);
				vline(bmp, x+7,y,y+3,ac2);
				vline(bmp, x+7,y+4,y+7,ac3);
				vline(bmp, x+7,y+8,y+11,ac4);
				break;
			case 88: /* X */
				if(fc==BLACK) {
					FontFadeUp(bmp,x,y+5,bc,6);
					FontFadeDown(bmp,x,y+8,bc,6);
					FontFadeUp(bmp,x+5,y+5,bc,6);
					FontFadeDown(bmp,x+5,y+8,bc,6);
					FontFadeDown(bmp,x+2,y,bc,6);
					FontFadeUp(bmp,x+2,y+13,bc,8);
					FontFadeDown(bmp,x+3,y,bc,6);
					FontFadeUp(bmp,x+3,y+13,bc,8);
				} else {
					FontFadeDown(bmp,x,y,fc,8);
					FontFadeUp(bmp,x,y+13,fc,8);
					FontFadeDown(bmp,x+5,y,fc,8);
					FontFadeUp(bmp,x+5,y+13,fc,8);
					FontFadeUp(bmp,x+2,y+5,fc,6);
					FontFadeDown(bmp,x+2,y+6,fc,8);
					FontFadeUp(bmp,x+3,y+5,fc,6);
					FontFadeDown(bmp,x+3,y+6,fc,8);
				}
				break;
			case 89: /* Y */
				if(fc==BLACK) {
					FontFadeUp(bmp,x,y+4,bc,5);
					FontFadeUp(bmp,x+1,y+7,bc,5);
					FontFadeDown(bmp,x+2,y+1,bc,4);
					FontFadeDown(bmp,x+3,y+1,bc,4);
					FontFadeUp(bmp,x+4,y+7,bc,5);
					FontFadeUp(bmp,x+5,y+4,bc,5);
				} else {
					FontFadeDown(bmp,x,y,fc,5);
					FontFadeDown(bmp,x+1,y+4,fc,5);
					FontFadeUp(bmp,x+2,y+4,fc,4);
					FontFadeUp(bmp,x+3,y+4,fc,4);
					FontFadeDown(bmp,x+4,y+4,fc,5);
					FontFadeDown(bmp,x+5,y,fc,5);
				}
				break;
			case 90: /* Z */
/*				hline(bmp, x,y+2,x+1,ac3);	*/
/*				hline(bmp, x+2,y+11,x+3,ac3);	*/
				vline(bmp, x,y+6,y+7,ac4);
				vline(bmp, x,y+8,y+9,ac3);
				putpixel(bmp, x+1,y+3,ac4);
				vline(bmp, x+1,y+4,y+5,ac3);
				vline(bmp, x+2,y+8,y+9,ac3);
				putpixel(bmp, x+2,y+10,ac4);
				vline(bmp, x+3,y+4,y+5,ac3);
				vline(bmp, x+3,y+6,y+7,ac4);
				break;
			case 92: /* backslash */
				b=12;
				for(a=6; a>=0; --a) {
					vline(bmp, x+a,y+b,y+1+b,fc);
					putpixel(bmp, x+1+a,y+1+b, ac3);
					putpixel(bmp, x+1+a,y+b, ac4);
					putpixel(bmp, x-1+a,y+b, ac3);
					putpixel(bmp, x-1+a,y+1+b, ac4);
					b-=2;
				}
				break;
/* ## */
			case 118: /* v */
			case 121: /* y (same as v for this process) */
				if(fc==BLACK) {
					FontFadeUp(bmp,x,y+8,bc,6);
					FontFadeUp(bmp,x+1,y+13,bc,5);

					FontFadeDown(bmp,x+2,y+4,bc,7);
					FontFadeDown(bmp,x+3,y+4,bc,7);

					FontFadeUp(bmp,x+4,y+13,bc,5);
					FontFadeUp(bmp,x+5,y+8,bc,6);

				} else {
					FontFadeDown(bmp,x,y+3,fc,6);
					FontFadeDown(bmp,x+1,y+9,fc,5);
					FontFadeUp(bmp,x+2,y+10,fc,7);
					FontFadeUp(bmp,x+3,y+10,fc,7);
					FontFadeDown(bmp,x+4,y+9,fc,5);
					FontFadeDown(bmp,x+5,y+3,fc,6);
				}
				break;
			case 119: /* w */
				if(fc==BLACK) {
					FontFadeUp(bmp,x,y+8,bc,6);
					FontFadeUp(bmp,x+1,y+13,bc,5);
					FontFadeDown(bmp,x+2,y+3,bc,6);
					FontFadeDown(bmp,x+3,y+3,bc,6);

					FontFadeUp(bmp,x+4,y+13,bc,5);
					FontFadeUp(bmp,x+5,y+13,bc,5);

					FontFadeDown(bmp,x+6,y+3,bc,6);
					FontFadeDown(bmp,x+7,y+3,bc,6);
					FontFadeUp(bmp,x+8,y+13,bc,5);
					FontFadeUp(bmp,x+9,y+8,bc,6);
				} else {
					FontFadeDown(bmp,x,y+3,fc,6);
					FontFadeDown(bmp,x+1,y+9,fc,5);
					FontFadeUp(bmp,x+2,y+8,fc,6);
					FontFadeUp(bmp,x+3,y+8,fc,6);

					FontFadeDown(bmp,x+4,y+9,fc,5);
					FontFadeDown(bmp,x+5,y+9,fc,5);

					FontFadeUp(bmp,x+6,y+8,fc,6);
					FontFadeUp(bmp,x+7,y+8,fc,6);
					FontFadeDown(bmp,x+8,y+9,fc,5);
					FontFadeDown(bmp,x+9,y+3,fc,6);
				}
				break;
			case 120: /* x */
				if(fc==BLACK) {
					FontFadeUp(bmp,x,y+7,bc,5);
					FontFadeDown(bmp,x,y+9,bc,5);

					FontFadeDown(bmp,x+2,y+3,bc,4);
					FontFadeDown(bmp,x+3,y+3,bc,4);
					FontFadeUp(bmp,x+2,y+13,bc,4);
					FontFadeUp(bmp,x+3,y+13,bc,4);

					FontFadeDown(bmp,x+5,y+9,bc,5);
					FontFadeUp(bmp,x+5,y+7,bc,5);
				} else {
					FontFadeDown(bmp,x,y+3,fc,5);
					FontFadeUp(bmp,x,y+13,fc,5);

					FontFadeUp(bmp,x+2,y+6,fc,4);
					FontFadeUp(bmp,x+3,y+6,fc,4);
					FontFadeDown(bmp,x+2,y+10,fc,4);
					FontFadeDown(bmp,x+3,y+10,fc,4);

					FontFadeUp(bmp,x+5,y+13,fc,5);
					FontFadeDown(bmp,x+5,y+3,fc,5);
				}
				putpixel(bmp,x+1,y+8, ac3);
				putpixel(bmp,x+4,y+8, ac3);
				break;
			default: break;
		}
	return(0);
}
int Headline14(BITMAP *bmp, int x,int y, int Hue, char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	size_t j;
	int tabpos;
	unsigned int t;

	Shadow=FindShadow(Hue, BackgroundColor);
	t=32;
	pos = x;
	j = strlen(Str);
	strcpy(Capture, Str);
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		if( Capture[k] < 32 && Capture[k] != 9 ) i = (t);
		else i = Capture[k];
		if(y>0 && Capture[k] != 9 ) {
/*			StripeHeadline14(bmp,i,pos,y,Shadow); */
			SmoothHeadline14(bmp,i,pos,y,Hue);
			BlitHeadline14(bmp,i,pos,y,Hue);

/* hyphen lengthened to en dash if before numeric/space/slash, fills to em if double */
if(Capture[k] == 45) {
		if( (Capture[k+1]>46 && Capture[k+1]< 58) || Capture[k+1]==32 || Capture[k+1]==45) {
			pos+=3;
			SmoothHeadline14(bmp,45,pos,y,Hue);
			BlitHeadline14(bmp,45,pos,y,Hue);
		}
		if( Capture[k+1]==45 )  pos-=3;
}

		}
		if( Capture[k] == 9 ) {
			tabpos=0;
			while( pos-x >= tabpos) tabpos += 40;
			pos = tabpos + x;
		} else pos += Font14[i]-65;
	}

	return(0);
}
int PutsFont14(int x,int y,int ForeColor,int BackColor,char *Str)
{
	fc=ForeColor;
	bc=BackColor;
	if(bc==BLACK) FadeOut(fc);
	if(fc==BLACK) FadeIn(bc);
	if(fc==RED && bc==CARDWHITE) { 		/* special for card games */
		ac3 = makecol(253, 154,   131);
		ac4 = makecol(251,  182,   167);
	}
	BackgroundColor=BackColor;
	Headline14(screen,x,y,ForeColor,Str);
	return(0);
}
int PutsLuna(int x,int y,int ForeColor,int BackColor,char *cStr)
{
	PutsFont14(x,y,ForeColor,BackColor,Strupr(cStr));
/*	PutsFont14(x,y,ForeColor,BackColor,strupr(cStr)); */
	return(0);
}
int StrLenLuna(char *cStr)
{
	return(StrLenFont14(Strupr(cStr)));
/*	return(StrLenFont14(ustrupr(cStr))); */
}
int PutsFont19(int x,int y, int Hue, char *Str)
{
	BackgroundColor=BLACK;
	Headline19(screen,x,y,Hue,Str);
	return(0);
}
int RightPutsFont19(int x,int y, int Hue, char *Str)
{
	BackgroundColor=BLACK;
	Headline19(screen,x-StrLenFont21(Str),y,Hue,Str);
	return(0);
}
int PutsFont21(int x,int y, int Hue, char *Str)
{
	BackgroundColor=BLACK;
	Headline21(screen,x,y,Hue,Str);
	return(0);
}
int RightPutsFont21(int x,int y, int Hue, char *Str)
{
	BackgroundColor=BLACK;
	Headline21(screen,x-StrLenFont21(Str),y,Hue,Str);
	return(0);
}
int PutsScorpio(int x,int y, int Hue, char *Str)
{
	BackgroundColor=BLACK;
	Headline26(screen,x,y,Hue,Str);
	return(0);
}
int Title(char *Str)
{
	int k;
	int th=26; /* to match the thickness of a popsicle stick, etc. */

	k=StrLenScorpio(Str);
	rectfill(screen, (th*1.5)+8-3, th/2, (th*1.5)+8+k+3, th*1.5, BLACK);
	PutsScorpio(47, 13,  ORANGE, Str);
	return(StrLenScorpio(Str)+72);
}

int ColorTitle(char *Str, int Color)
{
	int k;
	int th=26; /* to match the thickness of a popsicle stick, etc. */

	k=StrLenScorpio(Str);
	rectfill(screen, (th*1.5)+8-3, th/2, (th*1.5)+8+k+3, th*1.5, BLACK);

	PutsScorpio(47, 13,  Color, Str);
	return(StrLenScorpio(Str)+72);
}


