/*	 File menu for Text24, etc. */
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "filemenu.h"


void FmBottomFill(int Hue)
{
	rectfill(screen,10,308,110,590,Hue);
}
void FmMessageBox1a(int Hue)
{
	int boxtop;

	boxtop=10;
	rectfill(screen,10,boxtop,110,boxtop+54,Hue);
	PutsLuna(110-StrLenLuna("CANCEL")-4,boxtop+36,BLACK,Hue,"CANCEL");
}
void FmMessageBox2a(int Hue)
{
	rectfill(screen,10,68,110,68+54,Hue);
	PutsLuna(110-StrLenLuna("PATH")-4,104,BLACK,Hue,"PATH");
}
void FmUpperElbowSignage()
{
	rectfill(screen,10,150+117-18,110,150+117+32,PALEBLUE); /* erase lower */
	PutsLuna(14,150-18, BLACK,MANGO, "TO SELECT:");
	PutsLuna(14,150,	 BLACK,MANGO, "ARROW DOWN");
}
void FmLowerElbowSignage()
{
	rectfill(screen,10,150-18,110,150-18+44,MANGO); /* erase upper */
	PutsLuna(14,150+117-18, BLACK,PALEBLUE, "TO TYPE IN:");
	PutsLuna(14,150+117,	 BLACK,PALEBLUE, "ARROW FAR");
	PutsLuna(14,150+117+18, BLACK,PALEBLUE, "LEFT/RIGHT");
}
void FmFloppyMessage()
{
	PutsLuna(14,296+18, BLACK,MANGO, "TO RECHECK");
	PutsLuna(14,296+36, BLACK,MANGO, "DRIVE A,");
	PutsLuna(14,296+54, BLACK,MANGO, "LOAD FLOPPY");
	PutsLuna(14,296+72, BLACK,MANGO, "DISK AND");
	PutsLuna(14,296+90, BLACK,MANGO, "PRESS F1 OR");
	PutsLuna(14,296+108, BLACK,MANGO, "SELECT DRIVE A.");
}
void FmEscButton()
{
	ButtonType3(120, 5+9, LILAC, LILAC, "BACK");
	EscSymbol(237, 5+9,2, ORANGE);
}
void FmInputLine()
{
	RightBumper36(280-18,162-18,NAPLES);
	rectfill(screen,138+25+10,144,280,180,NAPLES);
	rectfill(screen,138,144,138+25,180,MANGO);
	PutsLuna(280+26-18-StrLenLuna("TYPE IN")-16,130+32,BLACK,NAPLES,"TYPE IN");
	rectfill(screen,311,130+14,311+10,130+50,MANGO);
}
int FmCheckForExisting()
{
	int match=1;
	int z;

	z=0;
	while( match != 0) {
		match=stricmp(NewName,W2List[z]);
		if(z==W2EndList) break;
		if(z < W2EndList) ++z;
	}
	return( ! match);
}
int FmWarning()
{
	rectfill(screen,10,10,110,122,PALEBLUE); /* top two message boxes */
	rectfill(screen,10,249,110,299,PALEBLUE); /* signage */
	rectfill(screen,10,132,110,176,MANGO);	 /* signage */
	FmBottomFill(MANGO);							 /* signage */
	rectfill(screen,120,6,795,192,BLACK);
	rectfill(screen,120,230,795,595,BLACK);
	MarsF(590,10,3, ORANGE,BLACK,"WARNING");
	PutsScorpio(190,263,ORANGE,"FILENAME ALREADY IN USE:");
	PutsScorpio(445,263,PALEBLUE,NewName);
	PutsScorpio(190,327,ORANGE,"OVERWRITE EXISTING FILE?");
	ButtonType3(445, 322, ORANGE, MANGO, "OVERWRITE");
	EnterSymbol(563, 322, 2, NAPLES);
	ButtonType3(445, 380, LILAC, LILAC, "CANCEL");
	EscSymbol(562,380,2, ORANGE);

loopback:
	do {
		c=GetKey();
		switch( c )
		{
			case ESC: return(0);
			case 13:  /*	FmMessageBox2a(ORANGE); necessary? */
					return(1);
			default: goto loopback;
		}
	} while(1);
	return(0);
}
int FmExportInfo()
{
	int Result=1;

	if( strcmp(Mode, "SAVE AS")==0 ) {
		if( FmCheckForExisting() ) {
			Result=FmWarning();
			if(Result==0) {
						strcpy(Mode,"ESC");
				strcat(PathName,"\\");
				strcat(PathName,NewName);
				return(0);
			}
		}
	}

	strcat(PathName,"\\");
	strcat(PathName,NewName);
	return(0);
}
void FmSelectFolder(int x,int y, char *Label, int Hue)
{
	char TruncateStr[80]; /* to prevent Windows from displaying
				 a long folder name */

	strcpy(TruncateStr, Label);
	TruncateStr[9]=(null);
	strcpy(Label,TruncateStr);

	if(W1Current==0) return;
	rectfill(screen,x,y,x+80,y+30,Hue);
	rectfill(screen,x+112+5,y,x+120+5,y+30,Hue);
	PutsLuna(x+94-StrLenLuna(Label)-16,y+14,BLACK,Hue,Label);
}
void FmDrawFolder(int x,int y, char *Label, char Status)
{
	char TruncateStr[80]; /* to prevent Windows from displaying
				 a long folder name */

	strcpy(TruncateStr, Label);
	TruncateStr[9]=(null);
	strcpy(Label,TruncateStr);

	rectfill(screen,x,y,x+80,y+30,ORANGE);
	PutsLuna(x+94-StrLenLuna(Label)-16,y+14,BLACK,ORANGE,Label);
	if(strcmp(Content,"0")==0)
		PutsScorpio(x+85+30-(strlen(Content)*10), y+2, BRICK,Content);
		else PutsScorpio(x+85+30-(strlen(Content)*10), y+2, PALEBLUE,Content);

	rectfill(screen,x+112+5,y,x+120+5,y+30,ORANGE);
	/* no plus/minus sign when drawing a folder above the file list */
	if( x < 200 ) return;
	/* plus or minus sign */
	if( Status >= 1) rectfill(screen,x-34+6,y+20,x-34+10+2,y+22,ORANGE);
	if( Status==2) rectfill(screen,x-34+6+2,y+16,x-34+8+2,y+26,ORANGE);
}
void FmSortFiles()
{
	char bag[80];
	int f;
	int r=0;
	char done,ch;
	int z,i;
return;
	for( z=0; z<NumOfFiles; ++z) {
		for( i=0; i<80; ++i) {
				ch=MenuFileArray[z][i];
				if( ch !=(null) ) ch=toupper(ch);
				MenuFileArray[z][i]=ch;
		}
	}
	do {
		done=TRUE;
		for (f=0; f<NumOfFiles; ++f) {
			r=stricmp(MenuFileArray[f],MenuFileArray[f+1]);
			if( r > 0 )	 {
				strcpy(bag,MenuFileArray[f]);
				strcpy(MenuFileArray[f],MenuFileArray[f+1]);
				strcpy(MenuFileArray[f+1],bag);
				done=FALSE;
			}
		}
	} while ( done==FALSE );
}
void FilterFiles(char *mask) /* version compatible with FreeDOS (see below) */
{
	struct al_ffblk fblock;
	int Found;

	Found=al_findfirst(mask, &fblock, FA_ARCH);
	while ( !Found ) {
		NumOfFiles++;
		strcpy(MenuFileArray[NumOfFiles], fblock.name);
		Found=al_findnext( &fblock );
	}
	al_findclose( &fblock );
}
void FmFindFiles(char *mask)
{
	char maskpath[80];

	NumOfFiles=0;
	strcpy(maskpath,mask);
/* 	strcat(maskpath,"\\*.TXT"); */
	strcat(maskpath,"\\*.");
	strcat(maskpath,get_extension(CurrentFile));
	FilterFiles(maskpath);
return;
	strcpy(maskpath,mask);
	strcat(maskpath,"\\*.BAT");
	FilterFiles(maskpath);
	strcpy(maskpath,mask);
	strcat(maskpath,"\\*.C");
	FilterFiles(maskpath);
	strcpy(maskpath,mask);
	strcat(maskpath,"\\*.H");
	FilterFiles(maskpath);
	strcpy(maskpath,mask);
	strcat(maskpath,"\\*.PAS");
	FilterFiles(maskpath);
	strcpy(maskpath,mask);
	strcat(maskpath,"\\*.INI");
	FilterFiles(maskpath);
	strcpy(maskpath,mask);
	strcat(maskpath,"\\*.CFG");
	FilterFiles(maskpath);
	strcpy(maskpath,mask);
	strcat(maskpath,"\\*.LOG");
	FilterFiles(maskpath);
	strcpy(maskpath,mask);
	strcat(maskpath,"\\READ.ME");
	FilterFiles(maskpath);
	strcpy(maskpath,mask);
	strcat(maskpath,"\\README.1ST");
	FilterFiles(maskpath);
	strcpy(maskpath,mask);
	strcat(maskpath,"\\CONFIG.*");
	FilterFiles(maskpath);
	strcpy(maskpath,mask);
	strcat(maskpath,"\\MAKEFILE");
	FilterFiles(maskpath);
	strcpy(maskpath,mask);
	strcat(maskpath,"\\*.CPP");
	FilterFiles(maskpath);
	strcat(maskpath,"\\*.SFM");
	FilterFiles(maskpath);
	strcat(maskpath,"\\*.MSD");
	FilterFiles(maskpath);
}
void FmSortFolders()
{
	char bag[80];
	int f;
	int r=0;
	int done;
return;
	do {
		done=TRUE;
		for (f=0; f<=NumOfFolders-1; ++f) {
			r=stricmp(MenuFolderArray[f],MenuFolderArray[f+1]);
			if( r > 0 )	 {
				strcpy(bag,MenuFolderArray[f]);
				strcpy(MenuFolderArray[f],MenuFolderArray[f+1]);
				strcpy(MenuFolderArray[f+1],bag);
				done=FALSE;
			}
		}
	} while ( done==FALSE );
	strcpy(MenuFolderArray[1], "C:");
	strcpy(MenuFolderArray[2], "LCARS24");
}
void FmInspectOneFolder(char *mask)
{
	char filemask[100];
	struct al_ffblk fblock;
	int Found;

	strcpy(filemask, mask); /* mask for subfolders, filemask for files */
	strcat( mask, "\\*");

	NumOfFolders=0;
	Found=al_findfirst(mask, &fblock, FA_DIREC);
	while ( !Found ) {
		NumOfFolders++;
		Found=al_findnext( &fblock );
	}
	al_findclose(&fblock);
	FmFindFiles(filemask);
}
void FmW1Cursor()
{
	int gx,gy;

	gx=735;
	if(Oldw1x==1) gx=453+((W1Info[Oldw1y+1][2]*19)-19);
	if(Oldw1x==2) gx=602+((W1Info[Oldw1y+1][2]*19)-19);
	if(Oldw1x==3) gx=735;
	gy=244+((Oldw1y-W1Offset)*36);
	if(Oldw1x<4)EnterSymbol(gx,gy,1,BLACK);
	if(w1x==1) gx=453+((W1Info[w1y+1][2]*19)-19);
	if(w1x==2) gx=602+((W1Info[w1y+1][2]*19)-19);
	if(w1x==3) gx=735; /* Drive A button */
	gy=244+((w1y-W1Offset)*36);
	if(w1x<3) EnterSymbol(gx,gy,1,NAPLES);
	if(w1x==3 && w1y==0) EnterSymbol(gx,gy,1,NAPLES);
	Oldw1x=w1x;
	Oldw1y=w1y;
}
int FmFindParent(int Level)
{
	int i;

	i=w1y;
	while( i>2 && W1Info[i][2] > Level-1) --i;
	return(i);
}
void FmUnhighlight()
{
	int p2;

	FmSelectFolder(451,236,"DRIVE C:",PALEBLUE);
	FmSelectFolder(603,236,"DRIVE A:",PALEBLUE);
	p2=W1Info[W1Current+1][2]*19; /* nesting level of folder to unhighlight */
	if(W1Current-W1Offset < 10 && W1Current-W1Offset > 0)
	FmSelectFolder(451+p2,200+((W1Current+1-W1Offset)*36),W1Folders[W1Current+1],ORANGE);
}
void FmW1Open(char *FnExt)
{
	int bottom,p1,Parent,z;
	char TruncateStr[80]; /* to prevent Windows from displaying
				 a long filename */

	p1=W1Info[Oldw1y+1][2]*19; /* nesting level of folder to highlight */
	FmUnhighlight();
	FmSelectFolder(451+p1,200+((w1y+1-W1Offset)*36),W1Folders[w1y+1],NAPLES);
	W1Info[w1y+1][3]=1;
	W1Info[W1Current+1][3]=0;
	W1Current=w1y;
	if(w1y==1) {
		strcpy(ListTitle, "C:\\LCARS24");
		goto bypass;
	}
	strcpy(ListTitle, "C:\\LCARS24\\");
	if(W1Info[w1y+1][2]==2) {  /* actual magic */
		Parent=FmFindParent(2); /* but needs further depth */
		strcat(ListTitle,W1Folders[Parent]);
		strcat(ListTitle,"\\");
	}
	strcat(ListTitle,W1Folders[w1y+1]);
	strcpy(PathName,ListTitle);
bypass:
	rectfill(screen,130,272,400,599,BLACK);
	rectfill(screen,138,103,527,124,BLACK);
	PutsLuna(138,104,ORANGE,BLACK,ListTitle);
	strcpy(PathName, ListTitle);			/* a patch */
	FmFindFiles(ListTitle);
	FmSortFiles();
	strcat(ListTitle,"\\*.");
	strcat(ListTitle,FnExt);
	for(z=0;z<=NumOfFiles;++z) strcpy(W2List[z], MenuFileArray[z]);
	W2EndList=NumOfFiles;
	rectfill(screen,130,234,254,270,BLACK);
	itoa(NumOfFiles,Content,10);
	FmDrawFolder(120,236,W1Folders[w1y+1], W1Info[w1y+1][1]);
	FmSelectFolder(120,236,W1Folders[w1y+1],NAPLES);
	bottom=W2EndList;
	if(W2EndList>13) bottom=13;
	for(z=0;z<=bottom;++z) {
		strcpy(TruncateStr,MenuFileArray[z]);
		TruncateStr[12]=(null);
		RightPutsFont19(269,252+(z*24),PALEBLUE,TruncateStr);
	}
	W2Offset=0;
	w2y=1;
	Oldw2y=1;
}
void FmW1Refresh()
{
	int i,p2,z;
	int bottom=10;

	i=W1Offset;
	if(W1EndList-W1Offset<10) bottom=W1EndList-W1Offset;
	rectfill(screen,410,272,700,599,BLACK);
	for(z=2;z<=bottom;++z) {
		itoa(W1Info[z+i][0],Content,10);
FmDrawFolder(451+(W1Info[z+i][2])*19,200+(z*36),W1Folders[z+i], W1Info[z+i][1]);
	}
/* maintain highlight when scrolling */
	p2=W1Info[W1Current+1][2]*19; /* nesting level of folder to unhighlight */
	if(W1Current-W1Offset < 10 && W1Current-W1Offset > 0  ) {
if(W1Info[W1Current+1][3]==1 && W1Current < W1EndList) /* should be highlighted */
FmSelectFolder(451+p2,200+((W1Current+1-W1Offset)*36),W1Folders[W1Current+1],NAPLES);
	}
}
void FmW1Contract( int Level)
{
	int i, Count;

	i=w1y+2;
	while( i<=W1EndList && W1Info[i][2]==Level) ++i;
	Count=i-(w1y+2);
	for(i=w1y+2; i<=W1EndList-Count; ++i) {
		strcpy(W1Folders[i],W1Folders[i+Count]);
		W1Info[i][0]=W1Info[i+Count][0];
		W1Info[i][1]=W1Info[i+Count][1];
		W1Info[i][2]=W1Info[i+Count][2];
		W1Info[i][3]=0; /* prevent false display */
	}
	W1EndList-=(Count);
	if(W1Current>w1y) W1Current-=Count; /* was -1, caused trouble */
}
void FmW1Expand()
{
	struct al_ffblk fblock;
	int Found, Count, z;
	char mask[100];

	strcpy( mask, "c:\\LCARS24\\");
	strcat( mask, W1Folders[w1y+1]);
	strcat( mask, "\\*");

	NumOfFolders=0;
	Found=al_findfirst(mask, &fblock, FA_DIREC);
	while ( !Found ) {
		NumOfFolders++;
		strcpy(MenuFolderArray[NumOfFolders], fblock.name);
		Found=al_findnext( &fblock );
	}
	al_findclose( &fblock );
	FmSortFolders();
	Count=NumOfFolders-W1Info[w1y+1][2]-1;
	W1EndList+=Count;
	W1Info[w1y+1][1]=1;
	for(z=W1EndList; z>=w1y+2+Count; --z) {
		strcpy(W1Folders[z],W1Folders[z-Count]);
		W1Info[z][0]=W1Info[z-Count][0];
		W1Info[z][1]=W1Info[z-Count][1];
		W1Info[z][2]=W1Info[z-Count][2];
		W1Info[z][3]=W1Info[z-Count][3];
	}
	for(z=0; z<Count; ++z) {
		strcpy(W1Folders[w1y+2+z],MenuFolderArray[z+3]);
	}
	for(z=w1y+2;z<w1y+2+Count;++z) {
		strcpy( mask, "c:\\LCARS24\\");
		strcat( mask, W1Folders[w1y+1]);
		strcat( mask, "\\");
		strcat( mask, W1Folders[z]);
/*	 strcat( mask, "\\*"); */
		FmInspectOneFolder(mask);
		W1Info[z][0]=NumOfFiles;
		W1Info[z][2]=2;
		W1Info[z][1]=0;
		if(NumOfFolders>W1Info[z][2]) W1Info[z][1]=2;
		W1Info[z][2]=2;
		W1Info[z][3]=0;
	}
	if(W1Current>w1y) W1Current+=Count;
	FmW1Refresh();
	FmW1Cursor();
}
void FmW1Nest()
{
	if( w1y<=1) return; /* don't mess with LCARS24 or C:\ */
	if(W1Info[w1y+1][1]==0) return; /* no subfolders */
	if(W1Info[w1y+1][1]==1) {
		FmW1Contract(2);
		W1Info[w1y+1][1]=2; /* + symbol */
		FmW1Refresh();
		FmW1Cursor();
		return;
	}
	if( c==13 && W1Info[w1y+1][1]==2) FmW1Expand();
}
void FmW1Init()
{
	char mask[100]="c:\\lcars24";
	int i;

	FmFindFiles(mask);
	W1Info[2][0]=NumOfFiles;
	W1Info[2][1]=1; /* LCARS24 folder expanded by routine below */
	W1Info[2][2]=0; /* highest level in nest (disregarding C:\) */
	W1Info[2][3]=0; /* not yet highlighted */
	itoa(W1Info[2][0],Content,10);
	FmDrawFolder(451,236+36,W1Folders[2], W1Info[2][1]);

	for(i=3;i<=W1EndList;++i) {
		strcpy( mask, "c:\\lcars24\\");
		strcat( mask, W1Folders[i]);
		FmInspectOneFolder(mask);
		W1Info[i][0]=NumOfFiles;
		W1Info[i][1]=0; /* not yet expanded */
		W1Info[i][3]=0; /* not yet highlighted */
		if(NumOfFolders>2) W1Info[i][1]=2;
		W1Info[i][2]=1;
	}
}

int FmShowFolders()
{	 /* Allegro version */
	int Found, z;
	struct al_ffblk fblock;
	char *mask;
	char Temp[80];
	char OpeningFolder[80];
	size_t pos;
	int FolderNum=2;

	strcpy(Temp,CurrentFile);
	pos=strlen(Temp);
	Temp[pos]=0;
	pos -= strlen(get_filename(Temp));
	if(pos>1) Temp[pos-1]=0;
	strcpy(OpeningFolder, get_filename(Temp));

	mask = "c:\\LCARS24\\*";
	NumOfFolders = 0;
	Found = al_findfirst(mask, &fblock, FA_DIREC);
	while ( !Found ) {
		NumOfFolders++;
	strcpy(MenuFolderArray[NumOfFolders], fblock.name);
	Found = al_findnext( &fblock );
	}
	al_findclose( &fblock );
	FmSortFolders();
	for(z=0;z<=NumOfFolders;++z) {
		strcpy(W1Folders[z],MenuFolderArray[z]);
		if(strcmp(W1Folders[z],OpeningFolder)==0) FolderNum=z-1;
	}
	W1EndList=NumOfFolders;

	if(FolderNum < 2) FolderNum=2;
	return(FolderNum);
}
void FmDriveC()
{
	int bottom,z;

	FmUnhighlight();
	FmSelectFolder(451,236,"DRIVE C:",NAPLES);
	strcpy(ListTitle, "C:");
	strcpy(PathName,ListTitle);
	rectfill(screen,130,272,400,599,BLACK);
	rectfill(screen,138,103,527,124,BLACK);
	PutsLuna(138,104,ORANGE,BLACK,ListTitle);
	FmFindFiles(ListTitle);
	strcat(ListTitle,"\\*.TXT");
	FmSortFiles();
	for(z=0;z<=NumOfFiles;++z) strcpy(W2List[z], MenuFileArray[z]);
	W2EndList=NumOfFiles;
	rectfill(screen,130,234,254,270,BLACK);
	itoa(NumOfFiles,Content,10);
	FmDrawFolder(120,236,W1Folders[w1y+1], W1Info[w1y+1][1]);
	FmSelectFolder(120,236,"DRIVE C:",NAPLES);
	bottom=W2EndList;
	if(W2EndList>13) bottom=13;
	for(z=0;z<=bottom;++z) RightPutsFont19(269,252+(z*24),PALEBLUE,MenuFileArray[z]);
	W2Offset=0;
	w2y=1;
	Oldw2y=1;
}
int FmFloppyReady()
{
/*
	int result;
	char buffer[512];

	result=biosdisk(2,0,0,0,0,1,buffer);
	return(result);
*/
	return(0x80); /* temporary for MinGW */
}
int FmCheckFloppy()
{
	int Result;

	rectfill(screen,717-30,238,717,238+27,BLACK);
	if(FmFloppyReady() !=0x80 ) { /* floppy detected */
		FmFindFiles("A:");
		itoa(NumOfFiles,Content,10);
		PutsScorpio(718-(strlen(Content)*10), 238, PALEBLUE,Content);
		Result=0;
	} else {
		PutsScorpio(718-(strlen("OFF")*10), 238, BRICK,"OFF");
		Result=1;
	}
	return(Result);
}
void FmDriveA()
{
	int bottom,z;

	if( FmCheckFloppy()==1) return;
	FmUnhighlight();
	FmSelectFolder(603,236,"DRIVE A:",NAPLES);
	strcpy(ListTitle, "A:");

	strcpy(PathName,ListTitle);
	rectfill(screen,130,272,400,599,BLACK);
	rectfill(screen,138,103,527,124,BLACK);
	PutsLuna(138,104,ORANGE,BLACK,ListTitle);
	FmFindFiles(ListTitle);
	strcat(ListTitle,"\\*.TXT");
	FmSortFiles();
	for(z=0;z<=NumOfFiles;++z) strcpy(W2List[z], MenuFileArray[z]);
	W2EndList=NumOfFiles;
	rectfill(screen,130,234,254,270,BLACK);
	itoa(NumOfFiles,Content,10);
	FmDrawFolder(120,236,W1Folders[w1y+1], W1Info[w1y+1][1]);
	FmSelectFolder(120,236,"DRIVE A:",NAPLES);
	bottom=W2EndList;
	if(W2EndList>13) bottom=13;
	for(z=0;z<=bottom;++z) RightPutsFont19(269,252+(z*24),PALEBLUE,MenuFileArray[z]);
	W2Offset=0;
	w2y=1;
	Oldw2y=1;
}
int FmDrives()
{
	w1x=2;
	w1y=0;
	FmW1Cursor();
loopback:
	do {
		c=GetKey();
		switch( c ) {
			case ESC: strcpy(Mode,"ESC");
					return(0);
			case 13:	  if(w1x==2) FmDriveC();
					if(w1x==3) FmDriveA();
				if(W1Info[w1y][2] > 2) goto loopback;
					goto loopback;
			case DOWNARROW: /* if(w1x==3) w1x=2; */
					return(3);
			case LEFTARROW:
				--w1x;
				if(w1x<2) {
					return(2);  /* will be routed to W2Active() */
				}					 /* by MenuGetKeyboardInput */
				goto cursor;
			case RIGHTARROW: ++w1x;
					FmW1Cursor();
					if(w1x==4) {
						return(1);
					}
					else goto cursor;
			default: goto loopback;
		}
	} while(1);
cursor:
	FmW1Cursor();
	goto loopback;
	return(0);
}
int FmW1Active()
{
	int i, Result;

	w1x=2;
	Oldw1x=2;
	FmW1Cursor();
loopback:
	do {
		c=GetKey();
		switch( c )
		{
			case ESC: strcpy(Mode,"ESC");
					return(0);
			case 13: if(w1x==2) FmW1Open(get_extension(CurrentFile));
/* deep nesting acknowledged but not expanded */
				if(W1Info[w1y+1][2] > 1 && w1x==1) goto loopback;
				if(w1x==1) FmW1Nest();
				goto loopback;
			case DELKEY: if(w1x==1) FmW1Nest();
				goto loopback;
			case UPARROW:
				if( w1y==1 ) {
					Result=FmDrives();
					w1y=2;
					w1x=2;
					if(Result==3) {
						goto cursor;
						Oldw1y=2;
						Oldw1x=2;
					} else {
						Oldw1y=2;
						Oldw1x=2;
				rectfill(screen,580-149,244,596-149,264,BLACK);
				rectfill(screen,580,244,596,264,BLACK);
				rectfill(screen,580+155,244,596+155,264,BLACK);
						return(Result);
					}
				}
				--w1y;
				if(w1y-W1Offset < 1) {
					--W1Offset;
					FmW1Refresh();
				}
				goto cursor;
			case PGUPKEY:
				for( i=0; i<4; i++) {
					if( w1y==1) { break; goto loopback; }
					--w1y;
					if(w1y-W1Offset < 1) {
						--W1Offset;
						FmW1Refresh();
					}
				}
				goto cursor;
			case DOWNARROW:
				if( w1y >= W1EndList-1 ) goto loopback;
				++w1y;
				if(w1y-W1Offset > 9) {
					++W1Offset;
					FmW1Refresh();
				}
				goto cursor;
			case PGDNKEY:
				for( i=0; i<4; i++) {
					if( w1y >= W1EndList-1) { break; goto loopback; }
					++w1y;
					if(w1y-W1Offset > 9) {
						++W1Offset;
						FmW1Refresh();
					}
				}
				goto cursor;
			case LEFTARROW:
				--w1x;
				if(w1x<1) {
					w1x=3;
					FmW1Cursor();
					return(2);  /* will be routed to W2Active() */
				}					 /* by MenuGetKeyboardInput */
				goto cursor;
			case RIGHTARROW:
				++w1x;
				FmW1Cursor();
				if(w1x==3) return(1); /* to MenuGetKeyboardInput(); */
				goto cursor;
			case CTRL_F1: Screenshot792("Menu8.bmp");
				goto loopback;
			case CTRL_F2: Screenshot1024("Menu10.bmp");
				goto loopback;
			default: goto loopback;
		}
	} while(1);
cursor:
	FmW1Cursor();
	goto loopback;
}
void FmW2Cursor()
{
	int gx,gy;

	gx=285;
	gy=254+((Oldw2y-W2Offset)*24);
	EnterSymbol(gx,gy,1,0);
	if(w2x==1) gx=285;
	gy=254+((w2y-W2Offset)*24);
	if(w2x<2) EnterSymbol(gx,gy,1,NAPLES);
	Oldw2y=w2y;
	rectfill(screen,580-149,244,596-149,264,BLACK);
	rectfill(screen,580,244,596,264,BLACK);
	rectfill(screen,580+155,244,596+155,264,BLACK);
}
void FmW2Refresh()
{
	int bottom,z;
	char TruncateStr[80]; /* to prevent Windows from displaying
				 a long filename */

	rectfill(screen,130,236+32,410,599,BLACK);
	bottom=W2EndList;
	if(W2EndList>13) bottom=13;
	for(z=1;z<=bottom;++z) {
		strcpy(TruncateStr,W2List[z+W2Offset]);
		TruncateStr[12]=(null);
		RightPutsFont19(269,252+(z*24),PALEBLUE,TruncateStr);
	}
}
void FmW2Up()
{
	if( w2y==1 ) return;
	--w2y;
	if(w2y-W2Offset < 1) --W2Offset;
}
void FmW2Dn()
{
	if( w2y >= W2EndList ) return;
	++w2y;
	if(w2y-W2Offset > 13) ++W2Offset;  /* was 10 */
}
void FmW2Clear()
{
	int z;

	rectfill(screen,130,236+32,410,599,BLACK);
	for(z=0;z<999;++z) memset( W2List[z],(null),16);
	W2EndList=0;
	W2Offset=0;
	w2y=1;
}
int FmW2Active()
{
	char FullPathAndFilename[100];
	int z, OffsetHolder, Result;

	w2x=1;
	FmW2Cursor();
loopback:
	do {
		c=GetKey();
		switch( c )
		{
			case ESC:	strcpy(Mode,"ESC");
					return(0);
			case 13:  strcpy( NewName, W2List[w2y]);
				strcpy(FullPathAndFilename, PathName);
				strcat(FullPathAndFilename,"\\");
				strcat(FullPathAndFilename,NewName);
				if( ! exists(FullPathAndFilename) ) {
					FmW2Clear();
					rectfill(screen,130,234,254,270,BLACK);
					strcpy( Content, "OFF");
					FmDrawFolder(120,236,"",0);
				/* FmSelectFolder(120,236,"DRIVE A:",NAPLES); */
					FmCheckFloppy();
					++w2x;
					FmW2Cursor();
					return(2);
				}
					Result=FmExportInfo();
					return(Result);
			case F3: FmWarning();
					goto loopback;
			case PGUPKEY: OffsetHolder=W2Offset;
					if( w2y==1 ) goto loopback;
					for(z=1;z<=12;++z) FmW2Up();
					if(W2Offset != OffsetHolder) FmW2Refresh();
					goto cursor;
			case PGDNKEY: OffsetHolder=W2Offset;
					if( w2y >= W2EndList ) goto loopback;
					for(z=1;z<=12;++z) FmW2Dn();
					if(W2Offset != OffsetHolder) FmW2Refresh();
					goto cursor;
			case UPARROW:
					if( w2y==1 ) goto loopback;
					--w2y;
					if(w2y-W2Offset < 1) {
						--W2Offset;
						FmW2Refresh();
					}
					goto cursor;
			case DOWNARROW:
				if( w2y >= W2EndList ) goto loopback;
				++w2y;
				if(w2y-W2Offset > 10) {
					++W2Offset;
					FmW2Refresh();
				}
				goto cursor;
			case LEFTARROW: ++w2x; /* to erase cursor */
					FmW2Cursor();
					return(1); /* MenuGetKeyboardInput(); */
			case RIGHTARROW: ++w2x;
					FmW2Cursor();
					return(2);  /* will be routed to FmW1Active() */
							  /* by MenuGetKeyboardInput */
			case CTRL_F1: Screenshot792("Menu8.bmp");
				goto loopback;
			case CTRL_F2: Screenshot1024("Menu10.bmp");
				goto loopback;
			default: goto loopback;
		}
	} while(1);
cursor:
	FmW2Cursor();
	goto loopback;
	return(0);
}
void MenuCursor()
{
	int q,z;

	cx=341-6;
	for( z=0; z<dx-1; ++z) {
		q=KeyInStr[z];
		cx=cx+ Font21[q] -65;
		}
	cy=149+33;
	xor_mode(TRUE);
	rectfill(screen,cx+6,cy-10,cx+14,cy-8, WHITE);
	xor_mode(FALSE);
}
void MenuDisplayInputString()
{
	rectfill(screen,342,149,520,149+32,BLACK);
	PutsFont21(344,149,PALEBLUE,KeyInStr);
}
void MenuCursorLeft()
{
	if( dx==1 ) return;
	--dx;
}
void MenuCursorRight()
{
	k=strlen( KeyInStr );
	if( dx > k ) return;
	++dx;
}
void MenuDel()
{
	int z;

	k= strlen( KeyInStr );
	if( dx > k ) return;
	for( z=dx-1; z < k; ++z) {
		KeyInStr[z]=KeyInStr[z+1];
	}
	MenuDisplayInputString();
}
void MenuBS()
{
	int z;

	if( dx <= 1 ) return;
	MenuCursorLeft();
	k= strlen( KeyInStr );
	for( z=dx-1; z < k; ++z) {
		KeyInStr[z]=KeyInStr[z+1];
	}
	MenuDisplayInputString();
}
void MenuDisplayChar()
{
	int q,z;

	if( c < 32 ) return;
	c=toupper(c);
	q=StrLenFont21(KeyInStr);
	k=strlen(KeyInStr);
	if(k>11) return;
	if(dx < k &&  q > 600) return;

	if(dx < k) for(z=k; z >= dx; --z) KeyInStr[z]=KeyInStr[z-1];
	if(!(dx-1 > k))	KeyInStr[dx-1] =( c );
	MenuDisplayInputString();
	MenuCursorRight();
}
int MenuGetKeyboardInput()
{
/* get typed input or jump among the folder tree, file list, and
input line */

	int Result;
	char path_holder[100];

	strcpy(path_holder,PathName);

	dx=1;
loopback2:
	FmUpperElbowSignage();
	FmInputLine();
	MenuDisplayInputString();
loopback:
	MenuCursor();
	do {
		c=GetKey();
		MenuCursor();
		switch( c )
		{
			case ESC: strcpy(Mode,"ESC");
					return(0);
			case 13: if(strlen(KeyInStr) > 12) goto loopback;
					strcpy( NewName, KeyInStr);
					FmExportInfo();
					if( ! exists(PathName) && strcmp(Mode, "OPEN")==0) {
						strcpy(PathName, path_holder);
						goto loopback;
					} else return(0);
			case BS: MenuBS();
					goto loopback;
			case LEFTARROW: MenuCursorLeft();
					goto loopback;
			case RIGHTARROW: /* if(KeyInStr[dx-1]=='.') goto loopback; */
					MenuCursorRight();
					goto loopback;
			case DOWNARROW: /* if(NumOfFiles==0) goto loopback; */
					rectfill(screen,120,138,520,149+32,BLACK);
					FmLowerElbowSignage();
toW2:			 Result=FmW2Active();
					if( Result==0 ) return(0);
					if( Result==1 ) goto loopback2;
					if( Result==2 ) {
						Result=FmW1Active();
						if( Result==0 ) return(0);
						if( Result==1 ) goto loopback2;
						if( Result==2 ) goto toW2;
					}
						else goto loopback;
			case DELKEY: /*	if(KeyInStr[dx-1]=='.') goto loopback; */
					MenuDel();
					goto loopback;
			case PGUPKEY:
			case PGDNKEY:
			case UPARROW: goto loopback;
			default:	 if( c >= 315) goto loopback;
					if(c=='\\' || c==':') {
PutsLuna(138,86,PALEBLUE,BLACK,"DO NOT TYPE IN A DRIVE LETTER OR PATH.  SELECT BELOW.");
						goto loopback;
					}
					if( is_filechar(c)) {
						 c=toupper(c);
						MenuDisplayChar();
					}
					goto loopback;
		}
	} while(1);
}
void FmScreen()
{
	rectfill(screen,0,0,800,600,BLACK);
	Brackets1(MANGO, PALEBLUE);
	FmBottomFill(MANGO);
	FmMessageBox1a(PURPLE);
	FmMessageBox2a(ORANGE);
	FmEscButton();
	MarsF(487,10,2, ORANGE,BLACK,"SPECIFY FILENAME");
	PutsLuna(138,86,BIGBLUE,BLACK,"DO NOT TYPE IN A DRIVE LETTER OR PATH.  SELECT BELOW.");
}
void FmInit()
{
	Oldw1x=1;
	Oldw1y=2;
	Oldw2y=2;
	w2y=1;
	w1y=2;
	W1Current=2;
	W1Offset=0;
	W2Offset=0;
	dx=1;
	strcpy(ExistingFile,"NONE");
	W1Current=0;
	strcpy(PathName,"C:\\LCARS24\\DATA\\");
}
int FileMenu(char *FnExt)
{
	int Result;

	FmScreen();
	FmInit();
	w1y=FmShowFolders();
	FmW1Init();
	Oldw1y=w1y;
	W1Current=w1y;
	if(w1y>9) W1Offset=w1y-2;
	FmW1Refresh();

/*	FmW1Open(FnExt);  */
	memset(KeyInStr,(null),80);
	strcpy(KeyInStr,".");
	strcat(KeyInStr,FnExt);
/*	FmSelectFolder(451,236,"DRIVE C:",PALEBLUE);
	FmSelectFolder(603,236,"DRIVE A:",PALEBLUE);
*/
	ButtonType3(524, 132+14, MANGO, ORANGE, Mode);
	EnterSymbol(524+118, 132+14, 2, NAPLES);

Result=GetKey();
strcpy(Mode, "ESC");
return(0);


	FmFindFiles("C:");
	itoa(NumOfFiles,Content,10);
	PutsScorpio(566-(strlen(Content)*10), 238, ORANGE,Content);
	FmCheckFloppy();
	Result=MenuGetKeyboardInput();
	return( Result );
}

/* eof */


