/* 12/14/09 */
/* BMI.C, an embedded LCARS 24 applet to calculate
   human body-mass index, in metric or U.S. units
*/



#include "bmi.h"


float BodyMassIndex(unsigned short height, unsigned short weight)
{
	/* Returns the Body Mass Index (BMI) for height in inches and
	** weight in pounds. BMI is weight in kilograms divided by height
	** in meters squared. Returns -1 if invalid height entered.
	*/

	/* Define the metric conversion constants... */

#define LBperKG		2.2046f
#define INCHperM	39.37f
#define CFACTOR		((INCHperM * INCHperM) / LBperKG)

	float bmi;

/* Make sure height is not 0 and is 'reasonable' (100?) */
	if(height < 1 || height > 100) return -1;

/* return(short)((((float)weight*CFACTOR)/(height*height))+0.5f); */
	bmi=(weight*CFACTOR)/(height*height) +0.5f;
	return(bmi);

}
float MetricBodyMassIndex(int height, int weight)
{
	float meters,cm,bmi;

	/* Returns the Body Mass Index (BMI) for weight in kilograms divided
	** by height in meters squared. Returns -1 if invalid height entered.
	*/
	if(height < 1 || height > 254) return -1;

	cm=height;
	meters=cm/100;
/* return(short)((((float)weight)/(meters*meters))+0.5f); */
	bmi=weight/(meters*meters) +0.5f;
	return(bmi);
}
void BmiMessageBox1a(int Hue)
{
	int boxtop;

	boxtop = 10;
	rectfill(screen,10,boxtop,110,boxtop+54, Hue);
	PutsLuna(14,boxtop+35, BLACK, Hue, "CLOSE");
	PutsLuna(91,boxtop+35, BLACK, Hue, "F12");
}
void BmiMessageBox2aUS(int Hue)
{
	int boxtop;

	boxtop = 68;
	rectfill(screen,10,boxtop,110,boxtop+54, Hue);
	PutsLuna(14,boxtop+35, BLACK, Hue, "METRIC UNITS");
	PutsLuna(96,boxtop+35, BLACK, Hue, "F9");
}
void BmiMessageBox2aMetric(int Hue)
{
	int boxtop;

	boxtop = 68;
	rectfill(screen,10,boxtop,110,boxtop+54, Hue);
	PutsLuna(14,boxtop+35, BLACK, Hue, "U.S. UNITS");
	PutsLuna(96,boxtop+35, BLACK, Hue, "F9");
}
void BmiScreen()
{
	rectfill(screen,0,0,800,600, BLACK);
	Brackets1(BIGBLUE, PALEBLUE);
	BmiMessageBox1a(LILAC);
	BmiMessageBox2aUS(PALEBLUE);
	rectfill(screen,10,308,110,500,BIGBLUE);
	rectfill(screen,10,504,110,589,PALEBLUE);

	MarsF(780-(StrLenScorpio("BODY-MASS INDEX")*2),10,2, ORANGE,BLACK,"BODY-MASS INDEX");
	PutsLuna(780-(StrLenScorpio("BODY-MASS INDEX")*2),110-28,PURPLE,BLACK,"INTERNATIONAL MEDICAL STANDARD FOR RELATIVE BODY WEIGHT");

	PutsLuna(234-94,14,BRICK,BLACK,"MOVE POINTER: ");
	LeftArrowSymbol(220,14,BRICK);
	PutsLuna(240,14,BRICK,BLACK,"/");
	RightArrowSymbol(250,14,BRICK);

	PutsLuna(140,36,BRICK,BLACK,"VALUE +/- ");
	PutsLuna(195,36,BRICK,BLACK,"-: ");

	UpArrowSymbol(220, 36, BRICK);
	PutsLuna(240,36,BRICK,BLACK,"/");
	DownArrowSymbol(250, 36, BRICK);

	PutsLuna(140,58,BRICK,BLACK,"JUMP: ");
	EnterSymbol(220,58,1,BRICK);

	PutsLuna(81,286, BLACK, PALEBLUE, "GUIDE");

	PutsFont19(140,314,BRICK,"Underweight");
	PutsFont19(140,314+32,BRICK,"Ideal");
	PutsFont19(140,314+64,BRICK,"Acceptable");
	PutsFont19(140,314+96,BRICK,"Overweight");
	PutsFont19(140,314+128,BRICK,"Obese");
	PutsFont19(140,314+160,BRICK,"Morbidly Obese");

	PutsScorpio(300,274,MANGO,"Women");
	PutsFont19(300,314,MANGO," < 19");
	PutsFont19(300,314+32,MANGO,"19-21");
	PutsFont19(300,314+64,MANGO,"21-25");
	PutsFont19(300,314+96,MANGO,"25-30");
	PutsFont19(300,314+128,MANGO,"30-40");
	PutsFont19(300,314+160,MANGO," > 40");

	PutsScorpio(400,274,PALEBLUE,"Men");
	PutsFont19(400,314,PALEBLUE," < 20");
	PutsFont19(400,314+32,PALEBLUE,"20-22");
	PutsFont19(400,314+64,PALEBLUE,"22-25");
	PutsFont19(400,314+96,PALEBLUE,"25-30");
	PutsFont19(400,314+128,PALEBLUE,"30-40");
	PutsFont19(400,314+160,PALEBLUE," > 40");

	PutsScorpio(500,274,ORANGE,"Disease Risk");
	PutsFont19(500,314,ORANGE,"Very High to Moderate");
	PutsFont19(500,314+32,ORANGE,"Very Low");
	PutsFont19(500,314+64,ORANGE,"Low");
	PutsFont19(500,314+96,ORANGE,"Moderate");
	PutsFont19(500,314+128,ORANGE,"High");
	PutsFont19(500,314+160,ORANGE,"Very High");
}
void BmiCellInput_Cursor(int Cell_x, int Cell_y, int CellNum, int DecimalPlace)
{
	int gx,gy;

	gx=Xhook+92+(Cspace*CellNum)-(Cell_x*8);
	if(DecimalPlace != 0 && Cell_x >= DecimalPlace) gx += 2;
	gy=Yhook+27;
	UpArrowHead( gx, gy, MANGO);
}
void BmiPostxy(int x,char *Str)
{
	--x;
	rectfill(screen,Xhook+50+(Cspace*x),Yhook,Xhook+108+(Cspace*x),Yhook+38,BLACK);
	PutsFont21(Xhook+99+(Cspace*x)-StrLenFont21(Str),Yhook+2,MANGO,Str);
}
void BmiUpperLabels()
{
	PutsFont21(Xhook+74,Yhook-32,PALEBLUE,"Height");
	PutsFont21(Xhook+74+Cspace,Yhook-32,PALEBLUE,"Weight");
	PutsFont21(Xhook+74+(Cspace*2),Yhook-32,PALEBLUE,"Body-Mass Index");
}
void BmiUnitLabels(char *HeightUnit, char *WeightUnit)
{
	rectfill(screen,Xhook+112,Yhook,Xhook+Cspace,Yhook+30,BLACK);
	PutsFont21(Xhook+114,Yhook+2,MANGO,HeightUnit);
	rectfill(screen,Xhook+112+Cspace,Yhook,Xhook+(Cspace*2),Yhook+30,BLACK);
	PutsFont21(Xhook+114+Cspace,Yhook+2,MANGO,WeightUnit);
}
int BmiWindowActive()
{
	int PlaceVal = 1;
	int Cell_x = 1;
	int Cell_y = 9;
	int CellNum = 0; /* the input cell, hex or dec */
	int HeightVal = 72;
	char Height[4];
	int WeightVal=160;
	char Weight[4];
	float BmiVal=0;
	char Bmi[16];
	char BmiUnitType = 0;

	PutsFont21(140,Yhook+2,ORANGE,"INPUT:");
	BmiUpperLabels();
	BmiUnitLabels("inches", "pounds");
	PanelBeep();

loopback:
	if(BmiUnitType==0) BmiVal=BodyMassIndex(HeightVal, WeightVal);
		else BmiVal=MetricBodyMassIndex(HeightVal, WeightVal);
	itoa(HeightVal,Height,10);
	itoa(WeightVal,Weight,10);
	sprintf(Bmi,"%.2f",BmiVal);
	if(BmiVal<0) strcpy(Bmi,"--");
	BmiPostxy(1,Height);
	BmiPostxy(2,Weight);
	BmiPostxy(3,Bmi);
	BmiCellInput_Cursor(Cell_x, Cell_y, CellNum,0);
	CheckBeep();
silent:
	do {
		UpdateIdle();
	} while(!keypressed());
	c = GetKey();
	switch( c )
		{
			case F12: return(0);
			case 13: CellNum = !CellNum;
					Cell_x = 1;
					PlaceVal = 1;
					goto loopback;
			case LEFTARROW:
					if(CellNum == 1 && Cell_x < 3) {
						++Cell_x;
						PlaceVal = PlaceVal*10;
						goto loopback;
					}
					if(CellNum == 0 && Cell_x < 3) {
						++Cell_x;
						PlaceVal = PlaceVal*10;
						goto loopback;
					}
					goto silent;
			case RIGHTARROW:
					if(CellNum == 1 && Cell_x > 1) {
						--Cell_x;
						PlaceVal = PlaceVal/10;
						goto loopback;
					}
					if(CellNum == 0 && Cell_x > 1) {
						--Cell_x;
						PlaceVal = PlaceVal/10;
						goto loopback;
					}
					goto silent;
			case DOWNARROW:
	if(CellNum == 0 && Height[strlen(Height)-Cell_x] > 48) HeightVal -= PlaceVal;
	if(CellNum == 1 && Weight[strlen(Weight)-Cell_x] > 48) WeightVal -= PlaceVal;
					if( HeightVal < 20 ) HeightVal = 20;
					if( WeightVal < 0 ) WeightVal = 0;
					goto loopback;
			case UPARROW:
	if(CellNum == 0 && Height[strlen(Height)-Cell_x] != 57) HeightVal += PlaceVal;
	if(CellNum == 1 && Weight[strlen(Weight)-Cell_x] != 57) WeightVal += PlaceVal;
					if(HeightVal > 999) HeightVal = 999;
					if(WeightVal > 999) WeightVal = 999;
					goto loopback;
			case F9: if(BmiUnitType==0) {
					BmiUnitType=1;
					BmiMessageBox2aMetric(PURPLE);
					BmiUnitLabels("centimeters", "kilograms");
					HeightVal=(HeightVal*2.54)+0.5;
					WeightVal=(WeightVal*0.4536)+0.5;
				} else {
					BmiUnitType=0;
					BmiMessageBox2aUS(PALEBLUE);
					BmiUnitLabels("inches", "pounds");
					HeightVal=HeightVal/2.54;
					WeightVal=(WeightVal/0.4536);
				}
				BeepSet=TRUE;
				goto loopback;
			case CTRL_F1: Screenshot792("BMI8.bmp");
			goto loopback;
			case CTRL_F2: Screenshot1024("BMI10.bmp");
			goto loopback;
			case F10: return(0);
			default: goto loopback;
		}
}
int BmiMode()
{
	int Result;

	rectfill(screen,0,0,0,0,BLACK);
	BmiScreen();
	Result = BmiWindowActive();
	return(Result);
}
/* eof */


