/* Clock & calendar module and main for LCARS 24			 		*/
/* Displays a gray wrapper visible on 1024 x 768 screens, but 		*/
/* off-screen on 800 x 600 laptops or other TFT monitors.			*/
/* Added help for Math, eliminated the help box for DOS access 		*/
/* First public release 07/26/03 									*/

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "standby.h"


int main(int argc, char *argv[])
{
	char LocalPath[80];
	int c;
	char *Filename;
	char  SkipIntro=FALSE;
	char Arg1[5];
	char NextCal;

	LcarsInit();
	strcpy(LcarsExeName,get_filename(argv[0]));
	LcarsExeName[strlen(LcarsExeName)-4]=(null);


	ScreenSize=1024;
	if(argc >1 && (stricmp("800", argv[1])==0)) ScreenSize=800;
	if(argc >2 && (stricmp("skip", argv[2])==0)) SkipIntro=TRUE;

	FindVoiceFiles();
	FindBeepFiles();
	srand((unsigned int)time(0));
	FindGifFiles();
	allegro_init();
	i_love_bill=TRUE; /* This lie supposedly makes Windows slightly less hostile. */


	SettingType=0;
	SingleAlarmOnOff=0;
	MidiPlaying=0;
	DriveChange=0;
	DirectoryChange=0;
	CurrentDrive=2;

	FindOS();
	install_timer();
	__djgpp_set_ctrl_c(0);
	strcpy(LocalPath, argv[0]);
	Filename=get_filename(LocalPath);
	memset(LcarsPath,(null),80);
	strncpy(LcarsPath, LocalPath, strlen(LocalPath)-strlen(Filename)-1);
	strcpy(LcarsPath,fix_filename_slashes(LcarsPath));

	LoadAlarm();
	GrSet();
	LcarsColors();
	TimeColor=NAPLES;
	FindCurrentBracketColors();
	BuildAlarmString();
	LoadFont14();
/*	LoadFont15(); */
	if(SkipIntro==TRUE) {
		Brackets1(BracketColor1, BracketColor2);
		Boxes();
		Wrapper(60,30);
		LoadScorpioFont();
		LoadFont21();
		LoadFont19();
/*		LoadWeb11(); */
		LoadArial10();
		LoadMono13();
		if(__file_exists("C:\\LCARS24\\APPSLIST.TXT")) {
			strcpy( CurrentFile, "C:\\LCARS24\\APPSLIST.TXT" );
			LoadAppList();
		}
		if(! ( __file_exists("c:\\lcars24\\system\\dos-ver.txt")))
			system("ver>C:\\LCARS24\\SYSTEM\\DOS-VER.TXT");
		strcpy(CurrentFile,"C:\\LCARS24\\SYSTEM\\DOS-VER.TXT");
		LoadTextFile();
		strcpy(DosVerStr,Ln[1]);
/*		LoadWebFont("Web11.sff"); */
		LoadMapFonts();
	}
	atexit(DoLaunch);

restart: NextCal=1;
	if(SkipIntro==FALSE) Intro();
	old_sec=70;
	min_old=70;
	day_old=32;
	SnoozeAlarmMin=70; /* ensure calendar update */
	AlarmDisplay();
/*	TimerSetLoadSettings();  */

loopback:
	do {
		if(PutTime(164,264,10)==0) goto restorecalendar;

		if( SingleAlarmOnOff==1 ) {
			if( Hours==AlarmHour && Minutes==AlarmMin ) {
				SingleAlarmOnOff=0;
				RedAlert();
				FindCurrentBracketColors();
				Box2a(BracketColor2,"ALARM ON");
				min_old=70;
				TimeColor=NAPLES;
				goto loopback;
			}
		}
		if(Minutes==SnoozeAlarmMin) {
			SingleAlarmOnOff=0;
			RedAlert();
			SnoozeAlarmMin=70;
			min_old=70;
			TimeColor=NAPLES;
			FindCurrentBracketColors();
			Box2a(BracketColor2,"ALARM ON");
			goto loopback;
		}
	} while (!kbhit());
	c=GetKey();
	switch( c )
	{
		case F12:       /* LCARS shutdown */
/* discontinuing making of launch.bat at exit */
				Relaunch=FALSE;
/*
				strcpy(Ln[0],"@echo off");
				strcpy(Ln[1],"echo LCARS 24--Don't leave spacedock without it!");
				strcpy(Ln[2],"echo on");
				strcpy(Ln[3],"");
				EndText=3;
				strcpy(CurrentFile, "LAUNCH.BAT");
				SaveTextFile();
*/
/* make lc.bat, for option user quick launch */
				strcpy(Ln[0],LcarsExeName);
				strcat(Ln[0]," ");
				itoa(ScreenSize,Arg1,10); /* display size previously specified by the user */
				strcat(Ln[0],Arg1);
				strcat(Ln[0]," ");
				strcat(Ln[0],"skip"); /* skip intro */
				strcpy(Ln[1],"echo off");
				strcpy(Ln[2],"");
				EndText=2;
				strcpy(CurrentFile, "LC.BAT");
				SaveTextFile();
				chdir(LcarsPath);
				AutoShutdown();
				goto loopback;
		case F1:	SettingsMode();
				goto restorecalendar;
		case F2:	rectfill(screen,120,10,800,uy-5,BLACK);
				rectfill(screen,120,248,799,599,BLACK);
				SkipIntro=FALSE;
				goto restart;
		case F3:	FilesMode();
				BeepSet=TRUE;
				goto restorecalendar;
		case F4:	LauncherWindowActive();
				WarmRecover();
				BeepSet=TRUE;
				goto restorecalendar;
		case F5:	DataMode();
				BeepSet=TRUE;
				goto restorecalendar;
		case F6:	MathMode();
				WarmRecover();
				BeepSet=TRUE;
				goto restorecalendar;
		case F7:	TimeZoneMode();
				WarmRecover();
				BeepSet=TRUE;
				goto restorecalendar;
		case F8:	PhoneBookMode();
				WarmRecover();
				BeepSet=TRUE;
				goto restorecalendar;
		case F9:	if(BlasterOK==FALSE || AudioOff==TRUE) {
					AudioError();
					goto loopback;
				}
				if(SingleAlarmOnOff==1) {
					SingleAlarmOnOff=0;
					Box2a(BracketColor2,"ALARM ON");
				} else {
					SingleAlarmOnOff=1;
					Box2a(MANGO,"ALARM OFF");
				}
				AlarmDisplay();
				PanelBeep();
				goto loopback;
		case F11:	SpecsMode(); /* Help */
				BeepSet=TRUE;
				goto restorecalendar;
		case 32:  	GlowMode();
				Screen1(1);
				goto restorecalendar;
		case 48:	if(BlasterOK==FALSE || AudioOff==TRUE) {
					AudioError();
					goto restorecalendar;
				}
				MidiMusicMode();
				goto restorecalendar;
		case 49:	if(BlasterOK==FALSE || AudioOff==TRUE) {
					AudioError();
					goto restorecalendar;
				}
				Mp3MusicMode();
				goto restorecalendar;
		case 50:	BriefingMode();
				WarmRecover();
				goto restorecalendar;
		case 350:	Screenshot792("Stndby8.bmp");
				PanelBeep();
				goto loopback;
		case 351:	Screenshot1024("Stndby10.bmp");
				PanelBeep();
				goto loopback;
		case 27:        NextCal = !NextCal;
				NextMonthCalender(NextCal);
				goto loopback;
		default:	ScoldUser();
				goto loopback;
	}
restorecalendar:
	NextCal = 1;
	NextMonthCalender(NextCal);
	goto loopback;
}
END_OF_MAIN()

