/*	 GetKey.c, keyboard handlers for LCARS 24
	Advanced routines for normal, as well as the
	ALT, SHIFT, and CONTROL statuses, plus is_filechar()
	for DOS (uses BIOS)
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "lcars24.h"
#include "getkey.h"

int GetKey(void)
{
	int key, lo, hi, Result;

	key=bioskey(0x10);
	lo=key & 0X00FF;
	hi=(key & 0XFF00) >> 8;
	Result = ( (lo == 0) ? hi + 256 : lo );
	if(Result == 224) {
		key=key-224;
		lo=key & 0X00FF;
		hi=(key & 0XFF00) >> 8;
		return((lo == 0) ? hi + 256 : lo);
	} else return Result;
}
int ShiftKeyStatus()
{ /* returns 1 for right shift key, 2 for left, 0 for neither */
	int sk, rsk;

	sk = _bios_keybrd(_NKEYBRD_SHIFTSTATUS);
	rsk = sk & 0x001;
	if(rsk == 0) rsk = sk & 0x002;
	return(rsk);
}
int ControlKeyStatus()
{ /* test 4 if control pressed, 0 if not, to tell Ctrl-H from BS */
	int ck, rck;

	ck = _bios_keybrd(_NKEYBRD_SHIFTSTATUS);
	rck = ck & 0x004;
	return(rck);
}
int AltKeyStatus()
{ /* test 4 if control pressed, 0 if not, to tell Ctrl-H from BS */
	int ck, rck;

	ck = _bios_keybrd(_NKEYBRD_SHIFTSTATUS);
	rck = ck & 0x008;
	return(rck);
}
int is_filechar(char c)
{
	/* check if a character is valid for controlled filename input */

	 c=tolower(c);
	 return ( ((c>='0') && (c<='9')) || ((c>='a') && (c<='z')) ||
		 (c=='_') || (c==':') || (c=='?') || (c=='.') || (c=='-'));
}
/* eof */

