/*
 *	Briefing app for LCARS24
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "briefing.h"

int BrListEnd;
int BrOffset;
int BrListLength;

int LoadBriefingFile(char *filespec)
{
	int z;
	int i;
	unsigned short t;
	PACKFILE *Fp;

	for(z = 0; z < BRIEFINGLINECOUNT-1; ++z) memset(BriefingLn[z],(null),BRIEFINGLINELENGTH);

	if( ( Fp = pack_fopen(filespec, "rt") ) == NULL ) {
		return(86);
	}

	EndBriefingText = 0;
	z=0;
	i=0;
	t=32;
	do {
		if(pack_feof(Fp)) break;
		t = pack_getc(Fp);
			if( t == 13 ) {
			 z++;
			 i=0;
		}  else {
			if( i > 79 ) {
				z++;
				i=0;
			}
			BriefingLn[z][i] = (t);
			if (t> 31 || t == 9) ++i;
			if( t < 32 && t !=9 ) BriefingLn[z][i] = (null);
		}
	}  while(1);
	t=26;
	EndBriefingText = z-1;
	memset(BriefingLn[z],(t),8);
	pack_fclose( Fp );
	return(0);
}

int BrOpenOnePage(char *filespec)
{
	int Result;

	if( strnicmp("TXT", get_extension(filespec),3 )==0 ) {
			Result=LcReader(filespec);
			return(Result);
		}
	if( strnicmp("SFM", get_extension(filespec),3 )==0 ) {
			Result=LcSfml(filespec);
			return(Result);
		}
	if( strnicmp("MSD", get_extension(filespec),3 )==0 ) {
			Result=LcSfml(filespec);
			return(Result);
		}
	if( strnicmp("JPG", get_extension(filespec),3 )==0 ) {
			Result=Viewscreen(filespec);
			return(Result);
		}
	if( strnicmp("GIF", get_extension(filespec),3 )==0 ) {
			Result=Viewscreen(filespec);
			return(Result);
		}
	if( strnicmp("BMP", get_extension(filespec),3 )==0 ) {
			Result=Viewscreen(filespec);
			return(Result);
		}
}

int BrRunBriefing(char *filespec)
{
	char path[128];
	int Page, Result;
	BITMAP *bmp = create_bitmap(800,600);

	Page=0;

	strcpy(path, "C:\\LCARS24\\BRIEFING\\");
	strcat(path, filespec);

	LoadBriefingFile(path);

/* save the selection screen */
	clear_bitmap(bmp);
	blit(screen, bmp, 0, 0, 0, 0, 800, 600);

/* run the selected briefing */
next:
	Result=BrOpenOnePage(BriefingLn[Page]);
	if(Result==27) goto done;
	if(Result==32) {
		Page++;
		if( Page >= EndBriefingText) {
			goto check_auto;
		} else goto next;
	}

	if(Result==8) {
		Page--;
		if( Page < 0) Page=0;
		goto next;
	}

check_auto:

	if(Autorun >0) {
		Page=0;
		goto next;
	}
done:

	Autorun=0;

/* restore the selection screen */
	rectfill(screen,0,0,800,600, BLACK);
	blit(bmp, screen, 0, 0, 0, 0, 800, 600);
	destroy_bitmap(bmp);
/* force updating of the time display upon return */
	min_old=70;
	PePutTime(PURPLE);
	return(0);
}
void BriefingScreen()
{
	int capX;

	rectfill(screen,0,0,800,600, BLACK);
	PopsicleSticks(SEABLUE);
	capX=ColorTitle(ustrupr("SELECT FILE"),PURPLE);
	PutsLuna(capX,20,BLACK,SEABLUE,"LCARS 24 BRIEFING");
	min_old=70;
	PePutTime(PURPLE);
	DownArrowSymbol(206, 566, BLACK);
	UpArrowSymbol(231, 566, BLACK);

	PutsFont14(561,120, PURPLE,BLACK,   "T0 RUN A BRIEFING");
	PutsFont14(561,140, LAVENDER,BLACK, "Select it at left, press ENTER,");
	PutsFont14(561,160, LAVENDER,BLACK, "then press the space bar to move");
	PutsFont14(561,180, LAVENDER,BLACK, "forward, backspace to move,");
	PutsFont14(561,200, LAVENDER,BLACK, "backward, or ESC to quit.");
	ButtonType4(543, 96+(4*47), LILAC, "RUN", "ENT", NAPLES);
	ButtonType4(543, 96+(5*47), BIGBLUE, "EDIT", "F9", SEABLUE);
	ButtonType4(543, 96+(6*47), LILAC, "30-SEC AUTO", "F10", BRICK);
	ButtonType4(543, 96+(7*47), BIGBLUE, "HELP", "F11", TAN);
	ButtonType4(543, 96+(8*47), LILAC, "CLOSE", "F12", ORANGE);
}
int BriefingFiles()
{
	char label[24];
	char filecountstr[8];

	if( ! CommonMakeFileList("C:\\LCARS24\\BRIEFING\\*.TXT")) {
		NormalLoadError("C:\\LCARS24\\BRIEFING\\*.TXT");
		return(86);
	}

	CommonSortFiles();
	BrListEnd=NumOfFiles;
	BrListLength=NumOfFiles;

	itoa(NumOfFiles,filecountstr,10);
	strcpy(label, "BRIEFINGS: ");
	strcat(label, filecountstr);
	OfflineType4(60,60, LAVENDER, label);
	return(0);
}

void BriefingRefresh()
{
	int bottom,z;

	rectfill(screen,47,112,177,550, BLACK);
	bottom=NumOfFiles;
	if(bottom>18) bottom=18;

	for(z=1;z<=bottom;++z) {
		RightPutsFont19(176,88+(z*24),LAVENDER,CommonFileArray[z+BrOffset]);
	}
}

void BrCursor(char cy, char cmd)
{
	int gx,gy;

	gx=206;
	gy=90+(cy*24);
	if(cmd==0) EnterSymbol(gx,gy,1,BLACK);
		else EnterSymbol(gx,gy,1,WHITE);
}

int BriefingWindowActive()
{
	char path[128];
	int c, cy;

	cy=1;
	BrOffset=0;
	BrCursor(cy,1);
	BriefingRefresh();
	c=PanelBeep();

loopback:
	do {
		PePutTime(PURPLE);
	} while(!kbhit());
	c = GetKey();
	switch( c )
	{
		case F12:       Autorun=0;
				return(0);
		case F9:	strcpy(path, "C:\\LCARS24\\BRIEFING\\");
				strcat(path, CommonFileArray[cy]);
				if(OpenProgEdit(path) !=0) {
					BriefingScreen();
					BriefingFiles();
					BrCursor(cy,1);
					BriefingRefresh();
				}
				goto loopback;
		case F11:	OpenHelp("c:\\lcars24\\lc24apps\\briefing\\briefing.txt");
				min_old=70;
				goto loopback;
		case 13:        Autorun=0;
				BrRunBriefing(CommonFileArray[cy]);
				BriefingRefresh();
				goto loopback;
		case F10:       Autorun=30;
				TimerOldSec=70;
				BrRunBriefing(CommonFileArray[cy]);
				BriefingRefresh();
				goto loopback;
/*
		case HOMEKEY: 	if(cy==1) goto loopback;
				BrCursor(cy,0);
				cy=1;
				BrCursor(cy,1);
				BrOffset=0;
				goto loopback;
		case ENDKEY: 	if(cy==BrListEnd) goto loopback;
                                OffsetHolder = BrOffset;
				BrCursor(cy-BrOffset,0);
				cy=BrListLength;
				BrOffset=BrListEnd-10;
				if(cy < 15) BrOffset=0;
				BrCursor(cy-BrOffset,1);
				if(BrOffset != OffsetHolder) BriefingRefresh();
				goto loopback;
		case PGUPKEY: 	if(cy==1) goto loopback;
                                OffsetHolder = BrOffset;
				BrCursor(cy-BrOffset,0);
				cy-=17;
				BrOffset-=17;
				if(cy < 1) {
					cy=1;
                                        BrOffset=0;
				}
				if(cy > BrListLength) cy=BrListLength;
				BrCursor(cy-BrOffset,1);
				if(BrOffset != OffsetHolder) BriefingRefresh();
				goto loopback;
		case PGDNKEY: 	if(cy >= BrListLength) goto loopback;
				OffsetHolder = BrOffset;
				BrCursor(cy-BrOffset,0);
				cy+=17;
				BrOffset+=17;
				if(cy>=BrListEnd-17) {
					cy=BrListEnd;
					BrOffset=BrListEnd-13;
				}
				if(cy > BrListLength) {
					BrOffset-=cy-BrListLength;
  					cy=BrListLength;
				}
				if(cy < 19) BrOffset=0;
				BrCursor(cy-BrOffset,1);
				if(BrOffset != OffsetHolder) BriefingRefresh();
				goto loopback;
*/
		case UPARROW: 	if(cy==1) goto loopback;
				BrCursor(cy-BrOffset,0);
				--cy;
				if(cy-BrOffset < 1) {
					--BrOffset;
					BriefingRefresh();
				}
				BrCursor(cy-BrOffset,1);
				goto loopback;
		case DOWNARROW: if( cy >= BrListLength) goto loopback;
				BrCursor(cy-BrOffset,0);
				++cy;
				if(cy-BrOffset > 18) {
					++BrOffset;
					BriefingRefresh();
				}
				BrCursor(cy-BrOffset,1);
				goto loopback;
		case 350: 	Screenshot792("Brief8.bmp");
				c=PanelBeep();
				goto loopback;
		case 351: 	Screenshot1024("Brief10.bmp");
				c=PanelBeep();
				goto loopback;
		default: 	c=ScoldUser();
				goto loopback;
	}

}


void BrInit()
{
	min_old=70;
	BrOffset=0;
}

int BriefingMode()
{
	BrInit();
	BriefingScreen();
	if(BriefingFiles() !=0) return(86);

	SlideshowActive=TRUE;
	BriefingWindowActive();
	SlideshowActive=FALSE;
	return(0);
}

