/* 
 * compat.h -- compatibility headers for rmdp.
 *
 * This file is part of
 *
 * rmdp -- Reliable Multicast data Distribution Protocol
 * 
 * (C) 1996-1998 Luigi Rizzo and Lorenzo Vicisano
 *     (luigi@iet.unipi.it, vicisano@cs.ucl.ac.uk)
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Luigi Rizzo,
 *      Lorenzo Vicisano and other contributors.
 * 4. Neither the name of the Authors nor the names of other contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef RMDP__MISC_H
#define RMDP__MISC_H

#include<sys/time.h>

#ifdef IRIX
#include<sys/endian.h>
#endif

#ifdef HPUX
#include<sys/param.h>
#endif

#ifdef FreeBSD
#include<machine/endian.h>
#endif

#ifdef SunOS
#include<sys/types.h>
#endif

/* return time in msec */
long timestamp_m();
/* return time in usec */
long timestamp_u();
long diff_t(struct timeval b, struct timeval a);

/* return time in struct timeval */
void timestamp_t(struct timeval *t);

#define ADDRLEN	32
#define MAX_PATH 256

#define min(x,y)	(((x)>(y))?(y):(x))
#define max(x,y)	(((x)<(y))?(y):(x))

#ifdef __FreeBSD__
#include <string.h>
#else
#define bcopy(s, d, siz)	memcpy((d), (s), (siz))
#define bzero(d, siz)	memset((d), '\0', (siz))
#endif

#endif  /* RMDP__MISC_H */
