/***
 *** File: dump.c
 ***
 *** dumps the content of a 16c84
 ***/

#define EXTERN
#include "prog84.h"


void dumpProg(unsigned, unsigned);
void dumpData(unsigned, unsigned);
void dumpCfg();

int buf[8];

void dump_buf(int buf_count)
{
    int i;
    printf("D%d", buf_count);
    for(i=0; i<buf_count; i++)
	printf(" %04x", buf[i]);
    printf("\n");
}

void
start_cfg()
{
    SET(mclr, 0);
    SET(power, 1);
    SET(clock, 0);
    SET(data, 0);
    FLUSH;
    sleep(2);	/* for the serial prog. charge the capacitor */
    SET(mclr, 0);
    FLUSH;
    usleep(50000);/* for the serial prog. charge the capacitor */
    SET(mclr, 1);
    FLUSH;
    usleep(50000);
}

int
main(int argc, char *argv[])
{
    time_t now;
    int last_addr=30;

    verbose=0;

    if (argc>1 && atoi(argv[1]) < 8192)
	last_addr=atoi(argv[1]);
    progSetup();

    time(&now);
    printf("# pictools format dump file\n# created by %s on %s",
	    argv[0], ctime(&now));

    dumpCfg();
    dumpData(0, 64);
    dumpProg(0, last_addr);
    progShutdown();

    return 0;
}

void
dumpProg(unsigned min_addr, unsigned max_addr)
{
    int pic_addr=0;
    int buf_count;

    start_cfg();
    printf("A%04x\n", min_addr);

    for (pic_addr=0; pic_addr < min_addr; pic_addr++)
	incAddr();

    for (buf_count = 0 ; pic_addr < max_addr ; pic_addr++) {
	buf[buf_count ++] = readProg();
	if (buf_count >= 8) {
	    dump_buf(buf_count);
	    buf_count = 0;
	}
	incAddr();
    }
    if (buf_count)
	dump_buf(buf_count);
}


void
dumpData(unsigned min_addr, unsigned max_addr)
{
    int pic_addr;
    int buf_count;

    start_cfg();
    printf("B%04x\n", min_addr);

    for (pic_addr=0; pic_addr < min_addr; pic_addr++)
	incAddr();

    for (buf_count = 0 ; pic_addr < max_addr ; pic_addr++) {
	buf[buf_count ++] = readData();
	if (buf_count >= 8) {
	    dump_buf(buf_count);
	    buf_count = 0;
	}
	incAddr();
    }
    if (buf_count)
	dump_buf(buf_count);
}

char *xtal_names[] = {
    "LP oscillator",
    "XT Oscillator",
    "HS Oscillator",
    "RC Oscillator"
};

void dumpCfg()
{
    unsigned int id[4], fuses;
    int i;

    start_cfg();

    printf("T84  # I can only understand '84s\n");

    /* dummy load configuration command to get to cfg memory */
    loadConfiguration(0x3FFF);
    for (i=0; i<7; i++) {
	if (i<4)
	    id[i] = readProg();
	incAddr();
    }
    fuses = readProg();

    printf("I%04x %04x %04x %04x  # id locations\n",
	id[0], id[1], id[2], id[3]);

    printf("%s\n%s\n%s\nC%d 0 # %s\n",
	fuses & 0x10 ?
	    "P1 # Code protection off" : "P0 # Code protection on",
	fuses & 0x08 ?
	    "U1 # Power-Up Timer Enabled" : "U0 # Power-Up Timer disabled",
	fuses & 0x04 ?
	    "W1 # Watchdog Enabled" : "W0 # Watchdog Disabled",
	fuses & 0x03, xtal_names[fuses & 3]
	);
}
