;;------------ proc.asm -----------
;;
;; Misc. procedures for PCbridge
;; 05may93 Luigi Rizzo (luigi@iet.unipi.it)
 
    .CODE
;;-------------------------------------------------------------
;; print_string prints a set of strings using int10. Use '|' as
;;    string terminator, empty string as end of strings
;; Registers
;;	In:	DS:SI (string pointer)
;;	Out:	--
;;	Chng:	AL, CX, DX, SI, BP (INT 10h)
;;
print_string PROC
cicl:
    mov dx, [si]
    cmp dl, 80      ;; check off-limits columns
    jae  fin
    cmp dh, 25      ;; check off-limits rows
    jae fin
    add si, 2       ;; read chars in the string
    mov bp, si
    mov cx, -1
legg:
    mov al, byte ptr [si]
    inc si
    inc cx
    cmp al,'|'      ;; compare if char is delimiter parameter
    jne legg
    mov ax, 1300h
    int 10h
    mov al, byte ptr [si]
    cmp al,'|'      ;; compare if char is end of procedure
    jne cicl
fin:
    RET
print_string    ENDP
 

      .CODE
;;-------------------------------------------------------------
;; print_stat	prints quickly a counter writing to video RAM
;;    each counter is 8 bytes: 2 bytes pos, 6 bytes counter
;; Registers
;;	In:	DS:BP (counter index)
;;	Out:	ES=video segment
;;	Chng:	BX, SI, DI, BP, ES
;;
print_stat  PROC
    shl bp,3		;; address counter
    add bp, offset counter_base
print_stat_1 LABEL near	;; don't recompute BP
    mov bx,[bp]		;; bx holds Video offset
    add bp,2 		;; bp holds counter address
    mov si, 5		;; si = counter bytes to display
    mov es, pos_vdrm
back:
    mov al, [bp][si]	;; al = two digits exadecimal
    xor ah, ah
    add ax,ax
    mov di, ax		;; DI=2*AL
    mov ax, tab[di]	;; AX = ASCII code two digits to display
    mov es:[bx], al
    add bx, 2
    mov es:[bx], ah
    add bx, 2
    dec si
    jns back
print_stat_end:
    ret
PRINT_STAT     ENDP

    .CODE
;;------------------------------------------------------------
;; init_tab builds a table of hex strings
;; Registers:
;;     In: --
;;    Out: --
;; Change: all
init_tab PROC	;; builds a table of hex strings
    mov cx,0           ;; 0..255
    mov si, offset tab ;; base address
init_tab_again:
    mov al,cl          ;; high nibble first
    shr al,4
    and al,0fh
    cmp al,10
    jb good_h
    add al,7
good_h:
    mov ah,cl
    and ah,0fh
    cmp ah,10
    jb good_l
    add ah,7
good_l:
    add ax,3030h
    mov [si],ax
    inc si
    inc si
    inc cx
    cmp cx,256
    jb init_tab_again
    ret
init_tab ENDP


    .CODE
;;----------------------------------------------------
;; print_mask  print the startup screen after cleaning page 0
;; uses BIOS 10h
;; Registers: 
;;     In: --
;;    Out: --
;; Change: all
print_mask PROC
    mov es, pos_vdrm           ;; es = video ram segment. First try mono
    mov byte ptr es:0, 0aah
    cmp byte ptr es:0, 0aah
    je found_vdrm
    mov pos_vdrm, 0b800h	;; then try color..
    mov es, pos_vdrm
    mov byte ptr es:0, 0aah
    cmp byte ptr es:0, 0aah
    je found_vdrm
    ;; mov pos_vdrm,0	;; not found...
found_vdrm:
    mov cx, 800h         ;; clear video memory
    xor di, di
    mov ax, 0e20h        ;; bleu background, write ' '
    rep stosw            ;; write in video memory
    mov ax, cs           ;; ES:si points to the string
    mov es, ax
    mov bx, 000eh        ;; black background, yellow char
    mov si, offset banner
    CALL print_string
    push ds
    pop es
    mov si, offset banner+2; bridge name...
    mov di, offset magic_string
    mov cx,15
    rep movsb
    mov byte ptr [di],0
    ret
print_mask ENDP

;; Print working cards
    .CODE
print_cards PROC
    FOR idx, <1,2,3,4,5> ;; might be more...
	LOCAL no_work
	IFDEF c_wde_&idx&_declared or c507_&idx&_declared
	    cmp if_found[idx], 0
	    jz no_work
	    mov bp, offset pos_&idx&_ha
	    CALL print_stat_1
	no_work:
	ENDIF    ;; wde_&idx&_declared....
    ENDM
    ret
print_cards	ENDP

PCBRIDGE_SPORT	EQU	2299
PCBRIDGE_CPORT	EQU	2298

	.CODE
;;----------------------------------------------------
;; make_pkt prepares a packet for output
;; In:	DS=data segment, BX=Interface number (1...5), DI=out_pkt
;;Chg:	AX, BX, CX, DI, SI, ES

make_pkt PROC
	push ds
	pop es
;;---------- build ethernet header --------------
	mov ax,0ffffh		;; broadcast
	stosw
	stosw
	stosw
	mov port_id,bl		;; port identity. Do it now,
	shl bx,3
	lea si, if_address[bx]	;; start of eth. address
	movsw
	movsw
	movsw
	mov ax, 8h		;; htons(DOD_IP_TYPE)
	stosw
;;----------------- build ip header ----------------------
	mov ax,45h ;; htons(0x4500: VERS 4, IHL 5, TOS 0)
	stosw
	mov ax,eth_pkt_size-14 ;;
	xchg ah,al
	stosw
	mov ax, 1234h ;; ID, sequential number
	xchg ah,al
	stosw
	mov ax,0 ;; flags, fragment offset
	stosw
	mov ax,110fh;;  (ttl=0fh, protocol=0x11, UDP)
	stosw
ETH_CHKSUM	EQU (4500h+eth_pkt_size-14+1234h+0f11h);; mod 65535
	mov ax,0ffffh-ETH_CHKSUM
	xchg ah,al
	stosw
	mov ax,0h ;; src. address
	stosw
	stosw
	mov ax,0ffffh ;; dest. address
	stosw
	stosw
;;----------------- build udp header ------------------
	mov ax, PCBRIDGE_CPORT ;; src port.
	xchg ah,al
	stosw
	mov ax, PCBRIDGE_SPORT ;; dst port.
	xchg ah,al
	stosw
	mov ax,eth_pkt_size-34 ;; no PHYS and IP headers
	xchg ah,al
	stosw
	mov ax,0 ;; no checksum
	stosw
	ret
make_pkt ENDP

;;------------------------------------------------------------
;; process_pkt processes incoming packets.
;; Registers: 
;;     In: ES:BX buffer, CX=len, BP=input port index
;;    Out: --
;; Change: all
process_pkt	PROC
    cmp word ptr es:[bx+36], LOW(PCBRIDGE_CPORT)*256+HIGH(PCBRIDGE_CPORT)
    jne process_pkt_end
    cmp word ptr es:[bx+42], 'L'+ 'R'*256 ;; magic number
    jne process_pkt_end
    cmp byte ptr es:[bx+23], 11h ;; UDP type
    jne process_pkt_end
    cmp word ptr es:[bx+12], 8 ;; IP type
    jne process_pkt_end
    ;; have an IP pkt for me
    ;; bx+46= command. Command codes are:
    ;; 0: dump data segment (256 bytes, offset at bx+48)
    ;; 1: dump filter table (256 bytes, offset at bx+48)
    ;; 2: flush filter table
    ;; 3: cold reset of the bridge
    ;; bx+48 has memory address to dump
    mov ax, word ptr es:[bx+48]
    xchg ah,al	;; htons
    mov si, ax	;; source address
    mov table_data_off,si
    lea di,table_data ;; dest. address
    mov ax,word ptr es:[bx+46]
    xchg ah,al	;; htons
    mov bp, ds ;; save data segment
    mov es,bp	;; set dest. segment
    cmp al,0 ;; dump_data_seg
    jz dump_data_segment
    cmp al,1 ;; dump_table_seg
    jz dump_table_segment
    cmp al,2 ;; flush table
    jz flush_table
    cmp al,3 ;; reset bridge
    ;; jz reset_bdg ;; Uncomment this only if you really want it
    jmp process_pkt_end
reset_bdg:
    push 0f000h
    push 0fff0h
    retf

flush_table:
    mov es, bdg_table_ptr
    xor DI, DI
    mov CX, 32768 ;; table size
    mov ax, 0ffffh ;; clean the table. No card has address FFFFFFFFFFFF
    rep stosw ;; default - forward
    jmp process_pkt_end1

dump_table_segment:
    mov ax, bdg_table_ptr
    mov ds, ax ;; source is table
dump_data_segment:
    mov cx, 256
    rep movsw
process_pkt_end1:
    mov ds,bp	;; restore ds
process_pkt_end:
    ret
process_pkt	ENDP


;;------------------------------------------------------------
;; inchksum computes checksum for a packet. Isn't used yet.
;; In: DS:SI ; buffer pointer, CX=count (bytes)
;; Out: AX=checksum
;; Change: AX, CX, DX, SI
inchksum	PROC
    mov bl,cl ; save low bit for the end
    shr cx,1  ; group into words
    xor dx,dx ; clear sum
    clc	;;	in case xor doesn't do it
chk_loop:
    lodsw
    adc dx,ax
    loop chk_loop
    adc dx,0
    adc dx,0
    and bl,1
    jz chk_end
    xor ah,ah
    lodsb
    add dx,ax
    adc dx,0
    adc dx,0 ;; is it really necessary ?
chk_end:
    mov ax,dx
    ret
inchksum	ENDP
;; end of file stat.asm
;; --------- end of file --------------
